/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.Descriptors;
import com.google.protobuf.UnsafeByteOperations;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.util.ArrayFactoryImpl;
import org.apache.calcite.avatica.util.Base64;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;

public class TypedValue {
    private static final Descriptors.FieldDescriptor NUMBER_DESCRIPTOR = Common.TypedValue.getDescriptor().findFieldByNumber(4);
    private static final Descriptors.FieldDescriptor STRING_DESCRIPTOR = Common.TypedValue.getDescriptor().findFieldByNumber(3);
    private static final Descriptors.FieldDescriptor BYTES_DESCRIPTOR = Common.TypedValue.getDescriptor().findFieldByNumber(5);
    public static final TypedValue EXPLICIT_NULL = new TypedValue(ColumnMetaData.Rep.OBJECT, null);
    public static final Common.TypedValue PROTO_IMPLICIT_NULL = Common.TypedValue.newBuilder().setImplicitlyNull(true).build();
    public final ColumnMetaData.Rep type;
    public final Object value;
    public final ColumnMetaData.Rep componentType;

    private TypedValue(ColumnMetaData.Rep rep, Object value) {
        this(rep, null, value);
    }

    private TypedValue(ColumnMetaData.Rep rep, ColumnMetaData.Rep componentType, Object value) {
        this.type = rep;
        this.componentType = componentType;
        this.value = value;
        assert (this.isSerial(rep, value)) : "rep: " + (Object)((Object)rep) + ", value: " + value;
    }

    private boolean isSerial(ColumnMetaData.Rep rep, Object value) {
        if (value == null) {
            return true;
        }
        switch (rep) {
            case BYTE_STRING: {
                return value instanceof String;
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                return value instanceof Integer;
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                return value instanceof Long;
            }
        }
        return true;
    }

    @JsonCreator
    public static TypedValue create(@JsonProperty(value="type") String type, @JsonProperty(value="value") Object value) {
        if (value == null) {
            return EXPLICIT_NULL;
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.valueOf(type);
        return TypedValue.ofLocal(rep, TypedValue.serialToLocal(rep, value));
    }

    public static TypedValue ofLocal(ColumnMetaData.Rep rep, Object value) {
        return new TypedValue(rep, TypedValue.localToSerial(rep, value));
    }

    public static TypedValue ofSerial(ColumnMetaData.Rep rep, Object value) {
        return new TypedValue(rep, value);
    }

    public static TypedValue ofJdbc(ColumnMetaData.Rep rep, Object value, Calendar calendar) {
        if (value == null) {
            return EXPLICIT_NULL;
        }
        if (ColumnMetaData.Rep.ARRAY == rep) {
            if (null != value && !(value instanceof Array)) {
                throw new IllegalArgumentException("Provided Rep was ARRAY, but the value was " + value.getClass());
            }
            Array array = (Array)value;
            try {
                SqlType type = SqlType.valueOf(array.getBaseType());
                Object serialValue = TypedValue.jdbcToSerial(rep, array, calendar, type);
                return new TypedValue(rep, ColumnMetaData.Rep.nonPrimitiveRepOf(type), serialValue);
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not extract Array component type", e);
            }
        }
        Object serialValue = TypedValue.jdbcToSerial(rep, value, calendar);
        return new TypedValue(rep, serialValue);
    }

    public static TypedValue ofJdbc(Object value, Calendar calendar) {
        if (value == null) {
            return EXPLICIT_NULL;
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(value.getClass());
        return new TypedValue(rep, TypedValue.jdbcToSerial(rep, value, calendar));
    }

    public Object toLocal() {
        if (this.value == null) {
            return null;
        }
        return TypedValue.serialToLocal(this.type, this.value);
    }

    private static Object serialToLocal(ColumnMetaData.Rep rep, Object value) {
        assert (value != null);
        if (value.getClass() == rep.clazz) {
            return value;
        }
        switch (rep) {
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case SHORT: {
                return ((Number)value).shortValue();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: 
            case INTEGER: {
                return ((Number)value).intValue();
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: 
            case LONG: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case NUMBER: {
                return value instanceof BigDecimal ? value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : (value instanceof Double ? new BigDecimal((Double)value) : (value instanceof Float ? new BigDecimal(((Float)value).floatValue()) : new BigDecimal(((Number)value).longValue()))));
            }
            case BYTE_STRING: {
                return ByteString.ofBase64((String)value);
            }
            case ARRAY: {
                return value;
            }
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to " + (Object)((Object)rep));
    }

    public Object toJdbc(Calendar calendar) {
        if (this.value == null) {
            return null;
        }
        return TypedValue.serialToJdbc(this.type, this.componentType, this.value, calendar);
    }

    private static Object serialToJdbc(ColumnMetaData.Rep type, ColumnMetaData.Rep componentRep, Object value, Calendar calendar) {
        switch (type) {
            case BYTE_STRING: {
                return ByteString.ofBase64((String)value).getBytes();
            }
            case JAVA_UTIL_DATE: {
                return new java.util.Date(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_DATE: {
                return new Date(TypedValue.adjust(((Number)value).longValue() * 86400000L, calendar));
            }
            case JAVA_SQL_TIME: {
                return new Time(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_TIMESTAMP: {
                return new Timestamp(TypedValue.adjust((Number)value, calendar));
            }
            case ARRAY: {
                if (null == value) {
                    return null;
                }
                List list = (List)value;
                ArrayList<Object> copy = new ArrayList<Object>(list.size());
                for (Object o : list) {
                    if (null == o) {
                        copy.add(null);
                        continue;
                    }
                    if (o instanceof TypedValue) {
                        copy.add(((TypedValue)o).toJdbc(calendar));
                        continue;
                    }
                    copy.add(TypedValue.serialToJdbc(componentRep, null, o, calendar));
                }
                if (componentRep == null && list.size() > 0 && (componentRep = ((TypedValue)list.get((int)0)).type) == null) {
                    throw new RuntimeException("ComponentRep of element must not be null for ARRAYs");
                }
                ColumnMetaData.AvaticaType elementType = new ColumnMetaData.AvaticaType(componentRep.typeId, componentRep.name(), componentRep);
                return new ArrayFactoryImpl(calendar.getTimeZone()).createArray(elementType, copy);
            }
        }
        return TypedValue.serialToLocal(type, value);
    }

    private static long adjust(Number number, Calendar calendar) {
        long t = number.longValue();
        if (calendar != null) {
            t -= (long)calendar.getTimeZone().getOffset(t);
        }
        return t;
    }

    private static Object jdbcToSerial(ColumnMetaData.Rep rep, Object value, Calendar calendar) {
        return TypedValue.jdbcToSerial(rep, value, calendar, null);
    }

    private static Object jdbcToSerial(ColumnMetaData.Rep rep, Object value, Calendar calendar, SqlType componentType) {
        if (null == value) {
            return null;
        }
        switch (rep) {
            case BYTE_STRING: {
                return new ByteString((byte[])value).toBase64String();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: 
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                long t = ((java.util.Date)value).getTime();
                if (calendar != null) {
                    t += (long)calendar.getTimeZone().getOffset(t);
                }
                switch (rep) {
                    case JAVA_SQL_DATE: {
                        return (int)DateTimeUtils.floorDiv(t, 86400000L);
                    }
                    case JAVA_SQL_TIME: {
                        return (int)DateTimeUtils.floorMod(t, 86400000L);
                    }
                }
                return t;
            }
            case ARRAY: {
                Array array = (Array)value;
                Objects.requireNonNull(componentType, "Component Type must not be null for ARRAYs");
                try {
                    switch (componentType) {
                        case BINARY: 
                        case VARBINARY: 
                        case LONGVARBINARY: {
                            Object[] byteStrings = (Object[])array.getArray();
                            ArrayList<String> convertedStrings = new ArrayList<String>(byteStrings.length);
                            for (Object byteString : byteStrings) {
                                convertedStrings.add((String)TypedValue.jdbcToSerial(ColumnMetaData.Rep.BYTE_STRING, byteString, calendar, null));
                            }
                            return convertedStrings;
                        }
                        case DATE: 
                        case TIME: {
                            Object[] dates = (Object[])array.getArray();
                            ArrayList<Integer> serializedDates = new ArrayList<Integer>(dates.length);
                            for (Object obj : dates) {
                                java.util.Date date = (java.util.Date)obj;
                                if (null == obj) {
                                    serializedDates.add(null);
                                    continue;
                                }
                                if (componentType == SqlType.DATE) {
                                    serializedDates.add((Integer)TypedValue.jdbcToSerial(ColumnMetaData.Rep.JAVA_SQL_DATE, date, calendar, null));
                                    continue;
                                }
                                if (componentType == SqlType.TIME) {
                                    serializedDates.add((Integer)TypedValue.jdbcToSerial(ColumnMetaData.Rep.JAVA_SQL_TIME, date, calendar, null));
                                    continue;
                                }
                                throw new RuntimeException("Unexpected type: " + (Object)((Object)componentType));
                            }
                            return serializedDates;
                        }
                        case TIMESTAMP: {
                            Object[] timestamps = (Object[])array.getArray();
                            ArrayList<Long> serializedTimestamps = new ArrayList<Long>(timestamps.length);
                            for (Object obj : timestamps) {
                                Timestamp timestamp = (Timestamp)obj;
                                if (null == obj) {
                                    serializedTimestamps.add(null);
                                    continue;
                                }
                                serializedTimestamps.add((Long)TypedValue.jdbcToSerial(ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP, timestamp, calendar, null));
                            }
                            return serializedTimestamps;
                        }
                    }
                    return AvaticaUtils.primitiveList(array.getArray());
                }
                catch (SQLException e) {
                    throw new RuntimeException("Could not obtain base array object", e);
                }
            }
        }
        return value;
    }

    private static Object localToSerial(ColumnMetaData.Rep rep, Object value) {
        switch (rep) {
            case BYTE_STRING: {
                return ((ByteString)value).toBase64String();
            }
        }
        return value;
    }

    public static List<Object> values(List<TypedValue> typedValues) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (TypedValue typedValue : typedValues) {
            list.add(typedValue.toLocal());
        }
        return list;
    }

    public Common.TypedValue toProto() {
        Common.TypedValue.Builder builder = Common.TypedValue.newBuilder();
        builder.setImplicitlyNull(false);
        Common.Rep protoRep = this.type.toProto();
        if (Common.Rep.NUMBER == protoRep && this.value instanceof BigDecimal) {
            protoRep = Common.Rep.BIG_DECIMAL;
        } else if (Common.Rep.ARRAY == protoRep) {
            builder.setType(Common.Rep.ARRAY);
            Common.Rep protoComponentRep = this.componentType.toProto();
            builder.setComponentType(protoComponentRep);
            List list = (List)this.value;
            return this.serializeArray(list, builder, protoComponentRep);
        }
        TypedValue.writeToProtoWithType(builder, this.value, protoRep);
        return builder.build();
    }

    Common.TypedValue serializeArray(List<Object> list, Common.TypedValue.Builder builder, Common.Rep protoArrayComponentRep) {
        for (Object element : list) {
            if (element instanceof List) {
                List subList = (List)element;
                Common.TypedValue.Builder subListBuilder = Common.TypedValue.newBuilder();
                subListBuilder.setType(protoArrayComponentRep);
                Common.TypedValue protoSubList = this.serializeArray(subList, subListBuilder, protoArrayComponentRep);
                builder.addArrayValue(protoSubList);
                continue;
            }
            Common.TypedValue.Builder elementBuilder = Common.TypedValue.newBuilder();
            if (null == element) {
                TypedValue.writeToProtoWithType(elementBuilder, null, Common.Rep.NULL);
            } else {
                TypedValue.writeToProtoWithType(elementBuilder, element, protoArrayComponentRep);
            }
            builder.addArrayValue(elementBuilder.build());
        }
        return builder.build();
    }

    private static void writeToProtoWithType(Common.TypedValue.Builder builder, Object o, Common.Rep type) {
        builder.setType(type);
        switch (type) {
            case BOOLEAN: 
            case PRIMITIVE_BOOLEAN: {
                builder.setBoolValue((Boolean)o);
                return;
            }
            case BYTE_STRING: {
                byte[] bytes;
                if (o instanceof String) {
                    builder.setStringValue((String)o);
                    bytes = ByteString.parseBase64((String)o);
                } else {
                    builder.setStringValue(Base64.encodeBytes((byte[])o));
                    bytes = (byte[])o;
                }
                builder.setBytesValue(UnsafeByteOperations.unsafeWrap((byte[])bytes));
                return;
            }
            case STRING: {
                String s = DateTimeUtils.isOffsetDateTime(o) ? DateTimeUtils.offsetDateTimeValue(o) : (String)o;
                builder.setStringValueBytes(UnsafeByteOperations.unsafeWrap((byte[])s.getBytes(StandardCharsets.UTF_8)));
                return;
            }
            case PRIMITIVE_CHAR: 
            case CHARACTER: {
                builder.setStringValue(Character.toString(((Character)o).charValue()));
                return;
            }
            case BYTE: 
            case PRIMITIVE_BYTE: {
                builder.setNumberValue(Byte.valueOf((Byte)o).longValue());
                return;
            }
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: {
                builder.setDoubleValue((Double)o);
                return;
            }
            case FLOAT: 
            case PRIMITIVE_FLOAT: {
                builder.setNumberValue(Float.floatToIntBits(((Float)o).floatValue()));
                return;
            }
            case INTEGER: 
            case PRIMITIVE_INT: {
                builder.setNumberValue(Integer.valueOf((Integer)o).longValue());
                return;
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                builder.setNumberValue(Short.valueOf((Short)o).longValue());
                return;
            }
            case LONG: 
            case PRIMITIVE_LONG: {
                builder.setNumberValue((Long)o);
                return;
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                long sqlDateOrTime = o instanceof Date ? ((Date)o).getTime() : (o instanceof Time ? ((Time)o).getTime() : (o instanceof Integer ? ((Integer)o).longValue() : ((Long)o).longValue()));
                builder.setNumberValue(sqlDateOrTime);
                return;
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                long sqlTimestampOrUtilDate = o instanceof Timestamp ? ((Timestamp)o).getTime() : (o instanceof java.util.Date ? ((java.util.Date)o).getTime() : ((Long)o).longValue());
                builder.setNumberValue(sqlTimestampOrUtilDate);
                return;
            }
            case BIG_INTEGER: {
                byte[] byteRep = ((BigInteger)o).toByteArray();
                builder.setBytesValue(com.google.protobuf.ByteString.copyFrom((byte[])byteRep));
                return;
            }
            case BIG_DECIMAL: {
                BigDecimal bigDecimal = (BigDecimal)o;
                builder.setStringValue(bigDecimal.toString());
                return;
            }
            case NUMBER: {
                builder.setNumberValue(((Number)o).longValue());
                return;
            }
            case NULL: {
                builder.setNull(true);
                return;
            }
            case OBJECT: {
                if (null == o) {
                    builder.setNull(true);
                    return;
                }
            }
            case UNRECOGNIZED: {
                throw new RuntimeException("Unhandled value: " + (Object)((Object)type) + " " + o.getClass());
            }
        }
        throw new RuntimeException("Unknown serialized type: " + (Object)((Object)type));
    }

    public static TypedValue fromProto(Common.TypedValue proto) {
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.fromProto(proto.getType());
        ColumnMetaData.Rep componentRep = ColumnMetaData.Rep.fromProto(proto.getComponentType());
        Object value = TypedValue.getSerialFromProto(proto);
        return new TypedValue(rep, componentRep, value);
    }

    public static Object getSerialFromProto(Common.TypedValue protoValue) {
        switch (protoValue.getType()) {
            case BOOLEAN: 
            case PRIMITIVE_BOOLEAN: {
                return protoValue.getBoolValue();
            }
            case BYTE_STRING: {
                if (protoValue.hasField(STRING_DESCRIPTOR) && !protoValue.hasField(BYTES_DESCRIPTOR)) {
                    return protoValue.getStringValue();
                }
                return new ByteString(protoValue.getBytesValue().toByteArray()).toBase64String();
            }
            case STRING: {
                return protoValue.getStringValue();
            }
            case PRIMITIVE_CHAR: 
            case CHARACTER: {
                return Character.valueOf(protoValue.getStringValue().charAt(0));
            }
            case BYTE: 
            case PRIMITIVE_BYTE: {
                return Long.valueOf(protoValue.getNumberValue()).byteValue();
            }
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: {
                return protoValue.getDoubleValue();
            }
            case FLOAT: 
            case PRIMITIVE_FLOAT: {
                return Float.valueOf(Float.intBitsToFloat((int)protoValue.getNumberValue()));
            }
            case INTEGER: 
            case PRIMITIVE_INT: {
                return Long.valueOf(protoValue.getNumberValue()).intValue();
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                return Long.valueOf(protoValue.getNumberValue()).shortValue();
            }
            case LONG: 
            case PRIMITIVE_LONG: {
                return protoValue.getNumberValue();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                return Long.valueOf(protoValue.getNumberValue()).intValue();
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                return protoValue.getNumberValue();
            }
            case BIG_INTEGER: {
                return new BigInteger(protoValue.getBytesValue().toByteArray());
            }
            case BIG_DECIMAL: {
                if (protoValue.hasField(NUMBER_DESCRIPTOR)) {
                    BigInteger bigInt = new BigInteger(protoValue.getBytesValue().toByteArray());
                    return new BigDecimal(bigInt, (int)protoValue.getNumberValue());
                }
                return new BigDecimal(protoValue.getStringValueBytes().toStringUtf8());
            }
            case NUMBER: {
                return protoValue.getNumberValue();
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                List<Common.TypedValue> protoList = protoValue.getArrayValueList();
                ArrayList<TypedValue> list = new ArrayList<TypedValue>(protoList.size());
                for (Common.TypedValue protoElement : protoList) {
                    TypedValue listElement = TypedValue.fromProto(protoElement);
                    list.add(listElement);
                }
                return list;
            }
            case OBJECT: {
                if (protoValue.getNull()) {
                    return null;
                }
            }
            case UNRECOGNIZED: {
                throw new RuntimeException("Unhandled type: " + (Object)((Object)protoValue.getType()));
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)protoValue.getType()));
    }

    public static Common.Rep toProto(Common.TypedValue.Builder builder, Object o) {
        if (o instanceof Byte) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.BYTE);
            return Common.Rep.BYTE;
        }
        if (o instanceof Short) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.SHORT);
            return Common.Rep.SHORT;
        }
        if (o instanceof Integer) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.INTEGER);
            return Common.Rep.INTEGER;
        }
        if (o instanceof Long) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.LONG);
            return Common.Rep.LONG;
        }
        if (o instanceof Double) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.DOUBLE);
            return Common.Rep.DOUBLE;
        }
        if (o instanceof Float) {
            TypedValue.writeToProtoWithType(builder, ((Float)o).longValue(), Common.Rep.FLOAT);
            return Common.Rep.FLOAT;
        }
        if (o instanceof BigDecimal) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.BIG_DECIMAL);
            return Common.Rep.BIG_DECIMAL;
        }
        if (o instanceof String) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.STRING);
            return Common.Rep.STRING;
        }
        if (o instanceof Character) {
            TypedValue.writeToProtoWithType(builder, o.toString(), Common.Rep.CHARACTER);
            return Common.Rep.CHARACTER;
        }
        if (o instanceof byte[]) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.BYTE_STRING);
            return Common.Rep.BYTE_STRING;
        }
        if (o instanceof Boolean) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.BOOLEAN);
            return Common.Rep.BOOLEAN;
        }
        if (o instanceof Timestamp) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.JAVA_SQL_TIMESTAMP);
            return Common.Rep.JAVA_SQL_TIMESTAMP;
        }
        if (o instanceof Date) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.JAVA_SQL_DATE);
            return Common.Rep.JAVA_SQL_DATE;
        }
        if (o instanceof Time) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.JAVA_SQL_TIME);
            return Common.Rep.JAVA_SQL_TIME;
        }
        if (DateTimeUtils.isOffsetDateTime(o)) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.STRING);
            return Common.Rep.STRING;
        }
        if (o instanceof List) {
            builder.setType(Common.Rep.ARRAY);
            builder.setComponentType(Common.Rep.OBJECT);
            boolean setComponentType = false;
            for (Object listElement : (List)o) {
                Common.TypedValue.Builder listElementBuilder = Common.TypedValue.newBuilder();
                Common.Rep componentRep = TypedValue.toProto(listElementBuilder, listElement);
                if (!setComponentType) {
                    if (Common.Rep.NULL != componentRep) {
                        builder.setComponentType(componentRep);
                    }
                    setComponentType = true;
                }
                builder.addArrayValue(listElementBuilder.build());
            }
            return Common.Rep.ARRAY;
        }
        if (o instanceof Array) {
            builder.setType(Common.Rep.ARRAY);
            Array a = (Array)o;
            try {
                ResultSet rs = a.getResultSet();
                builder.setComponentType(Common.Rep.OBJECT);
                boolean setComponentType = false;
                while (rs.next()) {
                    Common.TypedValue.Builder listElementBuilder = Common.TypedValue.newBuilder();
                    Object arrayValue = rs.getObject(2);
                    Common.Rep componentRep = TypedValue.toProto(listElementBuilder, arrayValue);
                    if (!setComponentType) {
                        if (Common.Rep.NULL != componentRep) {
                            builder.setComponentType(componentRep);
                        }
                        setComponentType = true;
                    }
                    builder.addArrayValue(listElementBuilder.build());
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Could not serialize ARRAY", e);
            }
            return Common.Rep.ARRAY;
        }
        if (null == o) {
            TypedValue.writeToProtoWithType(builder, o, Common.Rep.NULL);
            return Common.Rep.NULL;
        }
        throw new RuntimeException("Unhandled type in Frame: " + o.getClass());
    }

    public static Object protoToJdbc(Common.TypedValue protoValue, Calendar calendar) {
        Object o = TypedValue.getSerialFromProto(Objects.requireNonNull(protoValue));
        if (null == o) {
            return o;
        }
        return TypedValue.serialToJdbc(ColumnMetaData.Rep.fromProto(protoValue.getType()), null, o, calendar);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TypedValue) {
            TypedValue other = (TypedValue)o;
            if (this.type != other.type) {
                return false;
            }
            if (null == this.value) {
                return null == other.value;
            }
            return this.value.equals(other.value);
        }
        return false;
    }
}

