/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryUtils {
    private static final String PREFIX_SELECT = "select.+\\W+from\\W+";
    private static final String PREFIX_UPDATE = "update\\W+";
    private static final String PREFIX_INSERT = "insert\\W+into\\W+";
    private static final String PREFIX_DELETE = "delete\\W+from\\W+";
    private static final String PREFIX_TABLE_CREATE = "create\\W+table\\W+";
    private static final String PREFIX_TABLE_DROP = "drop\\W+table\\W+";
    private static final String PREFIX_TABLE_TRUNCATE = "truncate\\W+table\\W+";
    private static final String PREFIX_TABLE_ALTER = "alter\\W+table\\W+";
    private static final String PREFIX_INDEX_CREATE = "create\\W+(?:(hash|brin)\\W+)?index\\W+.+\\W+on\\W+";
    private static final String PREFIX_INDEX_DROP = "drop\\W+index\\W+";
    private static final Pattern TABLE_SPACE_NAME_PATTERN = Pattern.compile("(?:select.+\\W+from\\W+|update\\W+|insert\\W+into\\W+|delete\\W+from\\W+|create\\W+table\\W+|drop\\W+table\\W+|truncate\\W+table\\W+|alter\\W+table\\W+|create\\W+(?:(hash|brin)\\W+)?index\\W+.+\\W+on\\W+|drop\\W+index\\W+)(?<tablespace>\\S+\\.)?(?<tablename>\\S+)", 2);

    public static String discoverTablespace(String defaultTableSpace, String query) {
        String tableSpace;
        if (query == null) {
            return defaultTableSpace;
        }
        Matcher matcher = TABLE_SPACE_NAME_PATTERN.matcher(query);
        if (matcher.find() && (tableSpace = matcher.group("tablespace")) != null) {
            return tableSpace.substring(0, tableSpace.length() - 1);
        }
        return defaultTableSpace;
    }
}

