/*
 * Decompiled with CFR 0.152.
 */
package herddb.storage;

import herddb.log.LogSequenceNumber;
import herddb.storage.DataStorageManagerException;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IndexStatus {
    public final String indexName;
    public final LogSequenceNumber sequenceNumber;
    public final byte[] indexData;
    public final Set<Long> activePages;
    public final long newPageId;

    public IndexStatus(String indexName, LogSequenceNumber sequenceNumber, long newPageId, Set<Long> activePages, byte[] indexData) {
        this.indexName = indexName;
        this.sequenceNumber = sequenceNumber;
        this.newPageId = newPageId;
        this.indexData = indexData != null ? indexData : new byte[]{};
        this.activePages = activePages != null ? activePages : Collections.emptySet();
    }

    public void serialize(ExtendedDataOutputStream output) throws IOException {
        output.writeVLong(1L);
        output.writeVLong(0L);
        output.writeUTF(this.indexName);
        output.writeLong(this.sequenceNumber.ledgerId);
        output.writeLong(this.sequenceNumber.offset);
        output.writeVLong(this.newPageId);
        output.writeVInt(this.activePages.size());
        for (long idpage : this.activePages) {
            output.writeVLong(idpage);
        }
        output.writeArray(this.indexData);
    }

    public static IndexStatus deserialize(ExtendedDataInputStream in) throws IOException {
        long version = in.readVLong();
        long flags = in.readVLong();
        if (version != 1L || flags != 0L) {
            throw new DataStorageManagerException("corrupted index status");
        }
        String indexName = in.readUTF();
        long ledgerId = in.readLong();
        long offset = in.readLong();
        long nextPageId = in.readVLong();
        int numPages = in.readVInt();
        HashSet<Long> activePages = new HashSet<Long>();
        for (int i = 0; i < numPages; ++i) {
            activePages.add(in.readVLong());
        }
        byte[] indexData = in.readArray();
        return new IndexStatus(indexName, new LogSequenceNumber(ledgerId, offset), nextPageId, activePages, indexData);
    }

    public String toString() {
        return "IndexStatus{indexName=" + this.indexName + ", sequenceNumber=" + this.sequenceNumber + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.indexName);
        hash = 13 * hash + Objects.hashCode(this.sequenceNumber);
        hash = 13 * hash + Objects.hashCode(this.newPageId);
        hash = 13 * hash + Arrays.hashCode(this.indexData);
        hash = 13 * hash + Objects.hashCode(this.activePages);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexStatus other = (IndexStatus)obj;
        if (!Objects.equals(this.indexName, other.indexName)) {
            return false;
        }
        if (!Objects.equals(this.sequenceNumber, other.sequenceNumber)) {
            return false;
        }
        if (!Objects.equals(this.newPageId, other.newPageId)) {
            return false;
        }
        if (!Arrays.equals(this.indexData, other.indexData)) {
            return false;
        }
        return Objects.equals(this.activePages, other.activePages);
    }
}

