/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.SQLRecordPredicate;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;

public class ConstantExpression
implements CompiledSQLExpression {
    private final Object value;

    public ConstantExpression(Object value) {
        this.value = value;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        return this.value;
    }

    public String toString() {
        if (this.value != null) {
            return "ConstantExpression{value=" + this.value + ", " + this.value.getClass().getSimpleName() + '}';
        }
        return "ConstantExpression{null}";
    }

    @Override
    public CompiledSQLExpression cast(int type) {
        return new ConstantExpression(SQLRecordPredicate.cast(this.value, type));
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return this;
    }

    public boolean isNull() {
        return this.value == null;
    }
}

