/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;

public class CompiledEqualsExpression
extends CompiledBinarySQLExpression {
    public CompiledEqualsExpression(CompiledSQLExpression left, CompiledSQLExpression right) {
        super(left, right);
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        return this.left.opEqualsTo(bean, context, this.right);
    }

    public String toString() {
        return "CompiledEqualsExpression{left=" + this.left + ", right=" + this.right + '}';
    }

    @Override
    public String getOperator() {
        return "=";
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return new CompiledEqualsExpression(this.left.remapPositionalAccessToToPrimaryKeyAccessor(projection), this.right.remapPositionalAccessToToPrimaryKeyAccessor(projection));
    }

    public CompiledSQLExpression getLeft() {
        return this.left;
    }

    public CompiledSQLExpression getRight() {
        return this.right;
    }
}

