/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.SQLRecordPredicate;
import herddb.sql.expressions.BindableTableScanColumnNameResolver;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import java.util.List;

public class CastExpression
implements CompiledSQLExpression {
    private final CompiledSQLExpression wrapped;
    private final int type;

    public CastExpression(CompiledSQLExpression wrapped, int type) {
        this.wrapped = wrapped;
        this.type = type;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        return SQLRecordPredicate.cast(this.wrapped.evaluate(bean, context), this.type);
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        this.wrapped.validate(context);
    }

    @Override
    public List<CompiledSQLExpression> scanForConstraintedValueOnColumnWithOperator(String column, String operator, BindableTableScanColumnNameResolver columnNameResolver) {
        return this.wrapped.scanForConstraintedValueOnColumnWithOperator(column, operator, columnNameResolver);
    }

    @Override
    public List<CompiledSQLExpression> scanForConstraintsOnColumn(String column, BindableTableScanColumnNameResolver columnNameResolver) {
        return this.wrapped.scanForConstraintsOnColumn(column, columnNameResolver);
    }

    @Override
    public CompiledSQLExpression cast(int type) {
        return this.wrapped.cast(type);
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return new CastExpression(this.wrapped.remapPositionalAccessToToPrimaryKeyAccessor(projection), this.type);
    }
}

