/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import java.util.Arrays;

public class AccessCurrentRowExpression
implements CompiledSQLExpression {
    private final int index;

    public AccessCurrentRowExpression(int index) {
        this.index = index;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        return bean.get(this.index);
    }

    @Override
    public boolean opEqualsTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object rightValue = right.evaluate(bean, context);
        return bean.fieldEqualsTo(this.index, rightValue);
    }

    @Override
    public boolean opNotEqualsTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object rightValue = right.evaluate(bean, context);
        return bean.fieldNotEqualsTo(this.index, rightValue);
    }

    @Override
    public int opCompareTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object rightValue = right.evaluate(bean, context);
        return bean.fieldCompareTo(this.index, rightValue);
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "AccessCurrentRow{" + this.index + '}';
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        int _index = projection[this.index];
        if (_index < 0) {
            throw new IllegalStateException("column " + this.index + " not in pk, projection:" + Arrays.toString(projection));
        }
        return new AccessCurrentRowExpression(_index);
    }
}

