/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import herddb.codec.RecordSerializer;
import herddb.model.Predicate;
import herddb.model.Record;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.Tuple;
import herddb.model.TuplePredicate;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.ConstantExpression;
import herddb.utils.Bytes;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.logging.Logger;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimestampValue;

public class SQLRecordPredicate
extends Predicate
implements TuplePredicate {
    private static final Logger LOGGER = Logger.getLogger(SQLRecordPredicate.class.getName());
    private final Table table;
    private final String validatedTableAlias;
    private final CompiledSQLExpression where;
    private CompiledSQLExpression primaryKeyFilter;

    static boolean isConstant(Expression exp) {
        return exp instanceof StringValue || exp instanceof LongValue || exp instanceof NullValue || exp instanceof TimestampValue || exp instanceof JdbcParameter;
    }

    static boolean isConstant(CompiledSQLExpression exp) {
        return exp instanceof ConstantExpression;
    }

    public SQLRecordPredicate(Table table, String tableAlias, CompiledSQLExpression where) {
        this.table = table;
        this.validatedTableAlias = tableAlias;
        this.where = where;
    }

    @Override
    public Predicate.PrimaryKeyMatchOutcome matchesRawPrimaryKey(Bytes key, StatementEvaluationContext context) throws StatementExecutionException {
        if (this.primaryKeyFilter == null) {
            return Predicate.PrimaryKeyMatchOutcome.NEED_FULL_RECORD_EVALUATION;
        }
        DataAccessor bean = RecordSerializer.buildRawDataAccessorForPrimaryKey(key, this.table);
        boolean result = SQLRecordPredicateFunctions.toBoolean((Object)this.primaryKeyFilter.evaluate(bean, context));
        if (!result) {
            return Predicate.PrimaryKeyMatchOutcome.FAILED;
        }
        return this.where == this.primaryKeyFilter ? Predicate.PrimaryKeyMatchOutcome.FULL_CONDITION_VERIFIED : Predicate.PrimaryKeyMatchOutcome.NEED_FULL_RECORD_EVALUATION;
    }

    @Override
    public boolean matches(Tuple a, StatementEvaluationContext context) throws StatementExecutionException {
        return SQLRecordPredicateFunctions.toBoolean((Object)this.where.evaluate((DataAccessor)a, context));
    }

    @Override
    public boolean evaluate(Record record, StatementEvaluationContext context) throws StatementExecutionException {
        DataAccessor bean = record.getDataAccessor(this.table);
        return SQLRecordPredicateFunctions.toBoolean((Object)this.where.evaluate(bean, context));
    }

    @Override
    public void validateContext(StatementEvaluationContext context) throws StatementExecutionException {
        this.where.validate(context);
    }

    public String toString() {
        if (this.table != null) {
            return "SQLRecordPredicate{table=" + this.table.name + ", tableAlias=" + this.validatedTableAlias + ", where=" + this.where + ", indexOp=" + this.getIndexOperation() + " " + this.primaryKeyFilter + '}';
        }
        return "SQLRecordPredicate{table=null, tableAlias=" + this.validatedTableAlias + ", where=" + this.where + ", indexOp=" + this.getIndexOperation() + " " + this.primaryKeyFilter + '}';
    }

    public CompiledSQLExpression getPrimaryKeyFilter() {
        return this.primaryKeyFilter;
    }

    public void setPrimaryKeyFilter(CompiledSQLExpression primaryKeyFilter) {
        this.primaryKeyFilter = primaryKeyFilter;
    }

    public CompiledSQLExpression getWhere() {
        return this.where;
    }

    public static Object cast(Object value, int type) {
        if (value == null) {
            return null;
        }
        try {
            switch (type) {
                case 2: 
                case 12: {
                    return ((Number)value).intValue();
                }
                case 1: 
                case 13: {
                    return ((Number)value).longValue();
                }
                case 6: {
                    return ((Number)value).doubleValue();
                }
            }
            return value;
        }
        catch (ClassCastException err) {
            throw new IllegalArgumentException("Unexpected error on cast of value " + value + " (" + value.getClass() + "): " + err, err);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.equals(CompiledSQLExpression.class)) {
            return (T)this.where;
        }
        return (T)super.unwrap(clazz);
    }
}

