/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.codec.RecordSerializer;
import herddb.model.Column;
import herddb.model.ColumnsList;
import herddb.model.InvalidNullValueForKeyException;
import herddb.model.Record;
import herddb.model.RecordFunction;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.TableContext;
import herddb.sql.SQLRecordPredicate;
import herddb.sql.SQLStatementEvaluationContext;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SQLRecordKeyFunction
extends RecordFunction {
    private final List<CompiledSQLExpression> expressions;
    private final Column[] columns;
    private final String[] pkColumnNames;
    private final ColumnsList table;
    private final boolean fullPrimaryKey;
    private final boolean isConstant;

    public SQLRecordKeyFunction(List<String> expressionToColumn, List<CompiledSQLExpression> expressions, ColumnsList table) {
        String[] primaryKey;
        this.table = table;
        int size = expressions.size();
        this.columns = new Column[size];
        this.expressions = new ArrayList<CompiledSQLExpression>();
        this.pkColumnNames = new String[size];
        int i = 0;
        boolean constant = true;
        for (String cexp : expressionToColumn) {
            Column pkcolumn;
            this.columns[i] = pkcolumn = table.getColumn(cexp);
            CompiledSQLExpression exp = expressions.get(i);
            this.expressions.add(exp);
            if (!SQLRecordPredicate.isConstant(exp)) {
                constant = false;
            }
            ++i;
        }
        this.isConstant = constant;
        int k = 0;
        for (String pk : primaryKey = table.getPrimaryKey()) {
            if (!expressionToColumn.contains(pk)) continue;
            this.pkColumnNames[k++] = pk;
        }
        this.fullPrimaryKey = primaryKey.length == this.columns.length;
    }

    public boolean isFullPrimaryKey() {
        return this.fullPrimaryKey;
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public byte[] computeNewValue(Record previous, StatementEvaluationContext context, TableContext tableContext) throws StatementExecutionException {
        byte[] cachedResult;
        SQLStatementEvaluationContext statementEvaluationContext = (SQLStatementEvaluationContext)context;
        if (this.isConstant && (cachedResult = (byte[])statementEvaluationContext.getConstant(this)) != null) {
            return cachedResult;
        }
        HashMap<String, Object> pk = new HashMap<String, Object>();
        for (int i = 0; i < this.columns.length; ++i) {
            Column c = this.columns[i];
            CompiledSQLExpression expression = this.expressions.get(i);
            Object value = expression.evaluate(DataAccessor.NULL, context);
            if (value == null) {
                throw new InvalidNullValueForKeyException("error while converting primary key " + pk + ", keys cannot be null");
            }
            value = RecordSerializer.convert(c.type, value);
            pk.put(c.name, value);
        }
        try {
            byte[] result = RecordSerializer.serializePrimaryKeyRaw(pk, this.table, this.pkColumnNames);
            if (this.isConstant) {
                statementEvaluationContext.cacheConstant(this, result);
            }
            return result;
        }
        catch (Exception err) {
            throw new StatementExecutionException("error while converting primary key " + pk + ": " + err, err);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("SQLRecordKeyFunction (fullPrimaryKey=" + this.fullPrimaryKey + "):");
        for (int i = 0; i < this.pkColumnNames.length; ++i) {
            if (i > 0) {
                b.append(" AND ");
            }
            b.append(this.pkColumnNames[i]).append("=").append(this.expressions.get(i));
        }
        return b.toString();
    }
}

