/*
 * Decompiled with CFR 0.152.
 */
package herddb.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import herddb.core.HerdDBInternalException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ServerSidePreparedStatementCache {
    private final AtomicLong idGenerator = new AtomicLong();
    private final Cache<String, Long> preparedStatements;
    private final ConcurrentHashMap<Long, PreparedStatementInfo> statementsInfo = new ConcurrentHashMap();
    private static final Logger LOG = Logger.getLogger(ServerSidePreparedStatementCache.class.getName());

    public ServerSidePreparedStatementCache(long maxMemory) {
        this.preparedStatements = CacheBuilder.newBuilder().maximumWeight(maxMemory).initialCapacity(200).weigher((query, statementid) -> {
            PreparedStatementInfo info = this.statementsInfo.get(statementid);
            if (info == null) {
                return Integer.MAX_VALUE;
            }
            return info.memory;
        }).removalListener(notification -> {
            PreparedStatementInfo info = this.statementsInfo.remove(notification.getValue());
            LOG.log(Level.INFO, "unpreparing {0} {1}", new Object[]{notification.getValue(), notification.getKey()});
        }).build();
    }

    long prepare(String tableSpace, String text) {
        try {
            return (Long)this.preparedStatements.get((Object)(tableSpace + "#" + text), () -> {
                long newId = this.idGenerator.incrementAndGet();
                PreparedStatementInfo info = new PreparedStatementInfo(text, tableSpace);
                this.statementsInfo.put(newId, info);
                return newId;
            });
        }
        catch (ExecutionException err) {
            throw new HerdDBInternalException(err.getCause());
        }
    }

    public long getSize() {
        return this.preparedStatements.size();
    }

    String resolveQuery(String tableSpace, long statementId) {
        PreparedStatementInfo info = this.statementsInfo.get(statementId);
        if (info == null) {
            return null;
        }
        if (!tableSpace.equals(info.tablespace)) {
            return null;
        }
        return info.query;
    }

    @VisibleForTesting
    public void clear() {
        this.preparedStatements.invalidateAll();
        this.statementsInfo.clear();
    }

    private static class PreparedStatementInfo {
        private final String query;
        private final String tablespace;
        private final int memory;

        public PreparedStatementInfo(String query, String tablespace) {
            this.query = query;
            this.tablespace = tablespace;
            this.memory = query.length() + tablespace.length();
        }
    }
}

