/*
 * Decompiled with CFR 0.152.
 */
package herddb.server;

import herddb.backup.DumpedLogEntry;
import herddb.codec.RecordSerializer;
import herddb.core.HerdDBInternalException;
import herddb.core.RunningStatementInfo;
import herddb.core.RunningStatementsStats;
import herddb.core.TableManager;
import herddb.core.TableSpaceManager;
import herddb.core.stats.ConnectionsInfo;
import herddb.log.LogSequenceNumber;
import herddb.model.DDLStatementExecutionResult;
import herddb.model.DMLStatementExecutionResult;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.DuplicatePrimaryKeyException;
import herddb.model.GetResult;
import herddb.model.Index;
import herddb.model.NotLeaderException;
import herddb.model.Record;
import herddb.model.ScanResult;
import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.TableAwareStatement;
import herddb.model.Transaction;
import herddb.model.TransactionContext;
import herddb.model.TransactionResult;
import herddb.model.commands.BeginTransactionStatement;
import herddb.model.commands.CommitTransactionStatement;
import herddb.model.commands.RollbackTransactionStatement;
import herddb.model.commands.SQLPlannedOperationStatement;
import herddb.model.commands.ScanStatement;
import herddb.network.Channel;
import herddb.network.ChannelEventListener;
import herddb.network.ServerSideConnection;
import herddb.proto.Pdu;
import herddb.proto.PduCodec;
import herddb.security.sasl.SaslNettyServer;
import herddb.server.Server;
import herddb.server.ServerSidePreparedStatementCache;
import herddb.server.ServerSideScannerPeer;
import herddb.sql.TranslatedQuery;
import herddb.utils.Bytes;
import herddb.utils.DataAccessor;
import herddb.utils.TuplesList;
import io.netty.buffer.ByteBuf;
import java.io.EOFException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;

public class ServerSideConnectionPeer
implements ServerSideConnection,
ChannelEventListener {
    private static final Logger LOGGER = Logger.getLogger(ServerSideConnectionPeer.class.getName());
    private static final AtomicLong IDGENERATOR = new AtomicLong();
    private final long id = IDGENERATOR.incrementAndGet();
    private final Channel channel;
    private final Server server;
    private final ServerSidePreparedStatementCache preparedStatements;
    private final ConcurrentMap<Long, ServerSideScannerPeer> scanners = new ConcurrentHashMap<Long, ServerSideScannerPeer>();
    private volatile boolean authenticated;
    private volatile SaslNettyServer saslNettyServer;
    private final String address;
    private volatile String username = "";
    private final long connectionTs = System.currentTimeMillis();

    public ServerSideConnectionPeer(Channel channel, Server server) {
        this.channel = channel;
        this.channel.setMessagesReceiver((ChannelEventListener)this);
        this.server = server;
        this.address = channel.getRemoteAddress();
        this.preparedStatements = server.getManager().getPreparedStatementsCache();
    }

    public long getConnectionId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void requestReceived(Pdu message, Channel channel) {
        boolean releaseMessageSync = true;
        try {
            LOGGER.log(Level.FINEST, "messageReceived {0}", message);
            switch (message.type) {
                case 5: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        releaseMessageSync = false;
                        this.handleExecuteStatement(message, channel);
                        return;
                    }
                }
                case 103: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        releaseMessageSync = false;
                        this.handlePrepareStatement(message, channel);
                        return;
                    }
                }
                case 15: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        releaseMessageSync = false;
                        this.handleExecuteStatements(message, channel);
                        return;
                    }
                }
                case 100: {
                    this.handleSaslTokenMessageRequest(message, channel);
                    return;
                }
                case 102: {
                    this.handleSaslTokenMessage(message, channel);
                    return;
                }
                case 24: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        releaseMessageSync = false;
                        this.handleTxCommand(message, channel);
                        return;
                    }
                }
                case 7: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handleOpenScanner(message, channel);
                        return;
                    }
                }
                case 10: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handleFetchScannerData(message, channel);
                        return;
                    }
                }
                case 9: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handleCloseScanner(message, channel);
                        return;
                    }
                }
                case 11: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handleRequestTablespaceDump(message, channel);
                        return;
                    }
                }
                case 13: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handleRequestTableRestore(message, channel);
                        return;
                    }
                }
                case 14: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handlePushTableData(message, channel);
                        return;
                    }
                }
                case 19: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handleTableRestoreFinished(message, channel);
                        return;
                    }
                }
                case 23: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handleRestoreFinished(message, channel);
                        return;
                    }
                }
                case 17: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handlePushTxLogChunk(message, channel);
                        return;
                    }
                }
                case 20: {
                    if (!this.authenticated) {
                        this.sendAuthRequiredError(channel, message);
                        return;
                    } else {
                        this.handlePushTransactionsBlock(message, channel);
                        return;
                    }
                }
                default: {
                    channel.sendReplyMessage(message.messageId, PduCodec.ErrorResponse.write((long)message.messageId, (String)("unsupported message type " + message.type)));
                    return;
                }
            }
        }
        finally {
            if (releaseMessageSync) {
                message.close();
            }
        }
    }

    private void handleRequestTableRestore(Pdu message, Channel channel) {
        try {
            long dumpLedgerId = PduCodec.RequestTableRestore.readLedgerId((Pdu)message);
            long dumpOffset = PduCodec.RequestTableRestore.readOffset((Pdu)message);
            String tableSpace = PduCodec.RequestTableRestore.readTablespace((Pdu)message);
            byte[] table = PduCodec.RequestTableRestore.readTableDefinition((Pdu)message);
            Table tableSchema = Table.deserialize(table);
            tableSchema = Table.builder().cloning(tableSchema).tablespace(tableSpace).build();
            this.server.getManager().getTableSpaceManager(tableSpace).beginRestoreTable(tableSchema.serialize(), new LogSequenceNumber(dumpLedgerId, dumpOffset));
            ByteBuf res = PduCodec.AckResponse.write((long)message.messageId);
            channel.sendReplyMessage(message.messageId, res);
        }
        catch (StatementExecutionException err) {
            ByteBuf res = ServerSideConnectionPeer.composeErrorResponse(message.messageId, (Throwable)((Object)err));
            channel.sendReplyMessage(message.messageId, res);
        }
    }

    private static ByteBuf composeErrorResponse(long messageId, Throwable err) {
        return PduCodec.ErrorResponse.write((long)messageId, (Throwable)err, (boolean)(err instanceof NotLeaderException), (boolean)false);
    }

    private void handleTableRestoreFinished(Pdu message, Channel channel) {
        try {
            String tableSpace = PduCodec.TableRestoreFinished.readTablespace((Pdu)message);
            String table = PduCodec.TableRestoreFinished.readTableName((Pdu)message);
            List rawIndexes = PduCodec.TableRestoreFinished.readIndexesDefinition((Pdu)message);
            int numIndexes = rawIndexes.size();
            ArrayList<Index> indexes = new ArrayList<Index>(numIndexes);
            for (byte[] index : rawIndexes) {
                indexes.add(Index.deserialize(index));
            }
            LOGGER.log(Level.INFO, "tableRestoreFinished, table {0}, with {1} indexes", new Object[]{table, indexes.size()});
            this.server.getManager().getTableSpaceManager(tableSpace).restoreTableFinished(table, indexes);
            ByteBuf res = PduCodec.AckResponse.write((long)message.messageId);
            channel.sendReplyMessage(message.messageId, res);
        }
        catch (StatementExecutionException err) {
            ByteBuf res = ServerSideConnectionPeer.composeErrorResponse(message.messageId, (Throwable)((Object)err));
            channel.sendReplyMessage(message.messageId, res);
        }
    }

    private void handleRestoreFinished(Pdu message, Channel channel) {
        try {
            String tableSpace = PduCodec.TableRestoreFinished.readTablespace((Pdu)message);
            this.server.getManager().getTableSpaceManager(tableSpace).restoreFinished();
            ByteBuf res = PduCodec.AckResponse.write((long)message.messageId);
            channel.sendReplyMessage(message.messageId, res);
        }
        catch (StatementExecutionException err) {
            ByteBuf res = ServerSideConnectionPeer.composeErrorResponse(message.messageId, (Throwable)((Object)err));
            channel.sendReplyMessage(message.messageId, res);
        }
    }

    private void handlePushTableData(Pdu message, Channel channel) {
        try {
            String tableSpace = PduCodec.PushTableData.readTablespace((Pdu)message);
            String table = PduCodec.PushTableData.readTablename((Pdu)message);
            long _start = System.currentTimeMillis();
            ArrayList<Record> records = new ArrayList<Record>();
            PduCodec.PushTableData.readRecords((Pdu)message, (key, value) -> records.add(new Record(Bytes.from_array((byte[])key), Bytes.from_array((byte[])value))));
            LOGGER.log(Level.INFO, "Received {0} records for restore of table {1} in tableSpace {2}", new Object[]{records.size(), table, tableSpace});
            TableManager tableManager = (TableManager)this.server.getManager().getTableSpaceManager(tableSpace).getTableManager(table);
            tableManager.writeFromDump(records);
            long _stop = System.currentTimeMillis();
            LOGGER.log(Level.INFO, "Time restore {0} records: data {1} ms", new Object[]{records.size(), _stop - _start});
            ByteBuf res = PduCodec.AckResponse.write((long)message.messageId);
            channel.sendReplyMessage(message.messageId, res);
        }
        catch (StatementExecutionException err) {
            ByteBuf res = ServerSideConnectionPeer.composeErrorResponse(message.messageId, (Throwable)((Object)err));
            channel.sendReplyMessage(message.messageId, res);
        }
    }

    private void handlePushTxLogChunk(Pdu message, Channel channel) {
        try {
            String tableSpace = PduCodec.PushTxLogChunk.readTablespace((Pdu)message);
            ArrayList<DumpedLogEntry> entries = new ArrayList<DumpedLogEntry>();
            PduCodec.PushTxLogChunk.readRecords((Pdu)message, (key, value) -> entries.add(new DumpedLogEntry(LogSequenceNumber.deserialize(key), (byte[])value)));
            LOGGER.log(Level.INFO, "Received {0} records for restore of txlog in tableSpace {1}", new Object[]{entries.size(), tableSpace});
            this.server.getManager().getTableSpaceManager(tableSpace).restoreRawDumpedEntryLogs(entries);
            ByteBuf res = PduCodec.AckResponse.write((long)message.messageId);
            channel.sendReplyMessage(message.messageId, res);
        }
        catch (StatementExecutionException | EOFException err) {
            ByteBuf res = ServerSideConnectionPeer.composeErrorResponse(message.messageId, (Throwable)err);
            channel.sendReplyMessage(message.messageId, res);
        }
    }

    private void handlePushTransactionsBlock(Pdu message, Channel channel) {
        try {
            String tableSpace = PduCodec.PushTransactionsBlock.readTablespace((Pdu)message);
            ArrayList<Transaction> entries = new ArrayList<Transaction>();
            PduCodec.PushTransactionsBlock.readTransactions((Pdu)message, value -> entries.add(Transaction.deserialize(tableSpace, value)));
            LOGGER.log(Level.INFO, "Received " + entries.size() + " records for restore of transactions in tableSpace " + tableSpace);
            this.server.getManager().getTableSpaceManager(tableSpace).restoreRawDumpedTransactions(entries);
            ByteBuf res = PduCodec.AckResponse.write((long)message.messageId);
            channel.sendReplyMessage(message.messageId, res);
        }
        catch (StatementExecutionException err) {
            ByteBuf res = ServerSideConnectionPeer.composeErrorResponse(message.messageId, (Throwable)((Object)err));
            channel.sendReplyMessage(message.messageId, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOpenScanner(Pdu message, Channel channel) {
        String query;
        long txId = PduCodec.OpenScanner.readTx((Pdu)message);
        String tableSpace = PduCodec.OpenScanner.readTablespace((Pdu)message);
        long statementId = PduCodec.OpenScanner.readStatementId((Pdu)message);
        String string = query = statementId > 0L ? this.preparedStatements.resolveQuery(tableSpace, statementId) : PduCodec.OpenScanner.readQuery((Pdu)message);
        if (query == null) {
            ByteBuf error = PduCodec.ErrorResponse.writeMissingPreparedStatementError((long)message.messageId, (String)("bad statement id: " + statementId));
            channel.sendReplyMessage(message.messageId, error);
            return;
        }
        long scannerId = PduCodec.OpenScanner.readScannerId((Pdu)message);
        int fetchSize = PduCodec.OpenScanner.readFetchSize((Pdu)message);
        if (fetchSize <= 0) {
            fetchSize = 10;
        }
        int maxRows = PduCodec.OpenScanner.readMaxRows((Pdu)message);
        PduCodec.ObjectListReader parametersReader = PduCodec.OpenScanner.startReadParameters((Pdu)message);
        ArrayList<Object> parameters = new ArrayList<Object>(parametersReader.getNumParams());
        for (int i = 0; i < parametersReader.getNumParams(); ++i) {
            parameters.add(parametersReader.nextObject());
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "openScanner txId+" + txId + ", fetchSize " + fetchSize + ", maxRows " + maxRows + "," + query + " with " + parameters);
        }
        RunningStatementsStats runningStatements = this.server.getManager().getRunningStatements();
        RunningStatementInfo statementInfo = new RunningStatementInfo(query, System.currentTimeMillis(), tableSpace, "", 1);
        try {
            TranslatedQuery translatedQuery = this.server.getManager().getPlanner().translate(tableSpace, query, parameters, true, true, false, maxRows);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "{0} -> {1}", new Object[]{query, translatedQuery.plan.mainStatement});
            }
            TransactionContext transactionContext = new TransactionContext(txId);
            if (translatedQuery.plan.mainStatement instanceof SQLPlannedOperationStatement || translatedQuery.plan.mainStatement instanceof ScanStatement) {
                runningStatements.registerRunningStatement(statementInfo);
                ScanResult scanResult = (ScanResult)this.server.getManager().executePlan(translatedQuery.plan, translatedQuery.context, transactionContext);
                DataScanner dataScanner = scanResult.dataScanner;
                ServerSideScannerPeer scanner = new ServerSideScannerPeer(dataScanner);
                String[] columns = dataScanner.getFieldNames();
                List<DataAccessor> records = dataScanner.consume(fetchSize);
                TuplesList tuplesList = new TuplesList(columns, records);
                boolean last = dataScanner.isFinished();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "sending first {0} records to scanner {1} query {2}", new Object[]{records.size(), scannerId, query});
                }
                if (!last) {
                    this.scanners.put(scannerId, scanner);
                }
                ByteBuf result = PduCodec.ResultSetChunk.write((long)message.messageId, (TuplesList)tuplesList, (boolean)last, (long)dataScanner.getTransactionId());
                channel.sendReplyMessage(message.messageId, result);
                if (last) {
                    scanner.close();
                }
            } else {
                ByteBuf error = PduCodec.ErrorResponse.write((long)message.messageId, (String)("unsupported query type for scan " + query + ": PLAN is " + translatedQuery.plan));
                channel.sendReplyMessage(message.messageId, error);
            }
        }
        catch (DataScannerException | StatementExecutionException err) {
            LOGGER.log(Level.SEVERE, "error on scanner " + scannerId + ": " + err, (Throwable)err);
            this.scanners.remove(scannerId);
            ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, (Throwable)err);
            channel.sendReplyMessage(message.messageId, error);
        }
        finally {
            runningStatements.unregisterRunningStatement(statementInfo);
        }
    }

    private void handleFetchScannerData(Pdu message, Channel channel) {
        ServerSideScannerPeer scanner;
        long scannerId = PduCodec.FetchScannerData.readScannerId((Pdu)message);
        int fetchSize = PduCodec.FetchScannerData.readFetchSize((Pdu)message);
        if (fetchSize <= 0) {
            fetchSize = 10;
        }
        if ((scanner = (ServerSideScannerPeer)this.scanners.get(scannerId)) != null) {
            try {
                DataScanner dataScanner = scanner.getScanner();
                List<DataAccessor> records = dataScanner.consume(fetchSize);
                String[] columns = dataScanner.getFieldNames();
                TuplesList tuplesList = new TuplesList(columns, records);
                boolean last = false;
                if (dataScanner.isFinished()) {
                    LOGGER.log(Level.FINEST, "unregistering scanner {0}, resultset is finished", scannerId);
                    this.scanners.remove(scannerId);
                    last = true;
                }
                ByteBuf result = PduCodec.ResultSetChunk.write((long)message.messageId, (TuplesList)tuplesList, (boolean)last, (long)dataScanner.getTransactionId());
                channel.sendReplyMessage(message.messageId, result);
                if (last) {
                    dataScanner.close();
                }
            }
            catch (DataScannerException err) {
                ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
                channel.sendReplyMessage(message.messageId, error);
            }
        } else {
            ByteBuf error = PduCodec.ErrorResponse.write((long)message.messageId, (String)("no such scanner " + scannerId));
            channel.sendReplyMessage(message.messageId, error);
        }
    }

    private void handleCloseScanner(Pdu message, Channel channel) {
        long scannerId = PduCodec.CloseScanner.readScannerId((Pdu)message);
        ServerSideScannerPeer removed = (ServerSideScannerPeer)this.scanners.remove(scannerId);
        if (removed != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "remove scanner {0} as requested by client", scannerId);
            }
            removed.clientClose();
        }
    }

    private void sendAuthRequiredError(Channel channel, Pdu message) {
        ByteBuf error = PduCodec.ErrorResponse.write((long)message.messageId, (String)("autentication required (client " + this.channel + ")"));
        channel.sendReplyMessage(message.messageId, error);
    }

    private void handleRequestTablespaceDump(Pdu message, Channel channel) {
        String dumpId = PduCodec.RequestTablespaceDump.readDumpId((Pdu)message);
        int fetchSize = PduCodec.RequestTablespaceDump.readFetchSize((Pdu)message);
        if (fetchSize <= 0) {
            fetchSize = 10;
        }
        String tableSpace = PduCodec.RequestTablespaceDump.readTablespace((Pdu)message);
        boolean includeTransactionLog = PduCodec.RequestTablespaceDump.readInludeTransactionLog((Pdu)message);
        this.server.getManager().dumpTableSpace(tableSpace, dumpId, message, channel, fetchSize, includeTransactionLog);
    }

    private void handleExecuteStatements(Pdu message, Channel channel) {
        String query;
        long transactionId = PduCodec.ExecuteStatements.readTx((Pdu)message);
        String tableSpace = PduCodec.ExecuteStatements.readTablespace((Pdu)message);
        long statementId = PduCodec.ExecuteStatements.readStatementId((Pdu)message);
        String string = query = statementId > 0L ? this.preparedStatements.resolveQuery(tableSpace, statementId) : PduCodec.ExecuteStatements.readQuery((Pdu)message);
        if (query == null) {
            ByteBuf error = PduCodec.ErrorResponse.writeMissingPreparedStatementError((long)message.messageId, (String)("bad statement id: " + statementId));
            channel.sendReplyMessage(message.messageId, error);
            message.close();
            return;
        }
        boolean returnValues = PduCodec.ExecuteStatements.readReturnValues((Pdu)message);
        PduCodec.ListOfListsReader statementParameters = PduCodec.ExecuteStatements.startReadStatementsParameters((Pdu)message);
        int numStatements = statementParameters.getNumLists();
        ArrayList batch = new ArrayList(numStatements);
        for (int i = 0; i < numStatements; ++i) {
            PduCodec.ObjectListReader parametersReader = statementParameters.nextList();
            ArrayList<Object> batchParams = new ArrayList<Object>(parametersReader.getNumParams());
            for (int j = 0; j < parametersReader.getNumParams(); ++j) {
                batchParams.add(parametersReader.nextObject());
            }
            batch.add(batchParams);
        }
        RunningStatementsStats runningStatements = this.server.getManager().getRunningStatements();
        RunningStatementInfo statementInfo = new RunningStatementInfo(query, System.currentTimeMillis(), tableSpace, "", numStatements);
        try {
            ArrayList<TranslatedQuery> queries = new ArrayList<TranslatedQuery>();
            for (int i = 0; i < numStatements; ++i) {
                List parameters = (List)batch.get(i);
                TranslatedQuery translatedQuery = this.server.getManager().getPlanner().translate(tableSpace, query, parameters, false, true, returnValues, -1);
                queries.add(translatedQuery);
            }
            CopyOnWriteArrayList updateCounts = new CopyOnWriteArrayList();
            CopyOnWriteArrayList otherDatas = new CopyOnWriteArrayList();
            TransactionContext transactionContext = new TransactionContext(transactionId);
            TranslatedQuery firstTranslatedQuery = (TranslatedQuery)queries.get(0);
            class ComputeNext
            implements BiConsumer<StatementExecutionResult, Throwable> {
                int current;
                final /* synthetic */ Pdu val$message;
                final /* synthetic */ Channel val$channel;
                final /* synthetic */ RunningStatementsStats val$runningStatements;
                final /* synthetic */ RunningStatementInfo val$statementInfo;
                final /* synthetic */ boolean val$returnValues;
                final /* synthetic */ List val$queries;
                final /* synthetic */ List val$updateCounts;
                final /* synthetic */ List val$otherDatas;

                public ComputeNext(int current) {
                    this.val$message = pdu;
                    this.val$channel = channel;
                    this.val$runningStatements = runningStatementsStats;
                    this.val$statementInfo = runningStatementInfo;
                    this.val$returnValues = bl;
                    this.val$queries = list;
                    this.val$updateCounts = list2;
                    this.val$otherDatas = list3;
                    this.current = current;
                }

                @Override
                public void accept(StatementExecutionResult result, Throwable error) {
                    if (error != null) {
                        ByteBuf errorMsg = ServerSideConnectionPeer.composeErrorResponse(this.val$message.messageId, error);
                        this.val$channel.sendReplyMessage(this.val$message.messageId, errorMsg);
                        this.val$message.close();
                        this.val$runningStatements.unregisterRunningStatement(this.val$statementInfo);
                        return;
                    }
                    if (result instanceof DMLStatementExecutionResult) {
                        DMLStatementExecutionResult dml = (DMLStatementExecutionResult)result;
                        Map<String, Object> otherData = Collections.emptyMap();
                        if (this.val$returnValues && dml.getKey() != null) {
                            TranslatedQuery translatedQuery = (TranslatedQuery)this.val$queries.get(this.current - 1);
                            Statement statement = translatedQuery.plan.mainStatement;
                            TableAwareStatement tableStatement = (TableAwareStatement)statement;
                            Table table = ServerSideConnectionPeer.this.server.getManager().getTableSpaceManager(statement.getTableSpace()).getTableManager(tableStatement.getTable()).getTable();
                            Object key = RecordSerializer.deserializePrimaryKey(dml.getKey(), table);
                            otherData = new HashMap();
                            otherData.put("_key", key);
                            if (dml.getNewvalue() != null) {
                                Map<String, Object> newvalue = RecordSerializer.toBean(new Record(dml.getKey(), dml.getNewvalue()), table);
                                otherData.putAll(newvalue);
                            }
                        }
                        this.val$updateCounts.add(Long.valueOf(dml.getUpdateCount()));
                        this.val$otherDatas.add(otherData);
                    } else if (result instanceof DDLStatementExecutionResult) {
                        Map otherData = Collections.emptyMap();
                        this.val$updateCounts.add(1L);
                        this.val$otherDatas.add(otherData);
                    } else {
                        ByteBuf response = PduCodec.ErrorResponse.write((long)this.val$message.messageId, (String)("bad result type " + result.getClass() + " (" + result + ")"));
                        this.val$channel.sendReplyMessage(this.val$message.messageId, response);
                        this.val$message.close();
                        this.val$runningStatements.unregisterRunningStatement(this.val$statementInfo);
                        return;
                    }
                    long newTransactionId = result.transactionId;
                    if (this.current == this.val$queries.size()) {
                        try {
                            ByteBuf response = PduCodec.ExecuteStatementsResult.write((long)this.val$message.messageId, (List)this.val$updateCounts, (List)this.val$otherDatas, (long)newTransactionId);
                            this.val$channel.sendReplyMessage(this.val$message.messageId, response);
                            this.val$message.close();
                            this.val$runningStatements.unregisterRunningStatement(this.val$statementInfo);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        return;
                    }
                    TranslatedQuery nextPlannedQuery = (TranslatedQuery)this.val$queries.get(this.current);
                    TransactionContext transactionContext = new TransactionContext(newTransactionId);
                    CompletableFuture<StatementExecutionResult> nextPromise = ServerSideConnectionPeer.this.server.getManager().executePlanAsync(nextPlannedQuery.plan, nextPlannedQuery.context, transactionContext);
                    nextPromise.whenComplete((BiConsumer)new ComputeNext(this.current + 1));
                }
            }
            this.server.getManager().executePlanAsync(firstTranslatedQuery.plan, firstTranslatedQuery.context, transactionContext).whenComplete((BiConsumer)new ComputeNext(1));
        }
        catch (HerdDBInternalException err) {
            ByteBuf response = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
            channel.sendReplyMessage(message.messageId, response);
            message.close();
            runningStatements.unregisterRunningStatement(statementInfo);
        }
    }

    private void handleExecuteStatement(Pdu message, Channel channel) {
        TranslatedQuery translatedQuery;
        String query;
        long txId = PduCodec.ExecuteStatement.readTx((Pdu)message);
        String tablespace = PduCodec.ExecuteStatement.readTablespace((Pdu)message);
        long statementId = PduCodec.ExecuteStatement.readStatementId((Pdu)message);
        String string = query = statementId > 0L ? this.preparedStatements.resolveQuery(tablespace, statementId) : PduCodec.ExecuteStatement.readQuery((Pdu)message);
        if (query == null) {
            ByteBuf error = PduCodec.ErrorResponse.writeMissingPreparedStatementError((long)message.messageId, (String)("bad statement id: " + statementId));
            channel.sendReplyMessage(message.messageId, error);
            message.close();
            return;
        }
        boolean returnValues = PduCodec.ExecuteStatement.readReturnValues((Pdu)message);
        PduCodec.ObjectListReader parametersReader = PduCodec.ExecuteStatement.startReadParameters((Pdu)message);
        ArrayList<Object> parameters = new ArrayList<Object>(parametersReader.getNumParams());
        for (int i = 0; i < parametersReader.getNumParams(); ++i) {
            parameters.add(parametersReader.nextObject());
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "query {0} with {1}", new Object[]{query, parameters});
        }
        RunningStatementInfo statementInfo = new RunningStatementInfo(query, System.currentTimeMillis(), tablespace, "", 1);
        TransactionContext transactionContext = new TransactionContext(txId);
        try {
            translatedQuery = this.server.getManager().getPlanner().translate(tablespace, query, parameters, false, true, returnValues, -1);
        }
        catch (StatementExecutionException ex) {
            ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, (Throwable)((Object)ex));
            channel.sendReplyMessage(message.messageId, error);
            message.close();
            return;
        }
        Statement statement = translatedQuery.plan.mainStatement;
        RunningStatementsStats runningStatements = this.server.getManager().getRunningStatements();
        runningStatements.registerRunningStatement(statementInfo);
        CompletableFuture<StatementExecutionResult> res = this.server.getManager().executePlanAsync(translatedQuery.plan, translatedQuery.context, transactionContext);
        res.whenComplete((result, err) -> {
            try {
                runningStatements.unregisterRunningStatement(statementInfo);
                if (err != null) {
                    while (err instanceof CompletionException) {
                        err = err.getCause();
                    }
                    if (err instanceof DuplicatePrimaryKeyException) {
                        ByteBuf error = PduCodec.ErrorResponse.writeSqlIntegrityConstraintsViolation((long)message.messageId, (Throwable)new SQLIntegrityConstraintViolationException((Throwable)err));
                        channel.sendReplyMessage(message.messageId, error);
                    } else if (err instanceof NotLeaderException) {
                        ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
                        channel.sendReplyMessage(message.messageId, error);
                    } else if (err instanceof StatementExecutionException) {
                        ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
                        channel.sendReplyMessage(message.messageId, error);
                    } else {
                        LOGGER.log(Level.SEVERE, "unexpected error on query " + query + ", parameters: " + parameters + ":" + err, (Throwable)err);
                        ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
                        channel.sendReplyMessage(message.messageId, error);
                    }
                    return;
                }
                if (result instanceof DMLStatementExecutionResult) {
                    DMLStatementExecutionResult dml = (DMLStatementExecutionResult)result;
                    HashMap<String, Object> newRecord = null;
                    if (returnValues && dml.getKey() != null) {
                        TableAwareStatement tableStatement = (TableAwareStatement)statement.unwrap(TableAwareStatement.class);
                        Table table = this.server.getManager().getTableSpaceManager(statement.getTableSpace()).getTableManager(tableStatement.getTable()).getTable();
                        newRecord = new HashMap<String, Object>();
                        Object newKey = RecordSerializer.deserializePrimaryKey(dml.getKey(), table);
                        newRecord.put("_key", newKey);
                        if (dml.getNewvalue() != null) {
                            newRecord.putAll(RecordSerializer.toBean(new Record(dml.getKey(), dml.getNewvalue()), table));
                        }
                    }
                    channel.sendReplyMessage(message.messageId, PduCodec.ExecuteStatementResult.write((long)message.messageId, (long)dml.getUpdateCount(), (long)dml.transactionId, newRecord));
                } else if (result instanceof GetResult) {
                    GetResult get = (GetResult)result;
                    if (!get.found()) {
                        channel.sendReplyMessage(message.messageId, PduCodec.ExecuteStatementResult.write((long)message.messageId, (long)0L, (long)get.transactionId, null));
                    } else {
                        Map<String, Object> record = get.getRecord().toBean(get.getTable());
                        channel.sendReplyMessage(message.messageId, PduCodec.ExecuteStatementResult.write((long)message.messageId, (long)1L, (long)get.transactionId, record));
                    }
                } else if (result instanceof TransactionResult) {
                    TransactionResult txresult = (TransactionResult)result;
                    channel.sendReplyMessage(message.messageId, PduCodec.ExecuteStatementResult.write((long)message.messageId, (long)1L, (long)txresult.getTransactionId(), null));
                } else if (result instanceof DDLStatementExecutionResult) {
                    DDLStatementExecutionResult ddl = (DDLStatementExecutionResult)result;
                    channel.sendReplyMessage(message.messageId, PduCodec.ExecuteStatementResult.write((long)message.messageId, (long)1L, (long)ddl.transactionId, null));
                } else {
                    ByteBuf error = PduCodec.ErrorResponse.write((long)message.messageId, (String)("unknown result type:" + result));
                    channel.sendReplyMessage(message.messageId, error);
                }
            }
            finally {
                message.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrepareStatement(Pdu message, Channel channel) {
        try {
            String query = PduCodec.PrepareStatement.readQuery((Pdu)message);
            String tablespace = PduCodec.PrepareStatement.readTablespace((Pdu)message);
            TableSpaceManager tableSpaceManager = this.server.getManager().getTableSpaceManager(tablespace);
            if (tableSpaceManager == null) {
                ByteBuf error = PduCodec.ErrorResponse.writeNotLeaderError((long)message.messageId, (String)("no such tablespace " + tablespace + " (at " + this.server.getManager().getNodeId() + ")"));
                channel.sendReplyMessage(message.messageId, error);
                return;
            }
            if (!tableSpaceManager.isLeader()) {
                ByteBuf error = PduCodec.ErrorResponse.writeNotLeaderError((long)message.messageId, (String)("not leader for " + tablespace));
                channel.sendReplyMessage(message.messageId, error);
                return;
            }
            long newId = this.preparedStatements.prepare(tablespace, query);
            channel.sendReplyMessage(message.messageId, PduCodec.PrepareStatementResult.write((long)message.messageId, (long)newId));
        }
        finally {
            message.close();
        }
    }

    private void handleTxCommand(Pdu message, Channel channel) {
        Statement statement;
        long txId = PduCodec.TxCommand.readTx((Pdu)message);
        byte type = PduCodec.TxCommand.readCommand((Pdu)message);
        String tableSpace = PduCodec.TxCommand.readTablespace((Pdu)message);
        TransactionContext transactionContext = new TransactionContext(txId);
        switch (type) {
            case 2: {
                statement = new CommitTransactionStatement(tableSpace, txId);
                break;
            }
            case 1: {
                statement = new RollbackTransactionStatement(tableSpace, txId);
                break;
            }
            case 3: {
                statement = new BeginTransactionStatement(tableSpace);
                break;
            }
            default: {
                statement = null;
            }
        }
        if (statement == null) {
            ByteBuf error = PduCodec.ErrorResponse.write((long)message.messageId, (String)("unknown txcommand type:" + type));
            channel.sendReplyMessage(message.messageId, error);
            message.close();
        } else {
            CompletableFuture<StatementExecutionResult> res = this.server.getManager().executeStatementAsync(statement, new StatementEvaluationContext(), transactionContext);
            res.whenComplete((result, err) -> {
                try {
                    if (err != null) {
                        if (err instanceof NotLeaderException) {
                            ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
                            channel.sendReplyMessage(message.messageId, error);
                        } else if (err instanceof StatementExecutionException) {
                            ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
                            channel.sendReplyMessage(message.messageId, error);
                        } else {
                            LOGGER.log(Level.SEVERE, "unexpected error on tx command: ", (Throwable)err);
                            ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
                            channel.sendReplyMessage(message.messageId, error);
                        }
                    } else if (result instanceof TransactionResult) {
                        TransactionResult txresult = (TransactionResult)result;
                        ByteBuf response = PduCodec.TxCommandResult.write((long)message.messageId, (long)txresult.transactionId);
                        channel.sendReplyMessage(message.messageId, response);
                    } else {
                        ByteBuf error = PduCodec.ErrorResponse.write((long)message.messageId, (String)("unknown result type:" + result));
                        channel.sendReplyMessage(message.messageId, error);
                    }
                }
                finally {
                    message.close();
                }
            });
        }
    }

    private void handleSaslTokenMessage(Pdu message, Channel channel) {
        try {
            if (this.saslNettyServer == null) {
                ByteBuf error = PduCodec.ErrorResponse.write((long)message.messageId, (String)"Authentication failed (SASL protocol error)");
                channel.sendReplyMessage(message.messageId, error);
                return;
            }
            byte[] token = PduCodec.SaslTokenMessageToken.readToken((Pdu)message);
            byte[] responseToken = this.saslNettyServer.response(token);
            ByteBuf tokenChallenge = PduCodec.SaslTokenServerResponse.write((long)message.messageId, (byte[])responseToken);
            if (this.saslNettyServer.isComplete()) {
                this.username = this.saslNettyServer.getUserName();
                this.authenticated = true;
                LOGGER.log(Level.INFO, "client {0} connected as {1}", new Object[]{this.channel.getRemoteAddress(), this.username});
                this.saslNettyServer = null;
            }
            channel.sendReplyMessage(message.messageId, tokenChallenge);
        }
        catch (Exception err) {
            if (err instanceof SaslException) {
                LOGGER.log(Level.SEVERE, "SASL error " + err, err);
                ByteBuf error = PduCodec.ErrorResponse.write((long)message.messageId, (String)"Authentication failed (SASL error)");
                channel.sendReplyMessage(message.messageId, error);
            }
            LOGGER.log(Level.SEVERE, "Bad auth error " + err, err);
            ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
            channel.sendReplyMessage(message.messageId, error);
        }
    }

    private void handleSaslTokenMessageRequest(Pdu message, Channel channel) {
        try {
            String mech = PduCodec.SaslTokenMessageRequest.readMech((Pdu)message);
            byte[] token = PduCodec.SaslTokenMessageRequest.readToken((Pdu)message);
            if (token == null) {
                token = new byte[]{};
            }
            if (this.saslNettyServer == null) {
                this.saslNettyServer = new SaslNettyServer(this.server, mech);
            }
            byte[] responseToken = this.saslNettyServer.response(token);
            ByteBuf tokenChallenge = PduCodec.SaslTokenServerResponse.write((long)message.messageId, (byte[])responseToken);
            channel.sendReplyMessage(message.messageId, tokenChallenge);
        }
        catch (Exception err) {
            ByteBuf error = ServerSideConnectionPeer.composeErrorResponse(message.messageId, err);
            channel.sendReplyMessage(message.messageId, error);
        }
    }

    public void channelClosed(Channel channel) {
        LOGGER.log(Level.INFO, "channelClosed {0}", this);
        this.freeResources();
        this.server.connectionClosed(this);
    }

    private void freeResources() {
        this.scanners.values().forEach(ServerSideScannerPeer::close);
        this.scanners.clear();
    }

    ConnectionsInfo.ConnectionInfo toConnectionInfo() {
        return new ConnectionsInfo.ConnectionInfo(this.id + "", this.connectionTs, this.username, this.address);
    }

    public ConcurrentMap<Long, ServerSideScannerPeer> getScanners() {
        return this.scanners;
    }

    public String toString() {
        return "ServerSideConnectionPeer{id=" + this.id + ", channel=" + this.channel + ", address=" + this.address + ", username=" + this.username + '}';
    }
}

