/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.DataScanner;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.commands.ScanStatement;
import herddb.model.planner.PlannerOp;
import herddb.utils.Wrapper;

public abstract class SimpleScanOp
implements PlannerOp {
    final ScanStatement statement;

    protected SimpleScanOp(ScanStatement statement) {
        this.statement = statement;
    }

    public ScanStatement getStatement() {
        return this.statement;
    }

    @Override
    public String getTablespace() {
        return this.statement.getTableSpace();
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.statement.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    @Override
    public boolean isSimpleStatementWrapper() {
        return true;
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        DataScanner scan = tableSpaceManager.scan(this.statement, context, transactionContext, lockRequired, forWrite);
        return new ScanResult(transactionContext.transactionId, scan);
    }
}

