/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.DMLStatement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.PlannerOp;
import herddb.utils.Wrapper;
import java.util.concurrent.CompletableFuture;

public class SimpleDeleteOp
implements PlannerOp {
    private final DMLStatement statement;

    public SimpleDeleteOp(DMLStatement delete) {
        this.statement = delete;
    }

    @Override
    public String getTablespace() {
        return this.statement.getTableSpace();
    }

    @Override
    public CompletableFuture<StatementExecutionResult> executeAsync(TableSpaceManager tableSpaceManager, TransactionContext transaction, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        return tableSpaceManager.executeStatementAsync(this.statement, context, transaction);
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.statement.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    @Override
    public boolean isSimpleStatementWrapper() {
        return true;
    }

    public String toString() {
        return "SimpleDeleteOp{statement=" + this.statement + '}';
    }
}

