/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.DataScanner;
import herddb.model.Projection;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.commands.ScanStatement;
import herddb.model.planner.PlannerOp;
import herddb.model.planner.ProjectOp;
import herddb.model.planner.TableScanOp;
import herddb.utils.Wrapper;

public class ProjectedTableScanOp
implements PlannerOp {
    final ScanStatement statement;

    ProjectedTableScanOp(ProjectOp op, TableScanOp tableScan) {
        this.statement = tableScan.unwrap(ScanStatement.class);
        Projection proj = op.getProjection();
        this.statement.setProjection(proj);
    }

    @Override
    public String getTablespace() {
        return this.statement.getTableSpace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        DataScanner scan = tableSpaceManager.scan(this.statement, context, transactionContext, lockRequired, forWrite);
        return new ScanResult(transactionContext.transactionId, scan);
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.statement.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    @Override
    public boolean isSimpleStatementWrapper() {
        return true;
    }

    public String toString() {
        return "ProjectedTableScanOp{statement=" + this.statement + '}';
    }
}

