/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.Projection;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.PlannerOp;
import herddb.model.planner.ProjectedTableScanOp;
import herddb.model.planner.TableScanOp;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.AbstractDataAccessor;
import herddb.utils.DataAccessor;
import herddb.utils.Wrapper;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.BiConsumer;

public class ProjectOp
implements PlannerOp {
    private final Projection projection;
    private final PlannerOp input;

    public ProjectOp(Projection projection1, PlannerOp input) {
        this.projection = projection1;
        this.input = input.optimize();
    }

    @Override
    public String getTablespace() {
        return this.input.getTablespace();
    }

    public PlannerOp getInput() {
        return this.input;
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.input.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    @Override
    public PlannerOp optimize() {
        if (this.input instanceof TableScanOp) {
            return new ProjectedTableScanOp(this, (TableScanOp)this.input);
        }
        return this;
    }

    public Projection getProjection() {
        return this.projection;
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        StatementExecutionResult input = this.input.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
        ScanResult downstream = (ScanResult)input;
        DataScanner dataScanner = downstream.dataScanner;
        ProjectedDataScanner projected = new ProjectedDataScanner(dataScanner, this.projection.getFieldNames(), this.projection.getColumns(), context);
        return new ScanResult(downstream.transactionId, projected);
    }

    public String toString() {
        return "ProjectOp{projection=" + this.projection + ",\ninput=" + this.input + '}';
    }

    private class ProjectedDataScanner
    extends DataScanner {
        final DataScanner downstream;
        final StatementEvaluationContext context;

        public ProjectedDataScanner(DataScanner downstream, String[] fieldNames, Column[] schema, StatementEvaluationContext context) {
            super(downstream.getTransaction(), fieldNames, schema);
            this.downstream = downstream;
            this.context = context;
        }

        @Override
        public boolean hasNext() throws DataScannerException {
            return this.downstream.hasNext();
        }

        @Override
        public DataAccessor next() throws DataScannerException {
            return ProjectOp.this.projection.map(this.downstream.next(), this.context);
        }

        @Override
        public void rewind() throws DataScannerException {
            this.downstream.rewind();
        }

        @Override
        public boolean isRewindSupported() {
            return this.downstream.isRewindSupported();
        }

        @Override
        public void close() throws DataScannerException {
            this.downstream.close();
            super.close();
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
    public static class ZeroCopyProjection
    implements Projection {
        private final Column[] columns;
        private final String[] fieldNames;
        private final int[] zeroCopyProjections;

        public ZeroCopyProjection(String[] fieldNames, Column[] columns, int[] zeroCopyProjections) {
            this.fieldNames = fieldNames;
            this.columns = columns;
            this.zeroCopyProjections = zeroCopyProjections;
        }

        @Override
        public Column[] getColumns() {
            return this.columns;
        }

        @Override
        public String[] getFieldNames() {
            return this.fieldNames;
        }

        @Override
        public DataAccessor map(DataAccessor tuple, StatementEvaluationContext context) throws StatementExecutionException {
            return new RuntimeProjectedDataAccessor(tuple);
        }

        int mapPosition(int field) {
            return this.zeroCopyProjections[field];
        }

        public String toString() {
            return "ZeroCopyProjection{fieldNames=" + Arrays.toString(this.fieldNames) + ", zeroCopyProjections=" + Arrays.toString(this.zeroCopyProjections) + '}';
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        public class RuntimeProjectedDataAccessor
        extends AbstractDataAccessor {
            private final DataAccessor wrapped;

            public RuntimeProjectedDataAccessor(DataAccessor wrapper) {
                this.wrapped = wrapper;
            }

            public String[] getFieldNames() {
                return ZeroCopyProjection.this.fieldNames;
            }

            public Object get(String string) {
                return this.wrapped.get(string);
            }

            public Object get(int i) {
                return this.wrapped.get(ZeroCopyProjection.this.zeroCopyProjections[i]);
            }

            public boolean fieldEqualsTo(int index, Object value) {
                return this.wrapped.fieldEqualsTo(ZeroCopyProjection.this.zeroCopyProjections[index], value);
            }

            public boolean fieldNotEqualsTo(int index, Object value) {
                return this.wrapped.fieldNotEqualsTo(ZeroCopyProjection.this.zeroCopyProjections[index], value);
            }

            public int fieldCompareTo(int index, Object value) {
                return this.wrapped.fieldCompareTo(ZeroCopyProjection.this.zeroCopyProjections[index], value);
            }

            public void forEach(BiConsumer<String, Object> consumer) {
                for (int i = 0; i < ZeroCopyProjection.this.zeroCopyProjections.length; ++i) {
                    Object value = this.wrapped.get(ZeroCopyProjection.this.zeroCopyProjections[i]);
                    consumer.accept(ZeroCopyProjection.this.fieldNames[i], value);
                }
            }

            public Object[] getValues() {
                Object[] data = new Object[ZeroCopyProjection.this.fieldNames.length];
                for (int i = 0; i < ZeroCopyProjection.this.zeroCopyProjections.length; ++i) {
                    data[i] = this.wrapped.get(ZeroCopyProjection.this.zeroCopyProjections[i]);
                }
                return data;
            }
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
    public static class IdentityProjection
    implements Projection {
        private final Column[] columns;
        private final String[] fieldNames;

        public IdentityProjection(String[] fieldNames, Column[] columns) {
            this.fieldNames = fieldNames;
            this.columns = columns;
        }

        @Override
        public Column[] getColumns() {
            return this.columns;
        }

        @Override
        public String[] getFieldNames() {
            return this.fieldNames;
        }

        @Override
        public DataAccessor map(DataAccessor tuple, StatementEvaluationContext context) throws StatementExecutionException {
            return tuple;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
    public static final class BasicProjection
    implements Projection {
        private final Column[] columns;
        private final String[] fieldNames;
        private final List<CompiledSQLExpression> fields;

        public BasicProjection(String[] fieldNames, Column[] columns, List<CompiledSQLExpression> fields) {
            this.fieldNames = fieldNames;
            this.columns = columns;
            this.fields = fields;
        }

        @Override
        public Column[] getColumns() {
            return this.columns;
        }

        @Override
        public String[] getFieldNames() {
            return this.fieldNames;
        }

        @Override
        public DataAccessor map(DataAccessor tuple, StatementEvaluationContext context) throws StatementExecutionException {
            return new RuntimeProjectedDataAccessor(tuple, context);
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        private class RuntimeProjectedDataAccessor
        extends AbstractDataAccessor {
            final Object[] values;
            final BitSet evaluated;
            final DataAccessor wrapper;
            final StatementEvaluationContext context;

            public RuntimeProjectedDataAccessor(DataAccessor wrapper, StatementEvaluationContext context) {
                this.values = new Object[BasicProjection.this.fieldNames.length];
                this.evaluated = new BitSet(BasicProjection.this.fieldNames.length);
                this.wrapper = wrapper;
                this.context = context;
            }

            public String[] getFieldNames() {
                return BasicProjection.this.fieldNames;
            }

            public Object get(String string) {
                for (int i = 0; i < BasicProjection.this.fieldNames.length; ++i) {
                    if (!BasicProjection.this.fieldNames[i].equalsIgnoreCase(string)) continue;
                    return this.get(i);
                }
                return null;
            }

            public Object get(int i) {
                if (!this.evaluated.get(i)) {
                    CompiledSQLExpression exp = (CompiledSQLExpression)BasicProjection.this.fields.get(i);
                    this.values[i] = exp.evaluate(this.wrapper, this.context);
                    this.evaluated.set(i);
                }
                return this.values[i];
            }

            public Object[] getValues() {
                this.ensureFullyEvaluated();
                return this.values;
            }

            public String toString() {
                return "RuntimeProjectedDataAccessor{evaluated: " + this.evaluated + "values=" + Arrays.toString(this.values) + '}';
            }

            private void ensureFullyEvaluated() {
                if (this.evaluated.cardinality() == BasicProjection.this.fieldNames.length) {
                    return;
                }
                for (int i = 0; i < BasicProjection.this.fieldNames.length; ++i) {
                    this.get(i);
                }
            }
        }
    }
}

