/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.AutoIncrementPrimaryKeyRecordFunction;
import herddb.model.Column;
import herddb.model.DMLStatement;
import herddb.model.DMLStatementExecutionResult;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.RecordFunction;
import herddb.model.ScanResult;
import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.TableAwareStatement;
import herddb.model.TransactionContext;
import herddb.model.commands.InsertStatement;
import herddb.model.planner.PlannerOp;
import herddb.sql.SQLRecordFunction;
import herddb.sql.SQLRecordKeyFunction;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.ConstantExpression;
import herddb.utils.Bytes;
import herddb.utils.Wrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.apache.bookkeeper.common.concurrent.FutureUtils;

public class InsertOp
implements PlannerOp {
    private final String tableSpace;
    private final String tableName;
    private final PlannerOp input;
    private final boolean returnValues;
    private final boolean upsert;
    private static final Logger LOG = Logger.getLogger(InsertOp.class.getName());

    public InsertOp(String tableSpace, String tableName, PlannerOp input, boolean returnValues, boolean upsert) {
        this.tableSpace = tableSpace;
        this.tableName = tableName;
        this.input = input.optimize();
        this.returnValues = returnValues;
        this.upsert = upsert;
    }

    @Override
    public String getTablespace() {
        return this.tableSpace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompletableFuture<StatementExecutionResult> executeAsync(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) {
        StatementExecutionResult input = this.input.execute(tableSpaceManager, transactionContext, context, true, true);
        ScanResult downstreamScanResult = (ScanResult)input;
        Table table = tableSpaceManager.getTableManager(this.tableName).getTable();
        long transactionId = transactionContext.transactionId;
        ArrayList<DMLStatement> statements = new ArrayList<DMLStatement>();
        try (DataScanner inputScanner = downstreamScanResult.dataScanner;){
            Object row;
            while (inputScanner.hasNext()) {
                RecordFunction keyfunction;
                row = inputScanner.next();
                long transactionIdFromScanner = inputScanner.getTransactionId();
                if (transactionIdFromScanner > 0L && transactionIdFromScanner != transactionId) {
                    transactionId = transactionIdFromScanner;
                    transactionContext = new TransactionContext(transactionId);
                }
                int index = 0;
                ArrayList<CompiledSQLExpression> keyValueExpression = new ArrayList<CompiledSQLExpression>();
                ArrayList<String> keyExpressionToColumn = new ArrayList<String>();
                ArrayList<CompiledSQLExpression> valuesExpressions = new ArrayList<CompiledSQLExpression>();
                ArrayList<String> valuesColumns = new ArrayList<String>();
                for (Column column : table.getColumns()) {
                    Object value;
                    if ((value = row.get(index++)) == null) continue;
                    ConstantExpression exp = new ConstantExpression(value);
                    if (table.isPrimaryKeyColumn(column.name)) {
                        keyExpressionToColumn.add(column.name);
                        keyValueExpression.add(exp);
                    }
                    valuesColumns.add(column.name);
                    valuesExpressions.add(exp);
                }
                if (keyValueExpression.isEmpty() && table.auto_increment) {
                    keyfunction = new AutoIncrementPrimaryKeyRecordFunction();
                } else {
                    if (keyValueExpression.size() != table.primaryKey.length) {
                        throw new StatementExecutionException("you must set a value for the primary key (expressions=" + keyValueExpression.size() + ")");
                    }
                    keyfunction = new SQLRecordKeyFunction(keyExpressionToColumn, keyValueExpression, table);
                }
                SQLRecordFunction valuesfunction = new SQLRecordFunction(valuesColumns, table, valuesExpressions);
                DMLStatement insertStatement = new InsertStatement(this.tableSpace, this.tableName, keyfunction, valuesfunction, this.upsert).setReturnValues(this.returnValues);
                statements.add(insertStatement);
            }
            if (statements.isEmpty()) {
                row = CompletableFuture.completedFuture(new DMLStatementExecutionResult(transactionId, 0, null, null));
                return row;
            }
            if (statements.size() == 1) {
                row = tableSpaceManager.executeStatementAsync((Statement)statements.get(0), context, transactionContext);
                return row;
            }
            if (this.returnValues) {
                row = FutureUtils.exception((Throwable)((Object)new StatementExecutionException("cannot 'return values' on multi-values insert")));
                return row;
            }
            CompletableFuture<StatementExecutionResult> finalResult = new CompletableFuture<StatementExecutionResult>();
            AtomicInteger updateCounts = new AtomicInteger();
            AtomicReference lastKey = new AtomicReference();
            AtomicReference lastNewValue = new AtomicReference();
            DMLStatement firstStatement = (DMLStatement)statements.get(0);
            class ComputeNext
            implements BiConsumer<StatementExecutionResult, Throwable> {
                int current;
                final /* synthetic */ CompletableFuture val$finalResult;
                final /* synthetic */ AtomicInteger val$updateCounts;
                final /* synthetic */ AtomicReference val$lastKey;
                final /* synthetic */ AtomicReference val$lastNewValue;
                final /* synthetic */ List val$statements;
                final /* synthetic */ TableSpaceManager val$tableSpaceManager;
                final /* synthetic */ StatementEvaluationContext val$context;

                public ComputeNext(int current) {
                    this.val$finalResult = completableFuture;
                    this.val$updateCounts = atomicInteger;
                    this.val$lastKey = atomicReference;
                    this.val$lastNewValue = atomicReference2;
                    this.val$statements = list;
                    this.val$tableSpaceManager = tableSpaceManager;
                    this.val$context = statementEvaluationContext;
                    this.current = current;
                }

                @Override
                public void accept(StatementExecutionResult res, Throwable error) {
                    if (error != null) {
                        this.val$finalResult.completeExceptionally(error);
                        return;
                    }
                    DMLStatementExecutionResult dml = (DMLStatementExecutionResult)res;
                    this.val$updateCounts.addAndGet(dml.getUpdateCount());
                    if (InsertOp.this.returnValues) {
                        this.val$lastKey.set(dml.getKey());
                        this.val$lastNewValue.set(dml.getNewvalue());
                    }
                    long newTransactionId = res.transactionId;
                    if (this.current == this.val$statements.size()) {
                        DMLStatementExecutionResult finalDMLResult = new DMLStatementExecutionResult(newTransactionId, this.val$updateCounts.get(), (Bytes)this.val$lastKey.get(), (Bytes)this.val$lastNewValue.get());
                        this.val$finalResult.complete(finalDMLResult);
                        return;
                    }
                    DMLStatement nextStatement = (DMLStatement)this.val$statements.get(this.current);
                    TransactionContext transactionContext = new TransactionContext(newTransactionId);
                    CompletableFuture<StatementExecutionResult> nextPromise = this.val$tableSpaceManager.executeStatementAsync(nextStatement, this.val$context, transactionContext);
                    nextPromise.whenComplete((BiConsumer)new ComputeNext(this.current + 1));
                }
            }
            tableSpaceManager.executeStatementAsync(firstStatement, context, transactionContext).whenComplete((BiConsumer)new ComputeNext(1));
            CompletableFuture<StatementExecutionResult> completableFuture = finalResult;
            return completableFuture;
        }
        catch (DataScannerException err) {
            throw new StatementExecutionException(err);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(TableAwareStatement.class)) {
            return (T)new TableAwareStatement(this.tableName, this.tableSpace){};
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }
}

