/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.commands;

import herddb.index.PrimaryIndexSeek;
import herddb.model.ConstValueRecordFunction;
import herddb.model.DMLStatement;
import herddb.model.Predicate;
import herddb.model.Record;
import herddb.model.RecordFunction;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;

public class UpdateStatement
extends DMLStatement {
    private final RecordFunction function;
    private final RecordFunction key;
    private final Predicate predicate;

    public UpdateStatement(String tableSpace, String table, Record record, Predicate predicate) {
        this(tableSpace, table, new ConstValueRecordFunction(record.key), new ConstValueRecordFunction(record.value), predicate);
    }

    public UpdateStatement(String tableSpace, String table, RecordFunction key, RecordFunction function, Predicate predicate) {
        super(table, tableSpace);
        this.function = function;
        if (predicate == null) {
            predicate = new Predicate(){

                @Override
                public boolean evaluate(Record record, StatementEvaluationContext context) throws StatementExecutionException {
                    return true;
                }
            };
        }
        if (key != null) {
            predicate.setIndexOperation(new PrimaryIndexSeek(key));
        }
        this.predicate = predicate;
        this.key = key;
    }

    public RecordFunction getFunction() {
        return this.function;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return "UpdateStatement " + System.identityHashCode(this) + " {function=" + this.function + ", key=" + this.key + ", predicate=" + this.predicate + '}';
    }

    @Override
    public void validateContext(StatementEvaluationContext context) throws StatementExecutionException {
        this.predicate.validateContext(context);
    }
}

