/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.commands;

import herddb.model.ConstValueRecordFunction;
import herddb.model.Predicate;
import herddb.model.RecordFunction;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.TableAwareStatement;
import herddb.utils.Bytes;

public class GetStatement
extends TableAwareStatement {
    private final RecordFunction key;
    private final Predicate predicate;
    private final boolean requireLock;

    public GetStatement(String tableSpace, String table, Bytes key, Predicate predicate, boolean requireLock) {
        super(table, tableSpace);
        this.key = new ConstValueRecordFunction(key);
        this.predicate = predicate;
        this.requireLock = requireLock;
    }

    public GetStatement(String tableSpace, String table, RecordFunction key, Predicate predicate, boolean requireLock) {
        super(table, tableSpace);
        this.key = key;
        this.predicate = predicate;
        this.requireLock = requireLock;
    }

    public RecordFunction getKey() {
        return this.key;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public boolean isRequireLock() {
        return this.requireLock;
    }

    @Override
    public void validateContext(StatementEvaluationContext context) throws StatementExecutionException {
        if (this.predicate != null) {
            this.predicate.validateContext(context);
        }
    }
}

