/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.DBManager;
import herddb.model.MissingJDBCParameterException;
import herddb.model.StatementExecutionException;
import herddb.model.TransactionContext;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class StatementEvaluationContext {
    private static final Logger LOGGER = Logger.getLogger(StatementEvaluationContext.class.getName());
    private DBManager manager;
    private TransactionContext transactionContext;
    private String defaultTablespace = "herd";
    private volatile long tableSpaceLock;
    private Timestamp currentTimestamp;

    public static StatementEvaluationContext DEFAULT_EVALUATION_CONTEXT() {
        return new StatementEvaluationContext();
    }

    public String getDefaultTablespace() {
        return this.defaultTablespace;
    }

    public void setDefaultTablespace(String defaultTablespace) {
        this.defaultTablespace = defaultTablespace;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
    }

    public DBManager getManager() {
        return this.manager;
    }

    public void setManager(DBManager manager) {
        this.manager = manager;
    }

    public List<Object> getJdbcParameters() {
        return Collections.emptyList();
    }

    public Object getJdbcParameter(int index) throws StatementExecutionException {
        try {
            return this.getJdbcParameters().get(index);
        }
        catch (IndexOutOfBoundsException err) {
            throw new MissingJDBCParameterException(index + 1);
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
    public Timestamp getCurrentTimestamp() {
        if (this.currentTimestamp == null) {
            this.currentTimestamp = new Timestamp(System.currentTimeMillis());
        }
        return this.currentTimestamp;
    }

    public long getTableSpaceLock() {
        return this.tableSpaceLock;
    }

    public void setTableSpaceLock(long tableSpaceLock) {
        this.tableSpaceLock = tableSpaceLock;
    }
}

