/*
 * Decompiled with CFR 0.152.
 */
package herddb.model;

import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanLimits;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.utils.DataAccessor;

public class LimitedDataScanner
extends DataScanner {
    int remaining;
    final int offset;
    final DataScanner wrapped;

    public LimitedDataScanner(DataScanner wrapped, ScanLimits limits, StatementEvaluationContext context) throws DataScannerException, StatementExecutionException {
        this(wrapped, limits.computeMaxRows(context), limits.computeOffset(context), context);
    }

    public LimitedDataScanner(DataScanner wrapped, int maxRows, int offset, StatementEvaluationContext context) throws DataScannerException, StatementExecutionException {
        super(wrapped.getTransaction(), wrapped.getFieldNames(), wrapped.getSchema());
        this.remaining = maxRows > 0 ? maxRows : -1;
        this.offset = offset;
        this.wrapped = wrapped;
        if (this.offset > 0) {
            for (int i = 0; i < this.offset; ++i) {
                if (!wrapped.hasNext()) continue;
                wrapped.next();
            }
        }
    }

    @Override
    public boolean hasNext() throws DataScannerException {
        if (this.remaining == -1) {
            return this.wrapped.hasNext();
        }
        return this.remaining > 0 & this.wrapped.hasNext();
    }

    @Override
    public DataAccessor next() throws DataScannerException {
        DataAccessor result = this.wrapped.next();
        if (this.remaining != -1) {
            --this.remaining;
        }
        return result;
    }

    @Override
    public void close() throws DataScannerException {
        this.wrapped.close();
        super.close();
    }
}

