/*
 * Decompiled with CFR 0.152.
 */
package herddb.metadata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class NodeIdGenerator {
    private final List<String> list;
    private final Random random = new Random();

    public NodeIdGenerator() {
        try (InputStream in = NodeIdGenerator.class.getResourceAsStream("nodeidslist.txt");
             InputStreamReader read = new InputStreamReader(in, StandardCharsets.UTF_8);
             BufferedReader r = new BufferedReader(read);){
            this.list = r.lines().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).collect(Collectors.toList());
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public String nextId() {
        int r = this.random.nextInt(this.list.size());
        return this.list.get(r);
    }
}

