/*
 * Decompiled with CFR 0.152.
 */
package herddb.mem;

import herddb.log.CommitLog;
import herddb.log.CommitLogManager;
import herddb.log.CommitLogResult;
import herddb.log.LogEntry;
import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import herddb.utils.ExtendedDataOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;

public class MemoryCommitLogManager
extends CommitLogManager {
    private final boolean testSerialize;

    public MemoryCommitLogManager() {
        this(true);
    }

    public MemoryCommitLogManager(boolean testSerialize) {
        this.testSerialize = testSerialize;
    }

    @Override
    public CommitLog createCommitLog(String tableSpace, String tablespaceName, String localNodeId) {
        return new CommitLog(){
            AtomicLong offset = new AtomicLong(-1L);
            private volatile boolean closed;

            @Override
            public CommitLogResult log(LogEntry entry, boolean synch) throws LogNotAvailableException {
                if (this.isHasListeners()) {
                    synch = true;
                }
                if (MemoryCommitLogManager.this.testSerialize) {
                    try {
                        entry.serialize(ExtendedDataOutputStream.NULL);
                    }
                    catch (IOException err) {
                        throw new LogNotAvailableException(err);
                    }
                }
                LogSequenceNumber logPos = new LogSequenceNumber(1L, this.offset.incrementAndGet());
                this.notifyListeners(logPos, entry);
                return new CommitLogResult(logPos, !synch, synch);
            }

            @Override
            public LogSequenceNumber getLastSequenceNumber() {
                return new LogSequenceNumber(1L, this.offset.get());
            }

            @Override
            public void close() throws LogNotAvailableException {
                this.closed = true;
            }

            @Override
            public boolean isFailed() {
                return false;
            }

            @Override
            public boolean isClosed() {
                return this.closed;
            }

            @Override
            public void recovery(LogSequenceNumber snapshotSequenceNumber, BiConsumer<LogSequenceNumber, LogEntry> consumer, boolean fencing) throws LogNotAvailableException {
            }

            @Override
            public void dropOldLedgers(LogSequenceNumber lastCheckPointSequenceNumber) throws LogNotAvailableException {
            }

            @Override
            public void startWriting() throws LogNotAvailableException {
            }

            @Override
            public void clear() throws LogNotAvailableException {
            }
        };
    }
}

