/*
 * Decompiled with CFR 0.152.
 */
package herddb.log;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.utils.Bytes;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.SimpleByteArrayInputStream;
import herddb.utils.SystemProperties;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class LogEntry {
    private static final int EMPTY_STRING_LEN;
    private static final byte[] EMPTY_STRING_SERIALIZED;
    private static final int WRITE_UTF_HEADER_LEN;
    public final short type;
    public final long transactionId;
    public final String tableName;
    public final Bytes key;
    public final Bytes value;
    public final long timestamp;
    private static final int DEFAULT_BUFFER_SIZE;

    public LogEntry(long timestamp, short type, long transactionId, String tableName, Bytes key, Bytes value) {
        this.timestamp = timestamp;
        this.type = type;
        this.transactionId = transactionId;
        this.key = key;
        this.value = value;
        this.tableName = tableName;
    }

    public byte[] serialize() {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ExtendedDataOutputStream doo = new ExtendedDataOutputStream((OutputStream)out);
        try {
            this.serialize(doo);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    doo.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException err) {
                throw new RuntimeException(err);
            }
        }
        doo.close();
        return byArray;
    }

    public ByteBuf serializeAsByteBuf() {
        ByteBuf byteBuf;
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(DEFAULT_BUFFER_SIZE);
        ExtendedDataOutputStream doo = new ExtendedDataOutputStream((OutputStream)new ByteBufOutputStream(buffer));
        try {
            this.serialize(doo);
            byteBuf = buffer;
        }
        catch (Throwable throwable) {
            try {
                try {
                    doo.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException err) {
                throw new RuntimeException(err);
            }
        }
        doo.close();
        return byteBuf;
    }

    public int serialize(ExtendedDataOutputStream doo) throws IOException {
        int startingsize = doo.size();
        doo.writeLong(this.timestamp);
        doo.writeShort((int)this.type);
        doo.writeLong(this.transactionId);
        doo.write(EMPTY_STRING_SERIALIZED);
        switch (this.type) {
            case 3: {
                doo.writeUTF(this.tableName);
                doo.writeArray(this.key);
                doo.writeArray(this.value);
                break;
            }
            case 2: {
                doo.writeUTF(this.tableName);
                doo.writeArray(this.key);
                doo.writeArray(this.value);
                break;
            }
            case 4: {
                doo.writeUTF(this.tableName);
                doo.writeArray(this.key);
                break;
            }
            case 1: 
            case 8: {
                doo.writeUTF(this.tableName);
                doo.writeArray(this.value);
                break;
            }
            case 10: {
                doo.writeUTF(this.tableName);
                doo.writeArray(this.value);
                break;
            }
            case 9: 
            case 12: {
                doo.writeUTF(this.tableName);
                break;
            }
            case 11: {
                doo.writeArray(this.value);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported type " + this.type);
            }
        }
        return doo.size() - startingsize;
    }

    public static LogEntry deserialize(byte[] data) throws EOFException {
        SimpleByteArrayInputStream in = new SimpleByteArrayInputStream(data);
        ExtendedDataInputStream dis = new ExtendedDataInputStream((InputStream)in);
        return LogEntry.deserialize(dis);
    }

    public static LogEntry deserialize(ExtendedDataInputStream dis) throws EOFException {
        try {
            long timestamp = dis.readLong();
            short type = dis.readShort();
            long transactionId = dis.readLong();
            dis.readUTF();
            Bytes key = null;
            Bytes value = null;
            String tableName = null;
            switch (type) {
                case 3: {
                    tableName = dis.readUTF();
                    key = dis.readBytes();
                    value = dis.readBytes();
                    break;
                }
                case 2: {
                    tableName = dis.readUTF();
                    key = dis.readBytes();
                    value = dis.readBytes();
                    break;
                }
                case 4: {
                    tableName = dis.readUTF();
                    key = dis.readBytes();
                    break;
                }
                case 9: 
                case 12: {
                    tableName = dis.readUTF();
                    break;
                }
                case 11: {
                    value = dis.readBytes();
                    break;
                }
                case 10: {
                    tableName = dis.readUTF();
                    value = dis.readBytes();
                    break;
                }
                case 1: 
                case 8: {
                    tableName = dis.readUTF();
                    value = dis.readBytes();
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported type " + type);
                }
            }
            return new LogEntry(timestamp, type, transactionId, tableName, key, value);
        }
        catch (EOFException e) {
            throw e;
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public String toString() {
        return "LE{t=" + this.type + ",tx=" + this.transactionId + ",tn=" + this.tableName + ",k=" + this.key + ",v=" + this.value + ",ts=" + this.timestamp + '}';
    }

    static {
        try (ByteArrayOutputStream oo = new ByteArrayOutputStream();){
            try (ExtendedDataOutputStream doo = new ExtendedDataOutputStream((OutputStream)oo);){
                doo.writeUTF("");
            }
            EMPTY_STRING_LEN = oo.size();
            EMPTY_STRING_SERIALIZED = oo.toByteArray();
        }
        catch (IOException impossible) {
            throw new RuntimeException(impossible);
        }
        WRITE_UTF_HEADER_LEN = EMPTY_STRING_LEN;
        DEFAULT_BUFFER_SIZE = SystemProperties.getIntSystemProperty((String)"herddb.log.initentrysize", (int)2024);
    }
}

