/*
 * Decompiled with CFR 0.152.
 */
package herddb.log;

import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public final class CommitLogResult {
    public final CompletableFuture<LogSequenceNumber> logSequenceNumber;
    public final boolean deferred;
    public final boolean sync;

    public CommitLogResult(LogSequenceNumber logSequenceNumber, boolean deferred, boolean sync) {
        this.logSequenceNumber = CompletableFuture.completedFuture(logSequenceNumber);
        this.deferred = deferred;
        this.sync = sync;
    }

    public CommitLogResult(CompletableFuture<LogSequenceNumber> logSequenceNumber, boolean deferred, boolean sync) {
        this.logSequenceNumber = logSequenceNumber;
        this.deferred = deferred;
        this.sync = sync;
    }

    public LogSequenceNumber getLogSequenceNumber() throws LogNotAvailableException {
        try {
            return this.logSequenceNumber.get();
        }
        catch (ExecutionException err) {
            throw new LogNotAvailableException(err.getCause());
        }
        catch (InterruptedException err) {
            throw new LogNotAvailableException(err);
        }
    }
}

