/*
 * Decompiled with CFR 0.152.
 */
package herddb.log;

import herddb.log.CommitLogListener;
import herddb.log.CommitLogResult;
import herddb.log.LogEntry;
import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommitLog
implements AutoCloseable {
    protected CommitLogListener[] listeners = null;
    private static final Logger LOG = Logger.getLogger(CommitLog.class.getName());

    public abstract CommitLogResult log(LogEntry var1, boolean var2) throws LogNotAvailableException;

    public abstract void recovery(LogSequenceNumber var1, BiConsumer<LogSequenceNumber, LogEntry> var2, boolean var3) throws LogNotAvailableException;

    public boolean isRecoveryAvailable(LogSequenceNumber snapshotSequenceNumber) {
        return true;
    }

    public <T extends FollowerContext> T startFollowing(LogSequenceNumber lastPosition) {
        return null;
    }

    public void followTheLeader(LogSequenceNumber skipPast, EntryAcceptor consumer, FollowerContext context) throws LogNotAvailableException {
    }

    public abstract LogSequenceNumber getLastSequenceNumber();

    public abstract void startWriting() throws LogNotAvailableException;

    public abstract void clear() throws LogNotAvailableException;

    @Override
    public abstract void close() throws LogNotAvailableException;

    public abstract boolean isFailed();

    public abstract boolean isClosed();

    public abstract void dropOldLedgers(LogSequenceNumber var1) throws LogNotAvailableException;

    protected synchronized boolean isHasListeners() {
        return this.listeners != null;
    }

    protected synchronized void notifyListeners(LogSequenceNumber logPos, LogEntry edit) {
        if (this.listeners != null) {
            for (CommitLogListener l : this.listeners) {
                LOG.log(Level.INFO, "notifyListeners {0}, {1}", new Object[]{logPos, edit});
                l.logEntry(logPos, edit);
            }
        }
    }

    public synchronized void attachCommitLogListener(CommitLogListener l) {
        if (this.listeners == null) {
            CommitLogListener[] _listeners = new CommitLogListener[]{l};
            this.listeners = _listeners;
        } else {
            CommitLogListener[] _listeners = new CommitLogListener[this.listeners.length + 1];
            if (this.listeners.length > 0) {
                System.arraycopy(this.listeners, 0, _listeners, 0, this.listeners.length);
            }
            _listeners[_listeners.length - 1] = l;
            this.listeners = _listeners;
        }
    }

    public synchronized void removeCommitLogListener(CommitLogListener l) {
        CommitLogListener[] _listeners = new CommitLogListener[this.listeners.length - 1];
        int pos = 0;
        boolean found = false;
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] != l) {
                _listeners[pos++] = this.listeners[i];
                continue;
            }
            found = true;
        }
        if (found) {
            this.listeners = _listeners.length == 0 ? null : _listeners;
        }
    }

    public static interface EntryAcceptor {
        public boolean accept(LogSequenceNumber var1, LogEntry var2) throws Exception;
    }

    public static interface FollowerContext
    extends AutoCloseable {
        @Override
        default public void close() {
        }
    }
}

