/*
 * Decompiled with CFR 0.152.
 */
package herddb.index.brin;

import herddb.index.brin.IndexDataStorage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryIndexDataStorage<K, V>
implements IndexDataStorage<K, V> {
    AtomicLong newPageId = new AtomicLong();
    private final ConcurrentHashMap<Long, List<Map.Entry<K, V>>> pages = new ConcurrentHashMap();

    @Override
    public List<Map.Entry<K, V>> loadDataPage(long pageId) throws IOException {
        List<Map.Entry<K, V>> page = this.pages.get(pageId);
        if (page == null) {
            throw new IOException("Unknown pageId " + pageId);
        }
        return page;
    }

    @Override
    public long createDataPage(List<Map.Entry<K, V>> values) throws IOException {
        long newid = this.newPageId.incrementAndGet();
        this.pages.put(newid, values);
        return newid;
    }

    public void dropDataPage(long pageId) {
        this.pages.remove(pageId);
    }

    public Set<Long> getPages() {
        return this.pages.keySet();
    }
}

