/*
 * Decompiled with CFR 0.152.
 */
package herddb.index.brin;

import herddb.core.Page;
import herddb.core.PageReplacementPolicy;
import herddb.index.brin.BlockRangeIndexMetadata;
import herddb.index.brin.IndexDataStorage;
import herddb.index.brin.MemoryIndexDataStorage;
import herddb.storage.DataStorageManagerException;
import herddb.utils.EnsureLongIncrementAccumulator;
import herddb.utils.SizeAwareObject;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongBinaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class BlockRangeIndex<K extends Comparable<K> & SizeAwareObject, V extends SizeAwareObject> {
    private static final Logger LOG = Logger.getLogger(BlockRangeIndex.class.getName());
    private static final long ENTRY_CONSTANT_BYTE_SIZE = 93L;
    private static final long BLOCK_CONSTANT_BYTE_SIZE = 128L;
    private final long maxPageBlockSize;
    private final long minPageBlockSize;
    private final ConcurrentNavigableMap<BlockStartKey<K>, Block<K, V>> blocks = new ConcurrentSkipListMap<BlockStartKey<K>, Block<K, V>>();
    private final AtomicLong currentBlockId = new AtomicLong(0L);
    private final IndexDataStorage<K, V> dataStorage;
    private final PageReplacementPolicy pageReplacementPolicy;

    public BlockRangeIndex(long maxBlockSize, PageReplacementPolicy pageReplacementPolicy) {
        this(maxBlockSize, pageReplacementPolicy, new MemoryIndexDataStorage());
    }

    public BlockRangeIndex(long maxBlockSize, PageReplacementPolicy pageReplacementPolicy, IndexDataStorage<K, V> dataStorage) {
        this.maxPageBlockSize = maxBlockSize - 128L;
        if (maxBlockSize < 0L) {
            throw new IllegalArgumentException("page size to small to store any index entry: " + maxBlockSize);
        }
        this.minPageBlockSize = maxBlockSize / 3L;
        this.pageReplacementPolicy = pageReplacementPolicy;
        this.dataStorage = dataStorage;
    }

    private long evaluateEntrySize(K key, V value) {
        long size = ((SizeAwareObject)key).getEstimatedSize() + value.getEstimatedSize() + 93L;
        if (size > this.maxPageBlockSize) {
            throw new IllegalStateException("entry too big to fit in any page " + size + " bytes");
        }
        return size;
    }

    public int getNumBlocks() {
        return this.blocks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockRangeIndexMetadata.BlockMetadata<K> merge(Block<K, V> first, List<Block<K, V>> merging) throws IOException {
        boolean fineEnabled = LOG.isLoggable(Level.FINE);
        if (merging.isEmpty()) {
            if (fineEnabled) {
                LOG.fine("block " + ((Block)first).pageId + " (" + first.key + ") has " + first + " byte size at checkpoint");
            }
            return ((Block)first).checkpoint();
        }
        ListIterator<Block<K, V>> iterator = merging.listIterator(merging.size());
        Page.Metadata firstBlockUnload = null;
        ((Block)first).lock.lock();
        try {
            first.ensureBlockLoaded();
            while (iterator.hasPrevious()) {
                Block<K, V> other = iterator.previous();
                ((Block)other).lock.lock();
                try {
                    if (other.size != 0L) {
                        Page.Metadata unload = other.ensureBlockLoadedWithoutUnload();
                        if (unload != null) {
                            if (((Block)first).page.owner == unload.owner) {
                                firstBlockUnload = unload;
                            } else {
                                unload.owner.unload(unload.pageId);
                            }
                        }
                        List potentialOverwrite = (List)first.values.get(other.key.minKey);
                        first.values.putAll(other.values);
                        if (potentialOverwrite != null) {
                            first.values.merge(other.key.minKey, potentialOverwrite, (l1, l2) -> {
                                l1.addAll(l2);
                                return l1;
                            });
                        }
                        first.size += other.size;
                    }
                    if (fineEnabled) {
                        if (other.size != 0L) {
                            LOG.fine("unlinking block " + ((Block)first).pageId + " (" + first.key + ") from merged block " + ((Block)other).pageId + " (" + other.key + ")");
                        } else {
                            LOG.fine("unlinking block " + ((Block)first).pageId + " (" + first.key + ") from deleted block " + ((Block)other).pageId + " (" + other.key + ")");
                        }
                        if (other.next != null) {
                            LOG.fine("linking block " + ((Block)first).pageId + " (" + first.key + ") to real next block " + other.next.pageId + " (" + other.next.key + ")");
                        }
                    }
                    first.next = other.next;
                    other.unloadNoLock();
                    this.blocks.remove(other.key);
                }
                finally {
                    ((Block)other).lock.unlock();
                }
            }
        }
        finally {
            ((Block)first).lock.unlock();
        }
        if (fineEnabled) {
            LOG.fine("merged block " + ((Block)first).pageId + " (" + first.key + ") has " + first.size + " byte size at checkpoint");
        }
        BlockRangeIndexMetadata.BlockMetadata metadata = ((Block)first).checkpointNoLock();
        if (firstBlockUnload != null) {
            firstBlockUnload.owner.unload(firstBlockUnload.pageId);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockRangeIndexMetadata<K> checkpoint() throws IOException {
        boolean fineEnabled = LOG.isLoggable(Level.FINE);
        ArrayList blocksMetadata = new ArrayList();
        Iterator iterator = this.blocks.descendingMap().values().iterator();
        long mergeSize = 0L;
        Block lastMergeReference = null;
        ArrayList<Block<K, V>> mergeReferences = new ArrayList<Block<K, V>>();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            block.lock.lock();
            try {
                BlockRangeIndexMetadata.BlockMetadata<K> merged;
                long size = block.size;
                if (size < this.minPageBlockSize) {
                    if ((mergeSize += size) > this.maxPageBlockSize) {
                        merged = this.merge(lastMergeReference, mergeReferences);
                        blocksMetadata.add(merged);
                        lastMergeReference = block;
                        mergeReferences.clear();
                        mergeSize = size;
                        continue;
                    }
                    if (lastMergeReference != null) {
                        mergeReferences.add(lastMergeReference);
                    }
                    lastMergeReference = block;
                    continue;
                }
                if (lastMergeReference != null) {
                    merged = this.merge(lastMergeReference, mergeReferences);
                    blocksMetadata.add(merged);
                    lastMergeReference = null;
                    mergeReferences.clear();
                    mergeSize = 0L;
                }
                if (fineEnabled) {
                    LOG.fine("block " + block.pageId + " (" + block.key + ") has " + size + " byte size at checkpoint");
                }
                blocksMetadata.add(block.checkpointNoLock());
            }
            finally {
                block.lock.unlock();
            }
        }
        if (lastMergeReference != null) {
            BlockRangeIndexMetadata.BlockMetadata<K> merged = this.merge(lastMergeReference, mergeReferences);
            blocksMetadata.add(merged);
            lastMergeReference = null;
            mergeReferences.clear();
        }
        return new BlockRangeIndexMetadata(blocksMetadata);
    }

    String generateDetailedInternalStatus() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nBRIN detailed internal status:\n").append(" - currentBlockId: ").append(this.currentBlockId.get()).append('\n').append(" - minPageBlockSize: ").append(this.minPageBlockSize).append('\n').append(" - maxPageBlockSize: ").append(this.maxPageBlockSize).append('\n').append(" - blocks: ").append(this.blocks.size()).append('\n');
        builder.append("Ordered blocks navigation:").append('\n');
        this.blocks.forEach((k, b) -> {
            builder.append("----[Block ").append(k.blockId).append(" MinKey ").append(k.minKey).append("]----").append('\n').append("key: ").append("block ").append(b.key.blockId).append(" minKey ").append(b.key.minKey).append('\n');
            if (b.next == null) {
                builder.append("next: null").append('\n');
            } else {
                builder.append("next: block").append(b.next.key.blockId).append(" min key ").append(b.next.key.minKey).append('\n');
            }
            builder.append("pageId: ").append(((Block)b).pageId).append('\n').append("size: ").append(b.size).append('\n').append("loaded: ").append(((Block)b).loaded).append('\n').append("dirty: ").append(((Block)b).dirty).append('\n');
        });
        return builder.toString();
    }

    public void put(K key, V value) {
        BlockStartKey<K> lookUp = BlockStartKey.valueOf(key, Long.MAX_VALUE);
        PutState state = new PutState();
        state.next = (Block)this.blocks.floorEntry(lookUp).getValue();
        do {
            state.next.addValue(key, value, state);
        } while (state.next != null);
    }

    public void delete(K key, V value) {
        BlockStartKey<K> lookUp = BlockStartKey.valueOf(key, Long.MIN_VALUE);
        DeleteState state = new DeleteState();
        state.next = (Block)this.blocks.floorEntry(lookUp).getValue();
        do {
            state.next.delete(key, value, state);
        } while (state.next != null);
    }

    public List<V> search(K firstKey, K lastKey) {
        LookupState state = new LookupState();
        if (firstKey != null) {
            BlockStartKey<K> lookUp = BlockStartKey.valueOf(firstKey, Long.MIN_VALUE);
            state.next = (Block)this.blocks.floorEntry(lookUp).getValue();
        } else {
            state.next = (Block)this.blocks.firstEntry().getValue();
        }
        do {
            state.next.lookUpRange(firstKey, lastKey, state);
        } while (state.next != null);
        return state.found;
    }

    public List<V> search(K key) {
        return this.search(key, key);
    }

    public Stream<V> query(K firstKey, K lastKey) {
        return this.search(firstKey, lastKey).stream();
    }

    public Stream<V> query(K key) {
        return this.query(key, key);
    }

    public boolean containsKey(K key) {
        return !this.search(key, key).isEmpty();
    }

    public void boot(BlockRangeIndexMetadata<K> metadata) throws DataStorageManagerException {
        LOG.severe("boot index, with " + metadata.getBlocksMetadata().size() + " blocks");
        if (metadata.getBlocksMetadata().size() == 0) {
            this.reset();
        } else {
            this.clear();
            Block next = null;
            for (BlockRangeIndexMetadata.BlockMetadata<K> blockData : metadata.getBlocksMetadata()) {
                if (blockData.nextBlockId != null) {
                    if (next == null) {
                        throw new DataStorageManagerException("Wrong next block, expected notingh but " + blockData.nextBlockId + " found");
                    }
                    if (next.key.blockId != blockData.nextBlockId) {
                        throw new DataStorageManagerException("Wrong next block, expected " + next.key.blockId + " but " + blockData.nextBlockId + " found");
                    }
                } else if (next != null) {
                    throw new DataStorageManagerException("Wrong next block, expected " + next.key.blockId + " but nothing found");
                }
                BlockStartKey key = BlockStartKey.valueOf(blockData.firstKey, blockData.blockId);
                next = new Block(this, key, blockData.size, blockData.pageId, next);
                this.blocks.put(key, next);
                this.currentBlockId.accumulateAndGet(Math.abs(next.key.blockId), (LongBinaryOperator)EnsureLongIncrementAccumulator.INSTANCE);
            }
        }
    }

    void reset() {
        this.clear();
        Block headBlock = new Block(this);
        this.blocks.put(BlockStartKey.HEAD_KEY, headBlock);
        Page.Metadata unload = this.pageReplacementPolicy.add((Page)headBlock.page);
        if (unload != null) {
            unload.owner.unload(unload.pageId);
        }
        this.currentBlockId.set(0L);
    }

    void clear() {
        for (Block block : this.blocks.values()) {
            if (!block.forcedUnload()) continue;
            this.pageReplacementPolicy.remove((Page)block.page);
        }
        this.blocks.clear();
    }

    ConcurrentNavigableMap<BlockStartKey<K>, Block<K, V>> getBlocks() {
        return this.blocks;
    }

    long getCurrentBlockId() {
        return this.currentBlockId.get();
    }

    static final class Block<Key extends Comparable<Key> & SizeAwareObject, Val extends SizeAwareObject>
    implements Page.Owner {
        final BlockRangeIndex<Key, Val> index;
        final BlockStartKey<Key> key;
        NavigableMap<Key, List<Val>> values;
        long size;
        Block<Key, Val> next;
        private final ReentrantLock lock = new ReentrantLock(true);
        private volatile boolean loaded;
        private volatile boolean dirty;
        private volatile long pageId;
        private final BRINPage<Key, Val> page;

        public Block(BlockRangeIndex<Key, Val> index, BlockStartKey<Key> key, long size, long pageId, Block<Key, Val> next) {
            this.index = index;
            this.key = key;
            this.size = size;
            this.next = next;
            this.loaded = false;
            this.dirty = false;
            this.pageId = pageId;
            this.page = new BRINPage(this, key.blockId);
        }

        public Block(BlockRangeIndex<Key, Val> index) {
            this.index = index;
            this.key = BlockStartKey.HEAD_KEY;
            this.values = new TreeMap<Key, List<Val>>();
            this.size = 0L;
            this.loaded = true;
            this.dirty = true;
            this.pageId = -1L;
            this.page = new BRINPage(this, this.key.blockId);
        }

        private Block(BlockRangeIndex<Key, Val> index, BlockStartKey<Key> key, NavigableMap<Key, List<Val>> values, long size, Block<Key, Val> next) {
            this.index = index;
            this.key = key;
            this.values = values;
            this.size = size;
            this.next = next;
            this.loaded = true;
            this.dirty = true;
            this.pageId = -1L;
            this.page = new BRINPage(this, key.blockId);
        }

        long getSize() {
            return this.size;
        }

        boolean isLoaded() {
            return this.loaded;
        }

        boolean isDirty() {
            return this.dirty;
        }

        private void mergeAddValue(Key key1, Val value, Map<Key, List<Val>> values) {
            List<Val> valuesForKey = values.get(key1);
            if (valuesForKey == null) {
                valuesForKey = new ArrayList<Val>();
                values.put(key1, valuesForKey);
            }
            valuesForKey.add(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addValue(Key key, Val value, PutState<Key, Val> state) {
            Page.Metadata unload;
            Block<Key, Val> newblock = null;
            this.lock.lock();
            try {
                Block<Key, Val> currentNext = this.next;
                if (currentNext != null && currentNext.key.compareMinKey(key) <= 0) {
                    state.next = currentNext;
                    return;
                }
                this.ensureBlockLoaded();
                this.mergeAddValue(key, value, this.values);
                this.size += ((BlockRangeIndex)this.index).evaluateEntrySize(key, value);
                this.dirty = true;
                if (this.size > ((BlockRangeIndex)this.index).maxPageBlockSize) {
                    newblock = this.split();
                }
            }
            finally {
                this.lock.unlock();
            }
            if (newblock != null && (unload = ((BlockRangeIndex)this.index).pageReplacementPolicy.add(newblock.page)) != null) {
                unload.owner.unload(unload.pageId);
            }
            state.next = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delete(Key key, Val value, DeleteState<Key, Val> state) {
            this.lock.lock();
            try {
                int nextMinKeyCompare;
                Block<Key, Val> currentNext = this.next;
                int n = nextMinKeyCompare = currentNext == null ? -1 : currentNext.key.compareMinKey(key);
                if (currentNext == null || nextMinKeyCompare >= 0) {
                    boolean removed;
                    this.ensureBlockLoaded();
                    List valuesForKey = (List)this.values.get(key);
                    if (valuesForKey != null && (removed = valuesForKey.remove(value))) {
                        if (valuesForKey.isEmpty()) {
                            this.values.remove(key);
                        }
                        this.size -= ((BlockRangeIndex)this.index).evaluateEntrySize(key, value);
                        this.dirty = true;
                        state.next = null;
                        return;
                    }
                }
                state.next = currentNext != null && nextMinKeyCompare <= 0 ? currentNext : null;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void lookUpRange(Key firstKey, Key lastKey, LookupState<Key, Val> state) {
            this.lock.lock();
            try {
                Block<Key, Val> currentNext = this.next;
                if (firstKey != null && lastKey != null) {
                    if (currentNext == null || currentNext.key.compareMinKey(firstKey) >= 0) {
                        this.ensureBlockLoaded();
                        if (firstKey.equals(lastKey)) {
                            List seek = (List)this.values.get(firstKey);
                            if (seek != null && !seek.isEmpty()) {
                                state.found.addAll(seek);
                            }
                        } else if (lastKey.compareTo(firstKey) >= 0) {
                            this.values.subMap(firstKey, true, lastKey, true).forEach((k, seg) -> state.found.addAll(seg));
                        }
                    }
                } else if (firstKey != null) {
                    if (currentNext == null || currentNext.key.compareMinKey(firstKey) >= 0) {
                        this.ensureBlockLoaded();
                        this.values.tailMap(firstKey, true).forEach((k, seg) -> state.found.addAll(seg));
                    }
                } else {
                    this.ensureBlockLoaded();
                    this.values.headMap(lastKey, true).forEach((k, seg) -> state.found.addAll(seg));
                }
                state.next = currentNext != null && (lastKey == null || currentNext.key.compareMinKey(lastKey) <= 0) ? currentNext : null;
            }
            finally {
                this.lock.unlock();
            }
        }

        void ensureBlockLoaded() {
            Page.Metadata unload = this.ensureBlockLoadedWithoutUnload();
            if (unload != null) {
                unload.owner.unload(unload.pageId);
            }
        }

        Page.Metadata ensureBlockLoadedWithoutUnload() {
            if (!this.loaded) {
                try {
                    this.values = new TreeMap<Key, List<Val>>();
                    if (this.size != 0L) {
                        List loadDataPage = ((BlockRangeIndex)this.index).dataStorage.loadDataPage(this.pageId);
                        for (Map.Entry entry : loadDataPage) {
                            this.mergeAddValue((Comparable)entry.getKey(), (SizeAwareObject)entry.getValue(), this.values);
                        }
                    }
                    this.loaded = true;
                    Page.Metadata unload = ((BlockRangeIndex)this.index).pageReplacementPolicy.add(this.page);
                    return unload;
                }
                catch (IOException err) {
                    throw new RuntimeException(err);
                }
            }
            ((BlockRangeIndex)this.index).pageReplacementPolicy.pageHit(this.page);
            return null;
        }

        private Block<Key, Val> split() {
            if (this.size < ((BlockRangeIndex)this.index).maxPageBlockSize) {
                throw new IllegalStateException("Split on a non overflowing block");
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Split: FK " + this.key, new Object[]{this.key});
            }
            TreeMap<Key, List<Val>> keepValues = new TreeMap<Key, List<Val>>();
            TreeMap otherValues = new TreeMap();
            long splitSize = this.size / 2L;
            long mySize = 0L;
            long otherSize = 0L;
            for (Map.Entry entry : this.values.entrySet()) {
                Comparable key = (Comparable)entry.getKey();
                for (SizeAwareObject v : (List)entry.getValue()) {
                    long entrySize = ((BlockRangeIndex)this.index).evaluateEntrySize(key, v);
                    if (mySize < splitSize) {
                        this.mergeAddValue(key, v, keepValues);
                        mySize += entrySize;
                        continue;
                    }
                    this.mergeAddValue(key, v, otherValues);
                    otherSize += entrySize;
                }
            }
            if (otherValues.isEmpty()) {
                return null;
            }
            Comparable newOtherMinKey = (Comparable)otherValues.firstKey();
            long newBlockId = ((BlockRangeIndex)this.index).currentBlockId.incrementAndGet();
            if (this.key == BlockStartKey.HEAD_KEY || !this.key.minKey.equals(newOtherMinKey)) {
                newBlockId = -newBlockId;
            }
            Block<Comparable, Val> newblock = new Block<Comparable, Val>(this.index, BlockStartKey.valueOf(newOtherMinKey, newBlockId), otherValues, otherSize, this.next);
            this.next = newblock;
            this.size = mySize;
            this.values = keepValues;
            ((BlockRangeIndex)this.index).blocks.put(newblock.key, newblock);
            return newblock;
        }

        private BlockRangeIndexMetadata.BlockMetadata<Key> checkpointNoLock() throws IOException {
            if (!this.dirty || !this.loaded) {
                Long nextBlockId = this.next == null ? null : Long.valueOf(this.next.key.blockId);
                return new BlockRangeIndexMetadata.BlockMetadata(this.key.minKey, this.key.blockId, this.size, this.pageId, nextBlockId);
            }
            ArrayList result = new ArrayList();
            this.values.forEach((k, l) -> l.forEach(v -> result.add(new AbstractMap.SimpleImmutableEntry<Comparable, SizeAwareObject>((Comparable)k, (SizeAwareObject)v))));
            long newPageId = ((BlockRangeIndex)this.index).dataStorage.createDataPage(result);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("checkpoint block " + this.key + ": newpage -> " + newPageId + " with " + this.values.size() + " entries x " + result.size() + " pointers");
            }
            this.dirty = false;
            this.pageId = newPageId;
            Long nextBlockId = this.next == null ? null : Long.valueOf(this.next.key.blockId);
            return new BlockRangeIndexMetadata.BlockMetadata(this.key.minKey, this.key.blockId, this.size, this.pageId, nextBlockId);
        }

        private BlockRangeIndexMetadata.BlockMetadata<Key> checkpoint() throws IOException {
            this.lock.lock();
            try {
                BlockRangeIndexMetadata.BlockMetadata<Key> blockMetadata = this.checkpointNoLock();
                return blockMetadata;
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean unloadNoLock() throws IOException {
            if (!this.loaded) {
                return false;
            }
            if (this.dirty) {
                this.checkpoint();
            }
            this.values = null;
            this.loaded = false;
            return true;
        }

        boolean unload() throws IOException {
            this.lock.lock();
            try {
                boolean bl = this.unloadNoLock();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private boolean forcedUnload() {
            this.lock.lock();
            try {
                if (!this.loaded) {
                    boolean bl = false;
                    return bl;
                }
                this.values = null;
                this.loaded = false;
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void unload(long pageId) {
            if (this.page.pageId == this.page.pageId) {
                try {
                    this.unload();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new IllegalArgumentException("Expecting to receive managed page " + this.page.pageId + " got " + pageId);
            }
        }

        public String toString() {
            return "Block{key=" + this.key + ", minKey=" + this.key.minKey + ", size=" + this.size + ", next=" + (this.next == null ? null : this.next.key) + "}";
        }
    }

    static final class BlockStartKey<K extends Comparable<K>>
    implements Comparable<BlockStartKey<K>> {
        static final BlockStartKey<?> HEAD_KEY = new BlockStartKey<Object>(null, 0L);
        public final K minKey;
        public final long blockId;

        public String toString() {
            if (this.minKey == null) {
                return "BlockStartKey{HEAD}";
            }
            return "BlockStartKey{" + this.minKey + "," + this.blockId + '}';
        }

        public static <X extends Comparable<X>> BlockStartKey<X> valueOf(X minKey, long segmentId) {
            if (minKey == null) {
                if (segmentId != BlockStartKey.HEAD_KEY.blockId) {
                    throw new IllegalArgumentException();
                }
                return HEAD_KEY;
            }
            return new BlockStartKey<X>(minKey, segmentId);
        }

        private BlockStartKey(K minKey, long segmentId) {
            this.minKey = minKey;
            this.blockId = segmentId;
        }

        @Override
        public int compareTo(BlockStartKey<K> o) {
            if (o == this) {
                return 0;
            }
            if (HEAD_KEY == this) {
                return -1;
            }
            if (o == HEAD_KEY) {
                return 1;
            }
            int diff = this.minKey.compareTo(o.minKey);
            if (diff != 0) {
                return diff;
            }
            return Long.compare(this.blockId, o.blockId);
        }

        public int compareMinKey(K other) {
            if (HEAD_KEY == this) {
                return -1;
            }
            return this.minKey.compareTo(other);
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + Objects.hashCode(this.minKey);
            hash = 67 * hash + Long.hashCode(this.blockId);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockStartKey other = (BlockStartKey)obj;
            if (this.blockId != other.blockId) {
                return false;
            }
            return Objects.equals(this.minKey, other.minKey);
        }
    }

    private static final class BRINPage<Key extends Comparable<Key> & SizeAwareObject, Val extends SizeAwareObject>
    extends Page<Block<Key, Val>> {
        public BRINPage(Block<Key, Val> owner, long blockId) {
            super(owner, blockId);
        }

        public String toString() {
            return "BRINPage [owner=" + this.owner + ", pageId=" + this.pageId + "]";
        }
    }

    private static class PutState<Key extends Comparable<Key> & SizeAwareObject, Val extends SizeAwareObject> {
        Block<Key, Val> next;
    }

    private static class DeleteState<Key extends Comparable<Key> & SizeAwareObject, Val extends SizeAwareObject> {
        Block<Key, Val> next;
    }

    private static class LookupState<Key extends Comparable<Key> & SizeAwareObject, Val extends SizeAwareObject> {
        Block<Key, Val> next;
        List<Val> found = new ArrayList<Val>();
    }
}

