/*
 * Decompiled with CFR 0.152.
 */
package herddb.index.blink;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.AbstractIndexManager;
import herddb.core.MemoryManager;
import herddb.core.PostCheckpointAction;
import herddb.index.IndexOperation;
import herddb.index.KeyToPageIndex;
import herddb.index.PrimaryIndexPrefixScan;
import herddb.index.PrimaryIndexRangeScan;
import herddb.index.PrimaryIndexSeek;
import herddb.index.blink.BLink;
import herddb.index.blink.BLinkIndexDataStorage;
import herddb.index.blink.BLinkMetadata;
import herddb.log.LogSequenceNumber;
import herddb.model.InvalidNullValueForKeyException;
import herddb.model.RecordFunction;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.TableContext;
import herddb.sql.SQLRecordKeyFunction;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.storage.IndexStatus;
import herddb.utils.ByteArrayCursor;
import herddb.utils.Bytes;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class BLinkKeyToPageIndex
implements KeyToPageIndex {
    private static final Logger LOGGER = Logger.getLogger(BLinkKeyToPageIndex.class.getName());
    public static final byte METADATA_PAGE = 0;
    public static final byte INNER_NODE_PAGE = 1;
    public static final byte LEAF_NODE_PAGE = 2;
    private static final byte NODE_PAGE_END_BLOCK = 0;
    private static final byte NODE_PAGE_KEY_VALUE_BLOCK = 1;
    private static final byte NODE_PAGE_INF_BLOCK = 2;
    private static final int METADATA_PAGE_END_BLOCK = 0;
    private static final int METADATA_PAGE_NODE_BLOCK = 1;
    private final String tableSpace;
    private final String indexName;
    private final MemoryManager memoryManager;
    private final DataStorageManager dataStorageManager;
    private final AtomicLong newPageId;
    private final BLinkIndexDataStorage<Bytes, Long> indexDataStorage;
    private volatile BLink<Bytes, Long> tree;
    private final AtomicBoolean closed;

    public static String deriveIndexName(String tableName) {
        return tableName + "_primary";
    }

    public BLinkKeyToPageIndex(String tableSpace, String tableName, MemoryManager memoryManager, DataStorageManager dataStorageManager) {
        this.tableSpace = tableSpace;
        this.indexName = BLinkKeyToPageIndex.deriveIndexName(tableName);
        this.memoryManager = memoryManager;
        this.dataStorageManager = dataStorageManager;
        this.newPageId = new AtomicLong(1L);
        this.indexDataStorage = new BLinkIndexDataStorageImpl();
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public long size() {
        return this.getTree().size();
    }

    @Override
    public void put(Bytes key, Long currentPage) {
        this.getTree().insert((Comparable)key, (Object)currentPage);
    }

    @Override
    public boolean put(Bytes key, Long newPage, Long expectedPage) {
        return this.getTree().insert((Comparable)key, (Object)newPage, (Object)expectedPage);
    }

    @Override
    public boolean containsKey(Bytes key) {
        return this.getTree().search((Comparable)key) != null;
    }

    @Override
    public Long get(Bytes key) {
        return (Long)this.getTree().search((Comparable)key);
    }

    @Override
    public Long remove(Bytes key) {
        return (Long)this.getTree().delete((Comparable)key);
    }

    @Override
    public boolean isSortedAscending(int[] pkTypes) {
        if (pkTypes.length != 1) {
            return false;
        }
        switch (pkTypes[0]) {
            case 0: 
            case 3: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Stream<Map.Entry<Bytes, Long>> scanner(IndexOperation operation, StatementEvaluationContext context, TableContext tableContext, AbstractIndexManager index) throws DataStorageManagerException, StatementExecutionException {
        if (operation instanceof PrimaryIndexSeek) {
            PrimaryIndexSeek seek = (PrimaryIndexSeek)operation;
            byte[] seekValue = BLinkKeyToPageIndex.computeKeyValue(seek.value, context, tableContext);
            if (seekValue == null) {
                return Stream.empty();
            }
            Bytes key = Bytes.from_array((byte[])seekValue);
            Long pageId = (Long)this.getTree().search((Comparable)key);
            if (pageId == null) {
                return Stream.empty();
            }
            return Stream.of(new AbstractMap.SimpleImmutableEntry<Bytes, Long>(key, pageId));
        }
        if (operation instanceof PrimaryIndexPrefixScan) {
            PrimaryIndexPrefixScan scan = (PrimaryIndexPrefixScan)operation;
            byte[] refvalue = BLinkKeyToPageIndex.computeKeyValue(scan.value, context, tableContext);
            if (refvalue == null) {
                return Stream.empty();
            }
            Bytes firstKey = Bytes.from_array((byte[])refvalue);
            Bytes lastKey = firstKey.next();
            return this.getTree().scan((Comparable)firstKey, (Comparable)lastKey);
        }
        if (index != null) {
            return index.recordSetScanner(operation, context, tableContext, this);
        }
        if (operation == null) {
            Stream baseStream = this.getTree().scan(null, null);
            return baseStream;
        }
        if (operation instanceof PrimaryIndexRangeScan) {
            PrimaryIndexRangeScan sis = (PrimaryIndexRangeScan)operation;
            SQLRecordKeyFunction minKey = sis.minValue;
            Bytes refminvalue = minKey != null ? Bytes.from_array((byte[])minKey.computeNewValue(null, context, tableContext)) : null;
            SQLRecordKeyFunction maxKey = sis.maxValue;
            Bytes refmaxvalue = maxKey != null ? Bytes.from_array((byte[])maxKey.computeNewValue(null, context, tableContext)) : null;
            return this.getTree().scan((Comparable)refminvalue, (Comparable)refmaxvalue, refmaxvalue != null);
        }
        throw new DataStorageManagerException("operation " + operation + " not implemented on " + this.getClass());
    }

    private static byte[] computeKeyValue(RecordFunction keyFun, StatementEvaluationContext context, TableContext tableContext) throws StatementExecutionException {
        try {
            return keyFun.computeNewValue(null, context, tableContext);
        }
        catch (InvalidNullValueForKeyException invalidKeyValueException) {
            return null;
        }
    }

    @Override
    public void close() throws DataStorageManagerException {
        if (this.closed.compareAndSet(false, true)) {
            BLink<Bytes, Long> tree = this.tree;
            this.tree = null;
            if (tree != null) {
                tree.close();
            }
        } else {
            throw new DataStorageManagerException("Index " + this.indexName + " already closed");
        }
    }

    @Override
    public void truncate() {
        this.getTree().truncate();
    }

    @Override
    public void dropData() {
        this.truncate();
        this.dataStorageManager.dropIndex(this.tableSpace, this.indexName);
    }

    @Override
    public long getUsedMemory() {
        return this.getTree().getUsedMemory();
    }

    @Override
    public boolean requireLoadAtStartup() {
        return false;
    }

    @Override
    public void init() throws DataStorageManagerException {
        this.dataStorageManager.initIndex(this.tableSpace, this.indexName);
    }

    @Override
    public void start(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        LOGGER.log(Level.INFO, " start index {0}", new Object[]{this.indexName});
        long pageSize = this.memoryManager.getMaxLogicalPageSize();
        if (LogSequenceNumber.START_OF_TIME.equals(sequenceNumber)) {
            this.tree = new BLink(pageSize, SizeEvaluatorImpl.INSTANCE, this.memoryManager.getPKPageReplacementPolicy(), this.indexDataStorage);
            LOGGER.log(Level.INFO, "loaded empty index {0}", new Object[]{this.indexName});
        } else {
            IndexStatus status = this.dataStorageManager.getIndexStatus(this.tableSpace, this.indexName, sequenceNumber);
            try {
                BLinkMetadata<Bytes> metadata = MetadataSerializer.INSTANCE.read(status.indexData);
                this.tree = new BLink(pageSize, SizeEvaluatorImpl.INSTANCE, this.memoryManager.getPKPageReplacementPolicy(), this.indexDataStorage, metadata);
            }
            catch (IOException e) {
                throw new DataStorageManagerException(e);
            }
            this.newPageId.set(status.newPageId);
            LOGGER.log(Level.INFO, "loaded index {0}: {1} keys", new Object[]{this.indexName, this.tree.size()});
        }
    }

    @Override
    public List<PostCheckpointAction> checkpoint(LogSequenceNumber sequenceNumber, boolean pin) throws DataStorageManagerException {
        try {
            BLink<Bytes, Long> tree = this.tree;
            if (tree == null) {
                return Collections.emptyList();
            }
            BLinkMetadata metadata = this.getTree().checkpoint();
            byte[] metaPage = MetadataSerializer.INSTANCE.write((BLinkMetadata<Bytes>)metadata);
            HashSet<Long> activePages = new HashSet<Long>();
            metadata.nodes.forEach(node -> activePages.add(node.storeId));
            IndexStatus indexStatus = new IndexStatus(this.indexName, sequenceNumber, this.newPageId.get(), activePages, metaPage);
            ArrayList<PostCheckpointAction> result = new ArrayList<PostCheckpointAction>();
            result.addAll(this.dataStorageManager.indexCheckpoint(this.tableSpace, this.indexName, indexStatus, pin));
            LOGGER.log(Level.INFO, "checkpoint index {0} finished: logpos {1}, {2} pages", new Object[]{this.indexName, sequenceNumber, Integer.toString(metadata.nodes.size())});
            LOGGER.log(Level.FINE, "checkpoint index {0} finished: logpos {1}, pages {2}", new Object[]{this.indexName, sequenceNumber, ((Object)activePages).toString()});
            return result;
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public void unpinCheckpoint(LogSequenceNumber sequenceNumber) throws DataStorageManagerException {
        this.dataStorageManager.unPinIndexCheckpoint(this.tableSpace, this.indexName, sequenceNumber);
    }

    private BLink<Bytes, Long> getTree() {
        BLink<Bytes, Long> tree = this.tree;
        if (tree == null) {
            if (this.closed.get()) {
                throw new DataStorageManagerException("Index " + this.indexName + " already closed");
            }
            throw new DataStorageManagerException("Index " + this.indexName + " still not started");
        }
        return tree;
    }

    private final class BLinkIndexDataStorageImpl
    implements BLinkIndexDataStorage<Bytes, Long> {
        private BLinkIndexDataStorageImpl() {
        }

        public void loadNodePage(long pageId, Map<Bytes, Long> data) throws IOException {
            this.loadPage(pageId, (byte)1, data);
        }

        public void loadLeafPage(long pageId, Map<Bytes, Long> data) throws IOException {
            this.loadPage(pageId, (byte)2, data);
        }

        private void loadPage(long pageId, byte type, Map<Bytes, Long> map) throws IOException {
            BLinkKeyToPageIndex.this.dataStorageManager.readIndexPage(BLinkKeyToPageIndex.this.tableSpace, BLinkKeyToPageIndex.this.indexName, pageId, in -> {
                byte block;
                long version = in.readVLong();
                long flags = in.readVLong();
                if (version != 1L || flags != 0L) {
                    throw new IOException("Corrupted index page " + pageId);
                }
                byte rtype = in.readByte();
                if (rtype != type) {
                    throw new IOException("Wrong page type " + rtype + " expected " + type);
                }
                block4: while ((block = in.readByte()) != 0) {
                    switch (block) {
                        case 1: {
                            map.put(in.readBytes(), in.readVLong());
                            continue block4;
                        }
                        case 2: {
                            map.put(Bytes.POSITIVE_INFINITY, in.readVLong());
                            continue block4;
                        }
                    }
                    throw new IOException("Wrong node block type " + block);
                }
                return map;
            });
        }

        public long createNodePage(Map<Bytes, Long> data) throws IOException {
            return this.createPage(-1L, data, (byte)1);
        }

        public long createLeafPage(Map<Bytes, Long> data) throws IOException {
            return this.createPage(-1L, data, (byte)2);
        }

        public void overwriteNodePage(long pageId, Map<Bytes, Long> data) throws IOException {
            this.createPage(pageId, data, (byte)1);
        }

        public void overwriteLeafPage(long pageId, Map<Bytes, Long> data) throws IOException {
            this.createPage(pageId, data, (byte)2);
        }

        private long createPage(long pageId, Map<Bytes, Long> data, byte type) throws IOException {
            if (pageId == -1L) {
                pageId = BLinkKeyToPageIndex.this.newPageId.getAndIncrement();
            }
            BLinkKeyToPageIndex.this.dataStorageManager.writeIndexPage(BLinkKeyToPageIndex.this.tableSpace, BLinkKeyToPageIndex.this.indexName, pageId, out -> {
                out.writeVLong(1L);
                out.writeVLong(0L);
                out.writeByte((int)type);
                data.forEach((x, y) -> {
                    try {
                        if (x == Bytes.POSITIVE_INFINITY) {
                            out.writeByte(2);
                            out.writeVLong(y.longValue());
                        } else {
                            out.writeByte(1);
                            out.writeArray(x.to_array());
                            out.writeVLong(y.longValue());
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unexpected IOException during node page write preparation", e);
                    }
                });
                out.writeByte(0);
            });
            return pageId;
        }
    }

    private static class SizeEvaluatorImpl
    implements BLink.SizeEvaluator<Bytes, Long> {
        private static final long DATA_SIZE = 24L;
        public static final BLink.SizeEvaluator<Bytes, Long> INSTANCE = new SizeEvaluatorImpl();

        private SizeEvaluatorImpl() {
        }

        public long evaluateKey(Bytes key) {
            return key.getEstimatedSize();
        }

        public boolean isValueSizeConstant() {
            return true;
        }

        public long constantValueSize() throws UnsupportedOperationException {
            return 24L;
        }

        public long evaluateValue(Long value) {
            return 24L;
        }

        public long evaluateAll(Bytes key, Long value) {
            return key.getEstimatedSize() + 24L;
        }

        public Bytes getPosiviveInfinityKey() {
            return Bytes.POSITIVE_INFINITY;
        }
    }

    public static final class MetadataSerializer {
        public static final MetadataSerializer INSTANCE = new MetadataSerializer();
        private static final long VERSION_0 = 0L;
        private static final long VERSION_1 = 1L;
        private static final long VERSION_2 = 2L;
        public static final long CURRENT_VERSION = 2L;
        private static final long NO_FLAGS = 0L;

        public byte[] write(BLinkMetadata<Bytes> metadata) throws IOException {
            VisibleByteArrayOutputStream bos = new VisibleByteArrayOutputStream();
            try (ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)bos);){
                edos.writeVLong(2L);
                edos.writeVLong(0L);
                edos.writeByte(0);
                edos.writeVLong(metadata.nextID);
                edos.writeVLong(metadata.fast);
                edos.writeVInt(metadata.fastheight);
                edos.writeVLong(metadata.top);
                edos.writeVInt(metadata.topheight);
                edos.writeVLong(metadata.first);
                edos.writeVLong(metadata.values);
                for (BLinkMetadata.BLinkNodeMetadata node : metadata.nodes) {
                    edos.writeVInt(1);
                    edos.writeBoolean(node.leaf);
                    edos.writeVLong(node.id);
                    edos.writeVLong(node.storeId);
                    edos.writeVInt(node.keys);
                    edos.writeVLong(node.bytes);
                    edos.writeZLong(node.outlink);
                    edos.writeZLong(node.rightlink);
                    boolean hasInf = node.rightsep == Bytes.POSITIVE_INFINITY;
                    edos.writeBoolean(hasInf);
                    if (hasInf) continue;
                    edos.writeArray(((Bytes)node.rightsep).to_array());
                }
                edos.writeVInt(0);
            }
            return bos.toByteArray();
        }

        @SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="flags still not used but it must be forcefully read")
        public BLinkMetadata<Bytes> read(byte[] data) throws IOException {
            try (ByteArrayCursor edis = ByteArrayCursor.wrap((byte[])data);){
                int block;
                long version = edis.readVLong();
                boolean recalculateSize = version == 0L;
                long flags = version > 0L ? edis.readVLong() : 0L;
                byte rtype = edis.readByte();
                if (rtype != 0) {
                    throw new IOException("Wrong page type " + rtype + " expected " + 0);
                }
                long nextID = edis.readVLong();
                long fast = edis.readVLong();
                int fastheight = edis.readVInt();
                long top = edis.readVLong();
                int topheight = edis.readVInt();
                long first = edis.readVLong();
                long values = edis.readVLong();
                LinkedList<BLinkMetadata.BLinkNodeMetadata<Bytes>> nodes = new LinkedList<BLinkMetadata.BLinkNodeMetadata<Bytes>>();
                while ((block = edis.readVInt()) != 0) {
                    BLinkMetadata.BLinkNodeMetadata<Bytes> node;
                    if (block != 1) {
                        throw new IOException("Wrong block type " + block);
                    }
                    if (version == 2L) {
                        node = this.readV2(edis, recalculateSize);
                    } else if (version == 1L) {
                        node = this.readV1(edis, recalculateSize);
                    } else if (version == 0L) {
                        node = this.readV0(edis, recalculateSize);
                    } else {
                        throw new IllegalArgumentException("Unknown BLink node metadata version " + version);
                    }
                    nodes.add(node);
                }
                BLinkMetadata bLinkMetadata = new BLinkMetadata(nextID, fast, fastheight, top, topheight, first, values, nodes);
                return bLinkMetadata;
            }
        }

        public BLinkMetadata.BLinkNodeMetadata<Bytes> readV2(ByteArrayCursor cursor, boolean recalculateSize) throws IOException {
            boolean leaf = cursor.readBoolean();
            long id = cursor.readVLong();
            long storeId = cursor.readVLong();
            int keys = cursor.readVInt();
            long bytes = cursor.readVLong();
            if (recalculateSize) {
                bytes = 0L;
            }
            long outlink = cursor.readZLong();
            long rightlink = cursor.readZLong();
            boolean hasInf = cursor.readBoolean();
            Bytes rightsep = hasInf ? Bytes.POSITIVE_INFINITY : cursor.readBytes();
            return new BLinkMetadata.BLinkNodeMetadata(leaf, id, storeId, keys, bytes, outlink, rightlink, (Object)rightsep);
        }

        public BLinkMetadata.BLinkNodeMetadata<Bytes> readV1(ByteArrayCursor cursor, boolean recalculateSize) throws IOException {
            return this.readV0(cursor, recalculateSize);
        }

        public BLinkMetadata.BLinkNodeMetadata<Bytes> readV0(ByteArrayCursor cursor, boolean recalculateSize) throws IOException {
            boolean leaf = cursor.readBoolean();
            long id = cursor.readVLong();
            long storeId = cursor.readVLong();
            cursor.readBoolean();
            int keys = cursor.readVInt();
            long bytes = cursor.readVLong();
            if (recalculateSize) {
                bytes = 0L;
            }
            long outlink = cursor.readZLong();
            long rightlink = cursor.readZLong();
            boolean hasInf = cursor.readBoolean();
            Bytes rightsep = hasInf ? Bytes.POSITIVE_INFINITY : cursor.readBytes();
            return new BLinkMetadata.BLinkNodeMetadata(leaf, id, storeId, keys, bytes, outlink, rightlink, (Object)rightsep);
        }
    }
}

