/*
 * Decompiled with CFR 0.152.
 */
package herddb.file;

import herddb.file.FileCommitLog;
import herddb.log.CommitLogManager;
import herddb.log.LogNotAvailableException;
import herddb.server.ServerConfiguration;
import herddb.utils.OpenFileUtils;
import herddb.utils.SystemProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

public class FileCommitLogManager
extends CommitLogManager {
    private static final int MAXCONCURRENTFSYNCS = SystemProperties.getIntSystemProperty((String)"herddb.file.maxconcurrentfsyncs", (int)1);
    private final int deferredSyncPeriod;
    private static final Logger LOG = Logger.getLogger(FileCommitLogManager.class.getName());
    private final Path baseDirectory;
    private final long maxLogFileSize;
    private final int maxUnsynchedBatchSize;
    private final int maxUnsynchedBatchBytes;
    private final int maxSyncTime;
    private final boolean requireSync;
    private final boolean enableO_DIRECT;
    private final StatsLogger statsLogger;
    private ScheduledExecutorService fsyncThreadPool;
    private final List<FileCommitLog> activeLogs = new CopyOnWriteArrayList<FileCommitLog>();

    public FileCommitLogManager(Path baseDirectory) {
        this(baseDirectory, 0x4000000L, 10000, 524288, 1, ServerConfiguration.PROPERTY_REQUIRE_FSYNC_DEFAULT, ServerConfiguration.PROPERTY_TXLOG_USE_ODIRECT_DEFAULT, 0, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public FileCommitLogManager(Path baseDirectory, long maxLogFileSize, int maxUnsynchedBatchSize, int maxUnsynchedBatchBytes, int maxSyncTime, boolean requireSync, boolean enableO_DIRECT, int deferredSyncPeriod, StatsLogger statsLogger) {
        this.baseDirectory = baseDirectory;
        this.maxLogFileSize = maxLogFileSize;
        this.statsLogger = statsLogger;
        this.deferredSyncPeriod = deferredSyncPeriod;
        this.maxUnsynchedBatchSize = maxUnsynchedBatchSize;
        this.maxUnsynchedBatchBytes = maxUnsynchedBatchBytes;
        this.maxSyncTime = maxSyncTime;
        this.requireSync = requireSync;
        this.enableO_DIRECT = enableO_DIRECT && OpenFileUtils.isO_DIRECT_Supported();
        LOG.log(Level.INFO, "Txlog settings: fsync: " + requireSync + ", O_DIRECT: " + enableO_DIRECT + ", deferredSyncPeriod:" + deferredSyncPeriod);
    }

    @Override
    public FileCommitLog createCommitLog(String tableSpace, String tablespaceName, String localNodeId) {
        try {
            if (this.fsyncThreadPool == null) {
                throw new IllegalStateException("FileCommitLogManager not started");
            }
            Path folder = this.baseDirectory.resolve(tableSpace + ".txlog");
            Files.createDirectories(folder, new FileAttribute[0]);
            FileCommitLog res = new FileCommitLog(folder, tablespaceName, this.maxLogFileSize, this.fsyncThreadPool, this.statsLogger.scope(tablespaceName), this.activeLogs::remove, this.maxUnsynchedBatchSize, this.maxUnsynchedBatchBytes, this.maxSyncTime, this.requireSync, this.enableO_DIRECT);
            this.activeLogs.add(res);
            return res;
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    @Override
    public void close() {
        ScheduledExecutorService _fsyncThreadPool = this.fsyncThreadPool;
        this.fsyncThreadPool = null;
        if (_fsyncThreadPool != null) {
            try {
                _fsyncThreadPool.shutdown();
                _fsyncThreadPool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.INFO, "Interrupted while waiting for fsync threadpool to exit");
            }
        }
    }

    @Override
    public void start() throws LogNotAvailableException {
        this.fsyncThreadPool = Executors.newScheduledThreadPool(MAXCONCURRENTFSYNCS);
        if (this.deferredSyncPeriod > 0) {
            LOG.log(Level.INFO, "Starting background fsync thread, every {0} s", this.deferredSyncPeriod);
            this.fsyncThreadPool.scheduleWithFixedDelay(new DummyFsync(), this.deferredSyncPeriod, this.deferredSyncPeriod, TimeUnit.SECONDS);
        }
    }

    private class DummyFsync
    implements Runnable {
        private DummyFsync() {
        }

        @Override
        public void run() {
            for (FileCommitLog log : FileCommitLogManager.this.activeLogs) {
                if (log.isClosed() || log.isFailed()) continue;
                log.backgroundSync();
            }
        }
    }
}

