/*
 * Decompiled with CFR 0.152.
 */
package herddb.core.system;

import herddb.codec.RecordSerializer;
import herddb.core.TableSpaceManager;
import herddb.core.system.AbstractSystemTableManager;
import herddb.model.Record;
import herddb.model.Table;
import java.util.List;
import java.util.stream.Collectors;

public class SystablesTableManager
extends AbstractSystemTableManager {
    private static final Table TABLE = Table.builder().name("systables").column("tablespace", 0).column("table_name", 0).column("table_uuid", 0).column("systemtable", 0).primaryKey("tablespace", false).primaryKey("table_name", false).build();

    public SystablesTableManager(TableSpaceManager parent) {
        super(parent, TABLE);
    }

    @Override
    protected Iterable<Record> buildVirtualRecordList() {
        List<Table> tables = this.tableSpaceManager.getAllCommittedTables();
        return tables.stream().map(r -> RecordSerializer.makeRecord(this.table, "tablespace", r.tablespace, "table_name", r.name, "table_uuid", r.uuid, "systemtable", r.name.startsWith("sys") ? "true" : "false")).collect(Collectors.toList());
    }
}

