/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.backup.DumpedLogEntry;
import herddb.client.ClientConfiguration;
import herddb.client.ClientSideMetadataProvider;
import herddb.client.ClientSideMetadataProviderException;
import herddb.client.HDBClient;
import herddb.client.HDBConnection;
import herddb.client.HDBException;
import herddb.core.AbstractIndexManager;
import herddb.core.AbstractTableManager;
import herddb.core.DBManager;
import herddb.core.HerdDBInternalException;
import herddb.core.PostCheckpointAction;
import herddb.core.ReplicaFullTableDataDumpReceiver;
import herddb.core.SingleTableDumper;
import herddb.core.TableManager;
import herddb.core.stats.TableManagerStats;
import herddb.core.stats.TableSpaceManagerStats;
import herddb.core.system.SysclientsTableManager;
import herddb.core.system.SyscolumnsTableManager;
import herddb.core.system.SysconfigTableManager;
import herddb.core.system.SysindexcolumnsTableManager;
import herddb.core.system.SysindexesTableManager;
import herddb.core.system.SyslogstatusManager;
import herddb.core.system.SysnodesTableManager;
import herddb.core.system.SysstatementsTableManager;
import herddb.core.system.SystablesTableManager;
import herddb.core.system.SystablespacereplicastateTableManager;
import herddb.core.system.SystablespacesTableManager;
import herddb.core.system.SystablestatsTableManager;
import herddb.core.system.SystransactionsTableManager;
import herddb.index.MemoryHashIndexManager;
import herddb.index.brin.BRINIndexManager;
import herddb.jmx.JMXUtils;
import herddb.jmx.TableManagerStatsMXBean;
import herddb.log.CommitLog;
import herddb.log.CommitLogListener;
import herddb.log.CommitLogResult;
import herddb.log.FullRecoveryNeededException;
import herddb.log.LogEntry;
import herddb.log.LogEntryFactory;
import herddb.log.LogNotAvailableException;
import herddb.log.LogSequenceNumber;
import herddb.metadata.MetadataStorageManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.DDLException;
import herddb.model.DDLStatementExecutionResult;
import herddb.model.DataScanner;
import herddb.model.Index;
import herddb.model.IndexAlreadyExistsException;
import herddb.model.IndexDoesNotExistException;
import herddb.model.NodeMetadata;
import herddb.model.Statement;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.TableAlreadyExistsException;
import herddb.model.TableAwareStatement;
import herddb.model.TableDoesNotExistException;
import herddb.model.TableSpace;
import herddb.model.Transaction;
import herddb.model.TransactionContext;
import herddb.model.TransactionResult;
import herddb.model.commands.AlterTableStatement;
import herddb.model.commands.BeginTransactionStatement;
import herddb.model.commands.CommitTransactionStatement;
import herddb.model.commands.CreateIndexStatement;
import herddb.model.commands.CreateTableStatement;
import herddb.model.commands.DropIndexStatement;
import herddb.model.commands.DropTableStatement;
import herddb.model.commands.RollbackTransactionStatement;
import herddb.model.commands.SQLPlannedOperationStatement;
import herddb.model.commands.ScanStatement;
import herddb.network.Channel;
import herddb.network.SendResultCallback;
import herddb.network.ServerHostData;
import herddb.proto.Pdu;
import herddb.proto.PduCodec;
import herddb.storage.DataStorageManager;
import herddb.storage.DataStorageManagerException;
import herddb.utils.Bytes;
import herddb.utils.KeyValue;
import herddb.utils.SystemProperties;
import java.io.EOFException;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

public class TableSpaceManager {
    private static final boolean ENABLE_PENDING_TRANSACTION_CHECK = SystemProperties.getBooleanSystemProperty((String)"herddb.tablespace.checkpendingtransactions", (boolean)true);
    private static final Logger LOGGER = Logger.getLogger(TableSpaceManager.class.getName());
    final StatsLogger tablespaceStasLogger;
    final OpStatsLogger checkpointTimeStats;
    private final MetadataStorageManager metadataStorageManager;
    private final DataStorageManager dataStorageManager;
    private final CommitLog log;
    private final String tableSpaceName;
    private final String tableSpaceUUID;
    private final String nodeId;
    private final ConcurrentSkipListSet<String> tablesNeedingCheckPoint = new ConcurrentSkipListSet();
    private final ConcurrentHashMap<String, AbstractTableManager> tables = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AbstractIndexManager> indexes = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Map<String, AbstractIndexManager>> indexesByTable = new ConcurrentHashMap();
    private final StampedLock generalLock = new StampedLock();
    private final AtomicLong newTransactionId = new AtomicLong();
    private final DBManager dbmanager;
    private volatile FollowerThread followerThread;
    private final ExecutorService callbacksExecutor;
    private final boolean virtual;
    private volatile boolean recoveryInProgress;
    private volatile boolean leader;
    private volatile boolean closed;
    private volatile boolean failed;
    private LogSequenceNumber actualLogSequenceNumber;
    private Runnable afterTableCheckPointAction;
    private final ConcurrentHashMap<Long, Transaction> transactions = new ConcurrentHashMap();
    private final TableSpaceManagerStats stats = new TableSpaceManagerStats(){

        @Override
        public int getLoadedpages() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToInt(TableManagerStatsMXBean::getLoadedpages).sum();
        }

        @Override
        public long getLoadedPagesCount() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToLong(TableManagerStatsMXBean::getLoadedPagesCount).sum();
        }

        @Override
        public long getUnloadedPagesCount() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToLong(TableManagerStatsMXBean::getUnloadedPagesCount).sum();
        }

        @Override
        public long getTablesize() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToLong(TableManagerStatsMXBean::getTablesize).sum();
        }

        @Override
        public int getDirtypages() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToInt(TableManagerStatsMXBean::getDirtypages).sum();
        }

        @Override
        public int getDirtyrecords() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToInt(TableManagerStatsMXBean::getDirtyrecords).sum();
        }

        @Override
        public long getDirtyUsedMemory() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToLong(TableManagerStatsMXBean::getDirtyUsedMemory).sum();
        }

        @Override
        public long getMaxLogicalPageSize() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToLong(TableManagerStatsMXBean::getMaxLogicalPageSize).findFirst().orElse(0L);
        }

        @Override
        public long getBuffersUsedMemory() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToLong(TableManagerStatsMXBean::getBuffersUsedMemory).sum();
        }

        @Override
        public long getKeysUsedMemory() {
            return TableSpaceManager.this.tables.values().stream().map(AbstractTableManager::getStats).mapToLong(TableManagerStatsMXBean::getKeysUsedMemory).sum();
        }
    };

    public Runnable getAfterTableCheckPointAction() {
        return this.afterTableCheckPointAction;
    }

    public void setAfterTableCheckPointAction(Runnable afterTableCheckPointAction) {
        this.afterTableCheckPointAction = afterTableCheckPointAction;
    }

    public String getTableSpaceName() {
        return this.tableSpaceName;
    }

    public String getTableSpaceUUID() {
        return this.tableSpaceUUID;
    }

    public TableSpaceManager(String nodeId, String tableSpaceName, String tableSpaceUUID, MetadataStorageManager metadataStorageManager, DataStorageManager dataStorageManager, CommitLog log, DBManager manager, boolean virtual) {
        this.nodeId = nodeId;
        this.dbmanager = manager;
        this.callbacksExecutor = this.dbmanager.getCallbacksExecutor();
        this.metadataStorageManager = metadataStorageManager;
        this.dataStorageManager = dataStorageManager;
        this.log = log;
        this.tableSpaceName = tableSpaceName;
        this.tableSpaceUUID = tableSpaceUUID;
        this.virtual = virtual;
        this.tablespaceStasLogger = this.dbmanager.getStatsLogger().scope(this.tableSpaceName);
        this.checkpointTimeStats = this.tablespaceStasLogger.getOpStatsLogger("checkpointTime");
    }

    private void bootSystemTables() {
        if (this.virtual) {
            this.registerSystemTableManager(new SysconfigTableManager(this));
            this.registerSystemTableManager(new SysclientsTableManager(this));
        } else {
            this.registerSystemTableManager(new SystablesTableManager(this));
            this.registerSystemTableManager(new SystablestatsTableManager(this));
            this.registerSystemTableManager(new SysindexesTableManager(this));
            this.registerSystemTableManager(new SysindexcolumnsTableManager(this));
            this.registerSystemTableManager(new SyscolumnsTableManager(this));
            this.registerSystemTableManager(new SystransactionsTableManager(this));
            this.registerSystemTableManager(new SyslogstatusManager(this));
        }
        this.registerSystemTableManager(new SystablespacesTableManager(this));
        this.registerSystemTableManager(new SystablespacereplicastateTableManager(this));
        this.registerSystemTableManager(new SysnodesTableManager(this));
        this.registerSystemTableManager(new SysstatementsTableManager(this));
    }

    private void registerSystemTableManager(AbstractTableManager tableManager) {
        this.tables.put(tableManager.getTable().name, tableManager);
    }

    void start() throws DataStorageManagerException, LogNotAvailableException, MetadataStorageManagerException, DDLException {
        TableSpace tableSpaceInfo = this.metadataStorageManager.describeTableSpace(this.tableSpaceName);
        this.bootSystemTables();
        if (this.virtual) {
            this.startAsLeader();
        } else {
            this.recover(tableSpaceInfo);
            LOGGER.log(Level.INFO, " after recovery of tableSpace " + this.tableSpaceName + ", actualLogSequenceNumber:" + this.actualLogSequenceNumber);
            tableSpaceInfo = this.metadataStorageManager.describeTableSpace(this.tableSpaceName);
            if (tableSpaceInfo.leaderId.equals(this.nodeId)) {
                this.startAsLeader();
            } else {
                this.startAsFollower();
            }
        }
    }

    void recover(TableSpace tableSpaceInfo) throws DataStorageManagerException, LogNotAvailableException, MetadataStorageManagerException {
        LogSequenceNumber logSequenceNumber;
        if (this.recoveryInProgress) {
            throw new HerdDBInternalException("Cannot run recovery twice");
        }
        this.recoveryInProgress = true;
        this.actualLogSequenceNumber = logSequenceNumber = this.dataStorageManager.getLastcheckpointSequenceNumber(this.tableSpaceUUID);
        LOGGER.log(Level.INFO, "{0} recover {1}, logSequenceNumber from DataStorage: {2}", new Object[]{this.nodeId, this.tableSpaceName, logSequenceNumber});
        List<Table> tablesAtBoot = this.dataStorageManager.loadTables(logSequenceNumber, this.tableSpaceUUID);
        List<Index> indexesAtBoot = this.dataStorageManager.loadIndexes(logSequenceNumber, this.tableSpaceUUID);
        String tableNames = tablesAtBoot.stream().map(t -> t.name).collect(Collectors.joining(","));
        String indexNames = indexesAtBoot.stream().map(t -> t.name + " on table " + t.table).collect(Collectors.joining(","));
        LOGGER.log(Level.INFO, "{0} {1} tablesAtBoot {2}, indexesAtBoot {3}", new Object[]{this.nodeId, this.tableSpaceName, tableNames, indexNames});
        for (Table table : tablesAtBoot) {
            TableManager tableManager = this.bootTable(table, 0L, null);
            for (Index index : indexesAtBoot) {
                if (!index.table.equals(table.name)) continue;
                this.bootIndex(index, tableManager, 0L, false, false);
            }
        }
        this.dataStorageManager.loadTransactions(logSequenceNumber, this.tableSpaceUUID, t -> {
            this.transactions.put(t.transactionId, (Transaction)t);
            LOGGER.log(Level.FINER, "{0} {1} tx {2} at boot lsn {3}", new Object[]{this.nodeId, this.tableSpaceName, t.transactionId, t.lastSequenceNumber});
            try {
                if (t.newTables != null) {
                    for (Table table : t.newTables.values()) {
                        if (this.tables.containsKey(table.name)) continue;
                        this.bootTable(table, t.transactionId, null);
                    }
                }
                if (t.newIndexes != null) {
                    for (Index index : t.newIndexes.values()) {
                        if (this.indexes.containsKey(index.name)) continue;
                        AbstractTableManager tableManager = this.tables.get(index.table);
                        this.bootIndex(index, tableManager, t.transactionId, false, false);
                    }
                }
            }
            catch (Exception err) {
                LOGGER.log(Level.SEVERE, "error while booting tmp tables " + err, err);
                throw new RuntimeException(err);
            }
        });
        if (LogSequenceNumber.START_OF_TIME.equals(logSequenceNumber) && this.dbmanager.getServerConfiguration().getBoolean("server.boot.force.download.snapshot", false)) {
            LOGGER.log(Level.SEVERE, this.nodeId + " full recovery of data is forced (" + "server.boot.force.download.snapshot" + "=true) for tableSpace " + this.tableSpaceName);
            this.downloadTableSpaceData();
            this.log.recovery(this.actualLogSequenceNumber, new ApplyEntryOnRecovery(), false);
        } else {
            try {
                this.log.recovery(logSequenceNumber, new ApplyEntryOnRecovery(), false);
            }
            catch (FullRecoveryNeededException fullRecoveryNeeded) {
                LOGGER.log(Level.SEVERE, this.nodeId + " full recovery of data is needed for tableSpace " + this.tableSpaceName, (Throwable)((Object)fullRecoveryNeeded));
                this.downloadTableSpaceData();
                this.log.recovery(this.actualLogSequenceNumber, new ApplyEntryOnRecovery(), false);
            }
        }
        this.recoveryInProgress = false;
        LOGGER.log(Level.INFO, "Recovery finished for {0}", this.tableSpaceName);
        this.checkpoint(false, false, false);
    }

    void recoverForLeadership() throws DataStorageManagerException, LogNotAvailableException {
        if (this.recoveryInProgress) {
            throw new HerdDBInternalException("Cannot run recovery twice");
        }
        this.recoveryInProgress = true;
        this.actualLogSequenceNumber = this.log.getLastSequenceNumber();
        LOGGER.log(Level.INFO, "recovering tablespace {0} log from sequence number {1}, with fencing", new Object[]{this.tableSpaceName, this.actualLogSequenceNumber});
        this.log.recovery(this.actualLogSequenceNumber, new ApplyEntryOnRecovery(), true);
        LOGGER.log(Level.INFO, "Recovery (with fencing) finished for {0}", this.tableSpaceName);
        this.recoveryInProgress = false;
    }

    void apply(CommitLogResult position, LogEntry entry, boolean recovery) throws DataStorageManagerException, DDLException {
        if (!position.deferred || position.sync) {
            this.actualLogSequenceNumber = position.getLogSequenceNumber();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "apply {0} {1}", new Object[]{position.getLogSequenceNumber(), entry});
            }
        } else if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "apply {0} {1}", new Object[]{position, entry});
        }
        switch (entry.type) {
            case 13: {
                break;
            }
            case 5: {
                long id = entry.transactionId;
                Transaction transaction = new Transaction(id, this.tableSpaceName, position);
                this.transactions.put(id, transaction);
                break;
            }
            case 7: {
                long id = entry.transactionId;
                Transaction transaction = this.transactions.get(id);
                if (transaction == null) {
                    throw new DataStorageManagerException("invalid transaction id " + id + ", only " + this.transactions.keySet());
                }
                ArrayList<AbstractTableManager> managers = new ArrayList<AbstractTableManager>(this.tables.values());
                for (AbstractTableManager manager : managers) {
                    Table table = manager.getTable();
                    if (transaction.isNewTable(table.name)) {
                        LOGGER.log(Level.INFO, "rollback CREATE TABLE " + table.tablespace + "." + table.name);
                        manager.dropTableData();
                        manager.close();
                        this.tables.remove(manager.getTable().name);
                        continue;
                    }
                    manager.onTransactionRollback(transaction);
                }
                this.transactions.remove(transaction.transactionId);
                break;
            }
            case 6: {
                long id = entry.transactionId;
                Transaction transaction = this.transactions.get(id);
                if (transaction == null) {
                    throw new DataStorageManagerException("invalid transaction id " + id);
                }
                LogSequenceNumber commit = position.getLogSequenceNumber();
                transaction.sync(commit);
                ArrayList<AbstractTableManager> managers = new ArrayList<AbstractTableManager>(this.tables.values());
                for (AbstractTableManager manager : managers) {
                    manager.onTransactionCommit(transaction, recovery);
                }
                ArrayList<AbstractIndexManager> indexManagers = new ArrayList<AbstractIndexManager>(this.indexes.values());
                for (AbstractIndexManager indexManager : indexManagers) {
                    indexManager.onTransactionCommit(transaction, recovery);
                }
                if (transaction.droppedTables != null && !transaction.droppedTables.isEmpty() || transaction.droppedIndexes != null && !transaction.droppedIndexes.isEmpty()) {
                    if (transaction.droppedTables != null) {
                        for (String dropped : transaction.droppedTables) {
                            for (AbstractTableManager abstractTableManager : managers) {
                                if (!abstractTableManager.getTable().name.equals(dropped)) continue;
                                abstractTableManager.dropTableData();
                                abstractTableManager.close();
                                this.tables.remove(abstractTableManager.getTable().name);
                            }
                        }
                    }
                    if (transaction.droppedIndexes != null) {
                        for (String dropped : transaction.droppedIndexes) {
                            for (AbstractIndexManager abstractIndexManager : indexManagers) {
                                if (!abstractIndexManager.getIndex().name.equals(dropped)) continue;
                                abstractIndexManager.dropIndexData();
                                abstractIndexManager.close();
                                this.indexes.remove(abstractIndexManager.getIndex().name);
                                Map<String, AbstractIndexManager> indexesForTable = this.indexesByTable.get(abstractIndexManager.getIndex().table);
                                if (indexesForTable == null) continue;
                                indexesForTable.remove(abstractIndexManager.getIndex().name);
                            }
                        }
                    }
                }
                if (transaction.newTables != null && !transaction.newTables.isEmpty() || transaction.droppedTables != null && !transaction.droppedTables.isEmpty() || transaction.newIndexes != null && !transaction.newIndexes.isEmpty() || transaction.droppedIndexes != null && !transaction.droppedIndexes.isEmpty()) {
                    this.writeTablesOnDataStorageManager(position, false);
                    this.dbmanager.getPlanner().clearCache();
                }
                this.transactions.remove(transaction.transactionId);
                break;
            }
            case 1: {
                Table table = Table.deserialize(entry.value.to_array());
                if (entry.transactionId > 0L) {
                    long id = entry.transactionId;
                    Transaction transaction = this.transactions.get(id);
                    transaction.registerNewTable(table, position);
                }
                this.bootTable(table, entry.transactionId, null);
                if (entry.transactionId > 0L) break;
                this.writeTablesOnDataStorageManager(position, false);
                break;
            }
            case 10: {
                AbstractTableManager tableManager;
                Index index = Index.deserialize(entry.value.to_array());
                if (entry.transactionId > 0L) {
                    long id = entry.transactionId;
                    Transaction transaction = this.transactions.get(id);
                    transaction.registerNewIndex(index, position);
                }
                if ((tableManager = this.tables.get(index.table)) == null) {
                    throw new RuntimeException("table " + index.table + " does not exists");
                }
                this.bootIndex(index, tableManager, entry.transactionId, true, false);
                if (entry.transactionId > 0L) break;
                this.writeTablesOnDataStorageManager(position, false);
                break;
            }
            case 9: {
                String tableName = entry.tableName;
                if (entry.transactionId > 0L) {
                    long id = entry.transactionId;
                    Transaction transaction = this.transactions.get(id);
                    transaction.registerDropTable(tableName, position);
                } else {
                    AbstractTableManager manager = this.tables.get(tableName);
                    if (manager != null) {
                        manager.dropTableData();
                        manager.close();
                        this.tables.remove(manager.getTable().name);
                    }
                }
                if (entry.transactionId > 0L) break;
                this.writeTablesOnDataStorageManager(position, false);
                break;
            }
            case 11: {
                String indexName = entry.value.to_string();
                if (entry.transactionId > 0L) {
                    long id = entry.transactionId;
                    Transaction transaction = this.transactions.get(id);
                    transaction.registerDropIndex(indexName, position);
                } else {
                    AbstractIndexManager manager = this.indexes.get(indexName);
                    if (manager != null) {
                        manager.dropIndexData();
                        manager.close();
                        this.indexes.remove(manager.getIndexName());
                        Map<String, AbstractIndexManager> indexesForTable = this.indexesByTable.get(manager.getIndex().table);
                        if (indexesForTable != null) {
                            indexesForTable.remove(manager.getIndex().name);
                        }
                    }
                }
                if (entry.transactionId > 0L) break;
                this.writeTablesOnDataStorageManager(position, false);
                this.dbmanager.getPlanner().clearCache();
                break;
            }
            case 8: {
                Table table = Table.deserialize(entry.value.to_array());
                this.alterTable(table, null);
                this.writeTablesOnDataStorageManager(position, false);
                break;
            }
        }
        if (entry.tableName != null && entry.type != 1 && entry.type != 10 && entry.type != 8 && entry.type != 9) {
            AbstractTableManager tableManager = this.tables.get(entry.tableName);
            tableManager.apply(position, entry, recovery);
        }
    }

    private Collection<PostCheckpointAction> writeTablesOnDataStorageManager(CommitLogResult writeLog, boolean prepareActions) throws DataStorageManagerException, LogNotAvailableException {
        LogSequenceNumber logSequenceNumber = writeLog.getLogSequenceNumber();
        ArrayList<Table> tablelist = new ArrayList<Table>();
        ArrayList<Index> indexlist = new ArrayList<Index>();
        for (AbstractTableManager tableManager : this.tables.values()) {
            if (tableManager.isSystemTable()) continue;
            tablelist.add(tableManager.getTable());
        }
        for (AbstractIndexManager indexManager : this.indexes.values()) {
            indexlist.add(indexManager.getIndex());
        }
        return this.dataStorageManager.writeTables(this.tableSpaceUUID, logSequenceNumber, tablelist, indexlist, prepareActions);
    }

    public DataScanner scan(ScanStatement statement, StatementEvaluationContext context, TransactionContext transactionContext, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        boolean rollbackOnError = false;
        if (transactionContext.transactionId == -1L) {
            try {
                StatementExecutionResult newTransaction = (StatementExecutionResult)FutureUtils.result(this.beginTransactionAsync(context, true));
                transactionContext = new TransactionContext(newTransaction.transactionId);
                rollbackOnError = true;
            }
            catch (Exception err) {
                if (err.getCause() instanceof HerdDBInternalException) {
                    throw (HerdDBInternalException)err.getCause();
                }
                throw new StatementExecutionException(err.getCause());
            }
        }
        Transaction transaction = this.transactions.get(transactionContext.transactionId);
        if (transactionContext.transactionId > 0L && transaction == null) {
            throw new StatementExecutionException("transaction " + transactionContext.transactionId + " does not exist on tablespace " + this.tableSpaceName);
        }
        if (transaction != null && !transaction.tableSpace.equals(this.tableSpaceName)) {
            throw new StatementExecutionException("transaction " + transaction.transactionId + " is for tablespace " + transaction.tableSpace + ", not for " + this.tableSpaceName);
        }
        if (transaction != null) {
            transaction.touch();
        }
        try {
            String table = statement.getTable();
            AbstractTableManager tableManager = this.tables.get(table);
            if (tableManager == null) {
                throw new TableDoesNotExistException("no table " + table + " in tablespace " + this.tableSpaceName);
            }
            if (tableManager.getCreatedInTransaction() > 0L && (transaction == null || transaction.transactionId != tableManager.getCreatedInTransaction())) {
                throw new TableDoesNotExistException("no table " + table + " in tablespace " + this.tableSpaceName + ". created temporary in transaction " + tableManager.getCreatedInTransaction());
            }
            return tableManager.scan(statement, context, transaction, lockRequired, forWrite);
        }
        catch (StatementExecutionException error) {
            if (rollbackOnError) {
                LOGGER.log(Level.FINE, this.tableSpaceName + " forcing rollback of implicit tx " + transactionContext.transactionId, (Throwable)((Object)error));
                try {
                    this.rollbackTransaction(new RollbackTransactionStatement(this.tableSpaceName, transactionContext.transactionId), context).get();
                }
                catch (ExecutionException err) {
                    throw new StatementExecutionException(err.getCause());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    error.addSuppressed(ex);
                }
            }
            throw error;
        }
    }

    private void downloadTableSpaceData() throws MetadataStorageManagerException, DataStorageManagerException, LogNotAvailableException {
        TableSpace tableSpaceData = this.metadataStorageManager.describeTableSpace(this.tableSpaceName);
        final String leaderId = tableSpaceData.leaderId;
        if (this.nodeId.equals(leaderId)) {
            throw new DataStorageManagerException("cannot download data of tableSpace " + this.tableSpaceName + " from myself");
        }
        Optional<NodeMetadata> leaderAddress = this.metadataStorageManager.listNodes().stream().filter(n -> n.nodeId.equals(leaderId)).findAny();
        if (!leaderAddress.isPresent()) {
            throw new DataStorageManagerException("cannot download data of tableSpace " + this.tableSpaceName + " from leader " + leaderId + ", no metadata found");
        }
        this.actualLogSequenceNumber = LogSequenceNumber.START_OF_TIME;
        this.newTransactionId.set(0L);
        LOGGER.log(Level.INFO, "tablespace " + this.tableSpaceName + " at downloadTableSpaceData " + this.tables + ", " + this.indexes + ", " + this.transactions);
        for (AbstractTableManager abstractTableManager : this.tables.values()) {
            if (!abstractTableManager.isSystemTable()) {
                abstractTableManager.dropTableData();
            }
            abstractTableManager.close();
        }
        this.tables.clear();
        for (AbstractIndexManager abstractIndexManager : this.indexes.values()) {
            abstractIndexManager.dropIndexData();
            abstractIndexManager.close();
        }
        this.indexes.clear();
        this.transactions.clear();
        this.dataStorageManager.eraseTablespaceData(this.tableSpaceUUID);
        final NodeMetadata nodeData = leaderAddress.get();
        ClientConfiguration clientConfiguration = new ClientConfiguration(this.dbmanager.getTmpDirectory());
        clientConfiguration.set("user", this.dbmanager.getServerToServerUsername());
        clientConfiguration.set("password", this.dbmanager.getServerToServerPassword());
        try (HDBClient client = new HDBClient(clientConfiguration);){
            client.setClientSideMetadataProvider(new ClientSideMetadataProvider(){

                @Override
                public String getTableSpaceLeader(String tableSpace) throws ClientSideMetadataProviderException {
                    return leaderId;
                }

                @Override
                public ServerHostData getServerHostData(String nodeId) throws ClientSideMetadataProviderException {
                    return new ServerHostData(nodeData.host, nodeData.port, "?", nodeData.ssl, Collections.emptyMap());
                }
            });
            try (HDBConnection con = client.openConnection();){
                ReplicaFullTableDataDumpReceiver receiver = new ReplicaFullTableDataDumpReceiver(this);
                int fetchSize = 10000;
                con.dumpTableSpace(this.tableSpaceName, receiver, fetchSize, false);
                receiver.getLatch().get(1L, TimeUnit.HOURS);
                this.actualLogSequenceNumber = receiver.logSequenceNumber;
                LOGGER.log(Level.INFO, this.tableSpaceName + " After download local actualLogSequenceNumber is " + this.actualLogSequenceNumber);
            }
            catch (ClientSideMetadataProviderException | HDBException | InterruptedException | ExecutionException | TimeoutException internalError) {
                LOGGER.log(Level.SEVERE, this.tableSpaceName + " error downloading snapshot", internalError);
                throw new DataStorageManagerException(internalError);
            }
        }
    }

    public MetadataStorageManager getMetadataStorageManager() {
        return this.metadataStorageManager;
    }

    public List<Table> getAllCommittedTables() {
        return this.tables.values().stream().filter(s -> s.getCreatedInTransaction() == 0L).map(AbstractTableManager::getTable).collect(Collectors.toList());
    }

    public List<Table> getAllTablesForPlanner() {
        return this.tables.values().stream().map(AbstractTableManager::getTable).collect(Collectors.toList());
    }

    private void releaseWriteLock(long lockStamp, Object description) {
        this.generalLock.unlockWrite(lockStamp);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} ts {2} relwlock {1}", new Object[]{this.tableSpaceName, description, lockStamp});
        }
    }

    public Map<String, AbstractIndexManager> getIndexesOnTable(String name) {
        Map<String, AbstractIndexManager> result = this.indexesByTable.get(name);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    boolean isTransactionRunningOnTable(String name) {
        return this.transactions.values().stream().anyMatch(t -> t.isOnTable(name));
    }

    long handleLocalMemoryUsage() {
        long result = 0L;
        for (AbstractTableManager tableManager : this.tables.values()) {
            TableManagerStats stats = tableManager.getStats();
            result += stats.getBuffersUsedMemory();
            result += stats.getKeysUsedMemory();
            result += stats.getDirtyUsedMemory();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processAbandonedTransactions() {
        long now = System.currentTimeMillis();
        long timeout = this.dbmanager.getAbandonedTransactionsTimeout();
        if (timeout <= 0L) {
            return;
        }
        long abandonedTransactionTimeout = now - timeout;
        for (Transaction t : this.transactions.values()) {
            block9: {
                if (!t.isAbandoned(abandonedTransactionTimeout)) continue;
                LOGGER.log(Level.SEVERE, "forcing rollback of abandoned transaction {0}, created locally at {1}, last activity locally at {2}", new Object[]{t.transactionId, new Timestamp(t.localCreationTimestamp), new Timestamp(t.lastActivityTs)});
                try {
                    if (!this.validateTransactionBeforeTxCommand(t.transactionId, false)) {
                    }
                    break block9;
                }
                catch (StatementExecutionException e) {
                    LOGGER.log(Level.SEVERE, "Failed to validate transaction {0}: {1}", new Object[]{t.transactionId, e.getMessage()});
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.SEVERE, "Failed to validate transaction {0}", new Object[]{t.transactionId, e});
                }
                continue;
            }
            long lockStamp = this.acquireReadLock("forceRollback" + t.transactionId);
            try {
                this.forceTransactionRollback(t.transactionId);
            }
            finally {
                this.releaseReadLock(lockStamp, "forceRollback" + t.transactionId);
            }
        }
    }

    void runLocalTableCheckPoints() {
        HashSet<String> tablesToDo = new HashSet<String>(this.tablesNeedingCheckPoint);
        this.tablesNeedingCheckPoint.clear();
        for (String table : tablesToDo) {
            LOGGER.log(Level.INFO, "Forcing local checkpoint table " + this.tableSpaceName + "." + table);
            AbstractTableManager tableManager = this.tables.get(table);
            if (tableManager == null) continue;
            try {
                tableManager.checkpoint(false);
            }
            catch (DataStorageManagerException ex) {
                LOGGER.log(Level.SEVERE, "Bad error on table checkpoint", (Throwable)((Object)ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreRawDumpedEntryLogs(List<DumpedLogEntry> entries) throws DataStorageManagerException, DDLException, EOFException {
        long lockStamp = this.acquireWriteLock("restoreRawDumpedEntryLogs");
        try {
            for (DumpedLogEntry ld : entries) {
                this.apply(new CommitLogResult(ld.logSequenceNumber, false, false), LogEntry.deserialize(ld.entryData), true);
            }
        }
        finally {
            this.releaseWriteLock(lockStamp, "restoreRawDumpedEntryLogs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginRestoreTable(byte[] tableDef, LogSequenceNumber dumpLogSequenceNumber) {
        Table table = Table.deserialize(tableDef);
        long lockStamp = this.acquireWriteLock("beginRestoreTable " + table.name);
        try {
            if (this.tables.containsKey(table.name)) {
                throw new TableAlreadyExistsException(table.name);
            }
            this.bootTable(table, 0L, dumpLogSequenceNumber);
        }
        finally {
            this.releaseWriteLock(lockStamp, "beginRestoreTable " + table.name);
        }
    }

    public void restoreTableFinished(String table, List<Index> indexes) {
        TableManager tableManager = (TableManager)this.tables.get(table);
        tableManager.restoreFinished();
        for (Index index : indexes) {
            this.bootIndex(index, tableManager, 0L, true, true);
        }
    }

    public void restoreRawDumpedTransactions(List<Transaction> entries) {
        for (Transaction ld : entries) {
            LOGGER.log(Level.INFO, "restore transaction " + ld);
            this.transactions.put(ld.transactionId, ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    void dumpTableSpace(String dumpId, Channel channel, int fetchSize, boolean includeLog) throws DataStorageManagerException, LogNotAvailableException {
        TableSpaceManager.LOGGER.log(Level.INFO, "dumpTableSpace dumpId:{0} channel {1} fetchSize:{2}, includeLog:{3}", new Object[]{dumpId, channel, fetchSize, includeLog});
        txlogentries = new CopyOnWriteArrayList<DumpedLogEntry>();
        logDumpReceiver = new CommitLogListener(){

            @Override
            public void logEntry(LogSequenceNumber logPos, LogEntry data) {
                txlogentries.add(new DumpedLogEntry(logPos, data.serialize()));
            }
        };
        lockStamp = this.acquireWriteLock(null);
        if (includeLog) {
            this.log.attachCommitLogListener(logDumpReceiver);
        }
        checkpoint = this.checkpoint(true, true, true);
        TableSpaceManager.LOGGER.log(Level.INFO, "Created checkpoint at {}", checkpoint);
        if (checkpoint == null) {
            throw new DataStorageManagerException("failed to create a checkpoint, check logs for the reason");
        }
        if ((lockStamp = this.generalLock.tryConvertToReadLock(lockStamp)) == 0L) {
            throw new DataStorageManagerException("unable to downgrade lock");
        }
        try {
            block32: {
                timeout = 60000;
                checkpointSequenceNumber = TableSpaceCheckpoint.access$000(checkpoint);
                id = channel.generateRequestId();
                TableSpaceManager.LOGGER.log(Level.INFO, "start sending dump, dumpId: {0} to client {1}", new Object[]{dumpId, channel});
                response_to_start = channel.sendMessageWithPduReply(id, PduCodec.TablespaceDumpData.write((long)id, (String)this.tableSpaceName, (String)dumpId, (String)"start", null, (long)this.stats.getTablesize(), (long)checkpointSequenceNumber.ledgerId, (long)checkpointSequenceNumber.offset, null, null), 60000L);
                try {
                    if (response_to_start.type != 0) {
                        TableSpaceManager.LOGGER.log(Level.SEVERE, "error response at start command");
                        if (response_to_start == null) break block32;
                    }
                    ** GOTO lbl73
                }
                catch (Throwable var15_19) {
                    if (response_to_start == null) throw var15_19;
                    try {
                        response_to_start.close();
                        throw var15_19;
                    }
                    catch (Throwable entry) {
                        var15_19.addSuppressed(entry);
                    }
                    throw var15_19;
                }
                response_to_start.close();
            }
            this.releaseReadLock(lockStamp, "senddump");
            if (includeLog) {
                this.log.removeCommitLogListener(logDumpReceiver);
            }
            var15_18 = TableSpaceCheckpoint.access$100(checkpoint).entrySet().iterator();
            ** GOTO lbl63
        }
        catch (InterruptedException | TimeoutException error) {
            try {
                TableSpaceManager.LOGGER.log(Level.SEVERE, "error sending dump id " + dumpId, error);
                this.releaseReadLock(lockStamp, "senddump");
                if (includeLog) {
                    this.log.removeCommitLogListener(logDumpReceiver);
                }
                var10_12 = TableSpaceCheckpoint.access$100(checkpoint).entrySet().iterator();
            }
            catch (Throwable var27_46) {
                this.releaseReadLock(lockStamp, "senddump");
                if (includeLog) {
                    this.log.removeCommitLogListener(logDumpReceiver);
                }
                var28_47 = TableSpaceCheckpoint.access$100(checkpoint).entrySet().iterator();
                while (var28_47.hasNext() != false) {
                    entry = var28_47.next();
                    tableName = (String)entry.getKey();
                    tableManager = this.tables.get(tableName);
                    tableUUID = tableManager.getTable().uuid;
                    seqNumber = (LogSequenceNumber)entry.getValue();
                    TableSpaceManager.LOGGER.log(Level.INFO, "unPinTableCheckpoint {0}.{1} ({2}) {3}", new Object[]{this.tableSpaceUUID, tableName, tableUUID, seqNumber});
                    this.dataStorageManager.unPinTableCheckpoint(this.tableSpaceUUID, tableUUID, seqNumber);
                }
                throw var27_46;
            }
lbl63:
            // 2 sources

            while (var15_18.hasNext() != false) {
                entry = var15_18.next();
                tableName = (String)entry.getKey();
                tableManager = this.tables.get(tableName);
                tableUUID = tableManager.getTable().uuid;
                seqNumber = (LogSequenceNumber)entry.getValue();
                TableSpaceManager.LOGGER.log(Level.INFO, "unPinTableCheckpoint {0}.{1} ({2}) {3}", new Object[]{this.tableSpaceUUID, tableName, tableUUID, seqNumber});
                this.dataStorageManager.unPinTableCheckpoint(this.tableSpaceUUID, tableUUID, seqNumber);
            }
            return;
lbl73:
            // 1 sources

            if (response_to_start != null) {
                response_to_start.close();
            }
            if (includeLog) {
                transactionsSnapshot = new ArrayList<E>();
                this.dataStorageManager.loadTransactions(checkpointSequenceNumber, this.tableSpaceUUID, (Consumer<Transaction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Lherddb/model/Transaction;)V)((List)transactionsSnapshot));
                var15_20 = new ArrayList<Transaction>();
                entry = transactionsSnapshot.iterator();
                while (entry.hasNext()) {
                    t = (Transaction)entry.next();
                    var15_20.add(t);
                    if (var15_20.size() != 10) continue;
                    this.sendTransactionsDump(var15_20, channel, dumpId, 60000);
                }
                this.sendTransactionsDump(var15_20, channel, dumpId, 60000);
            }
            for (Map.Entry var15_22 : TableSpaceCheckpoint.access$100(checkpoint).entrySet()) {
                tableManager = this.tables.get(var15_22.getKey());
                sequenceNumber = (LogSequenceNumber)var15_22.getValue();
                if (tableManager.isSystemTable()) continue;
                try {
                    TableSpaceManager.LOGGER.log(Level.INFO, "Sending table checkpoint for {} took at sequence number {}", new Object[]{tableManager.getTable().name, sequenceNumber});
                    sink = new SingleTableDumper(this.tableSpaceName, tableManager, channel, dumpId, 60000, fetchSize);
                    tableManager.dump(sequenceNumber, sink);
                }
                catch (DataStorageManagerException err) {
                    TableSpaceManager.LOGGER.log(Level.SEVERE, "error sending dump id " + dumpId, (Throwable)err);
                    errorid = channel.generateRequestId();
                    response = channel.sendMessageWithPduReply(errorid, PduCodec.TablespaceDumpData.write((long)id, (String)this.tableSpaceName, (String)dumpId, (String)"error", null, (long)0L, (long)0L, (long)0L, null, null), 60000L);
                    if (response != null) {
                        response.close();
                    }
                    this.releaseReadLock(lockStamp, "senddump");
                    if (includeLog) {
                        this.log.removeCommitLogListener(logDumpReceiver);
                    }
                    var21_38 = TableSpaceCheckpoint.access$100(checkpoint).entrySet().iterator();
                    while (var21_38.hasNext() != false) {
                        entry = var21_38.next();
                        tableName = (String)entry.getKey();
                        tableManager = this.tables.get(tableName);
                        tableUUID = tableManager.getTable().uuid;
                        seqNumber = (LogSequenceNumber)entry.getValue();
                        TableSpaceManager.LOGGER.log(Level.INFO, "unPinTableCheckpoint {0}.{1} ({2}) {3}", new Object[]{this.tableSpaceUUID, tableName, tableUUID, seqNumber});
                        this.dataStorageManager.unPinTableCheckpoint(this.tableSpaceUUID, tableUUID, seqNumber);
                    }
                    return;
                }
            }
            {
                if (!txlogentries.isEmpty()) {
                    txlogentries.sort(Comparator.naturalOrder());
                    this.sendDumpedCommitLog(txlogentries, channel, dumpId, 60000);
                }
                finishLogSequenceNumber = this.log.getLastSequenceNumber();
                channel.sendOneWayMessage(PduCodec.TablespaceDumpData.write((long)id, (String)this.tableSpaceName, (String)dumpId, (String)"finish", null, (long)0L, (long)finishLogSequenceNumber.ledgerId, (long)finishLogSequenceNumber.offset, null, null), (SendResultCallback)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Throwable;)V, lambda$dumpTableSpace$6(java.lang.String java.lang.Throwable ), (Ljava/lang/Throwable;)V)((String)dumpId));
                this.releaseReadLock(lockStamp, "senddump");
                if (includeLog) {
                    this.log.removeCommitLogListener(logDumpReceiver);
                }
                timeout = TableSpaceCheckpoint.access$100(checkpoint).entrySet().iterator();
            }
            while (timeout.hasNext() != false) {
                entry = timeout.next();
                tableName = (String)entry.getKey();
                tableManager = this.tables.get(tableName);
                tableUUID = tableManager.getTable().uuid;
                var15_24 = (LogSequenceNumber)entry.getValue();
                TableSpaceManager.LOGGER.log(Level.INFO, "unPinTableCheckpoint {0}.{1} ({2}) {3}", new Object[]{this.tableSpaceUUID, tableName, tableUUID, var15_24});
                this.dataStorageManager.unPinTableCheckpoint(this.tableSpaceUUID, tableUUID, var15_24);
            }
            return;
            while (var10_12.hasNext() != false) {
                entry = var10_12.next();
                tableName = (String)entry.getKey();
                tableManager = this.tables.get(tableName);
                tableUUID = tableManager.getTable().uuid;
                var15_26 = (LogSequenceNumber)entry.getValue();
                TableSpaceManager.LOGGER.log(Level.INFO, "unPinTableCheckpoint {0}.{1} ({2}) {3}", new Object[]{this.tableSpaceUUID, tableName, tableUUID, var15_26});
                this.dataStorageManager.unPinTableCheckpoint(this.tableSpaceUUID, tableUUID, var15_26);
            }
            return;
        }
    }

    private void sendTransactionsDump(List<Transaction> batch, Channel channel, String dumpId, int timeout) throws TimeoutException, InterruptedException {
        if (batch.isEmpty()) {
            return;
        }
        List encodedTransactions = batch.stream().map(tr -> new KeyValue(Bytes.from_long((long)tr.transactionId), Bytes.from_array((byte[])tr.serialize()))).collect(Collectors.toList());
        long id = channel.generateRequestId();
        try (Pdu response_to_transactionsData = channel.sendMessageWithPduReply(id, PduCodec.TablespaceDumpData.write((long)id, (String)this.tableSpaceName, (String)dumpId, (String)"transactions", null, (long)0L, (long)0L, (long)0L, null, encodedTransactions), (long)timeout);){
            if (response_to_transactionsData.type != 0) {
                LOGGER.log(Level.SEVERE, "error response at transactionsData command");
            }
        }
        batch.clear();
    }

    private void sendDumpedCommitLog(List<DumpedLogEntry> txlogentries, Channel channel, String dumpId, int timeout) throws TimeoutException, InterruptedException {
        ArrayList<KeyValue> batch = new ArrayList<KeyValue>();
        for (DumpedLogEntry e : txlogentries) {
            batch.add(new KeyValue(Bytes.from_array((byte[])e.logSequenceNumber.serialize()), Bytes.from_array((byte[])e.entryData)));
        }
        long id = channel.generateRequestId();
        try (Pdu response_to_txlog = channel.sendMessageWithPduReply(id, PduCodec.TablespaceDumpData.write((long)id, (String)this.tableSpaceName, (String)dumpId, (String)"txlog", null, (long)0L, (long)0L, (long)0L, null, batch), (long)timeout);){
            if (response_to_txlog.type != 0) {
                LOGGER.log(Level.SEVERE, "error response at txlog command");
            }
        }
    }

    public void restoreFinished() throws DataStorageManagerException {
        LOGGER.log(Level.INFO, "restore finished of tableSpace " + this.tableSpaceName + ". requesting checkpoint");
        this.transactions.clear();
        this.checkpoint(false, false, false);
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    void setFailed() {
        this.failed = true;
    }

    public boolean isFailed() {
        if (this.virtual) {
            return false;
        }
        return this.failed || this.log.isFailed();
    }

    void startAsFollower() throws DataStorageManagerException, DDLException, LogNotAvailableException {
        this.followerThread = new FollowerThread();
        this.dbmanager.submit(this.followerThread);
    }

    void startAsLeader() throws DataStorageManagerException, DDLException, LogNotAvailableException {
        if (!this.virtual) {
            LOGGER.log(Level.INFO, "startAsLeader {0} tablespace {1}", new Object[]{this.nodeId, this.tableSpaceName});
            this.recoverForLeadership();
            ArrayList pending_transactions = new ArrayList(this.transactions.keySet());
            this.log.startWriting();
            LOGGER.log(Level.INFO, "startAsLeader {0} tablespace {1} log, there were {2} pending transactions to be rolledback", new Object[]{this.nodeId, this.tableSpaceName, pending_transactions.size()});
            Iterator iterator = pending_transactions.iterator();
            while (iterator.hasNext()) {
                long tx = (Long)iterator.next();
                this.forceTransactionRollback(tx);
            }
        }
        this.leader = true;
    }

    private void forceTransactionRollback(long tx) throws LogNotAvailableException, DataStorageManagerException, DDLException {
        LOGGER.log(Level.FINER, "rolling back transaction {0}", tx);
        LogEntry rollback = LogEntryFactory.rollbackTransaction(tx);
        CommitLogResult pos = this.log.log(rollback, true);
        this.apply(pos, rollback, false);
    }

    public StatementExecutionResult executeStatement(Statement statement, StatementEvaluationContext context, TransactionContext transactionContext) throws StatementExecutionException {
        CompletableFuture<StatementExecutionResult> res = this.executeStatementAsync(statement, context, transactionContext);
        try {
            return res.get();
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new StatementExecutionException(err);
        }
        catch (ExecutionException err) {
            Throwable cause = err.getCause();
            if (cause instanceof StatementExecutionException) {
                throw (StatementExecutionException)((Object)cause);
            }
            throw new StatementExecutionException(cause);
        }
        catch (Throwable t) {
            throw new StatementExecutionException(t);
        }
    }

    public CompletableFuture<StatementExecutionResult> executeStatementAsync(Statement statement, StatementEvaluationContext context, TransactionContext transactionContext) throws StatementExecutionException {
        if (transactionContext.transactionId == -1L && statement.supportsTransactionAutoCreate()) {
            AtomicLong capturedTx = new AtomicLong();
            boolean wasHoldingTableSpaceLock = context.getTableSpaceLock() != 0L;
            CompletableFuture<StatementExecutionResult> newTransaction = this.beginTransactionAsync(context, false);
            CompletionStage finalResult = newTransaction.thenCompose(begineTransactionResult -> {
                TransactionContext newtransactionContext = new TransactionContext(begineTransactionResult.transactionId);
                capturedTx.set(newtransactionContext.transactionId);
                return this.executeStatementAsyncInternal(statement, context, newtransactionContext, true);
            });
            ((CompletableFuture)finalResult).whenComplete((xx, error) -> {
                if (!wasHoldingTableSpaceLock) {
                    this.releaseReadLock(context.getTableSpaceLock(), "begin implicit transaction");
                }
                long txId = capturedTx.get();
                if (error != null && txId > 0L) {
                    LOGGER.log(Level.FINE, this.tableSpaceName + " force rollback of implicit transaction " + txId, (Throwable)error);
                    try {
                        this.rollbackTransaction(new RollbackTransactionStatement(this.tableSpaceName, txId), context).get();
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.SEVERE, this.tableSpaceName + " Cannot rollback implicit tx " + txId, ex);
                        Thread.currentThread().interrupt();
                        error.addSuppressed(ex);
                    }
                    catch (ExecutionException ex) {
                        LOGGER.log(Level.SEVERE, this.tableSpaceName + " Cannot rollback implicit tx " + txId, ex.getCause());
                        error.addSuppressed(ex.getCause());
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.SEVERE, this.tableSpaceName + " Cannot rollback  implicittx " + txId, t);
                        error.addSuppressed(t);
                    }
                }
            });
            return finalResult;
        }
        return this.executeStatementAsyncInternal(statement, context, transactionContext, false);
    }

    private CompletableFuture<StatementExecutionResult> executeStatementAsyncInternal(Statement statement, StatementEvaluationContext context, TransactionContext transactionContext, boolean rollbackOnError) throws StatementExecutionException {
        long txId;
        CompletableFuture<StatementExecutionResult> res;
        boolean isTransactionCommand;
        Transaction transaction = this.transactions.get(transactionContext.transactionId);
        if (transaction != null && !transaction.tableSpace.equals(this.tableSpaceName)) {
            return FutureUtils.exception((Throwable)((Object)new StatementExecutionException("transaction " + transaction.transactionId + " is for tablespace " + transaction.tableSpace + ", not for " + this.tableSpaceName)));
        }
        if (transactionContext.transactionId > 0L && transaction == null) {
            return FutureUtils.exception((Throwable)((Object)new StatementExecutionException("transaction " + transactionContext.transactionId + " not found on tablespace " + this.tableSpaceName)));
        }
        boolean bl = isTransactionCommand = statement instanceof CommitTransactionStatement || statement instanceof RollbackTransactionStatement;
        if (transaction != null) {
            transaction.touch();
            if (!isTransactionCommand) {
                transaction.increaseRefcount();
            }
        }
        try {
            res = statement instanceof TableAwareStatement ? this.executeTableAwareStatement(statement, transaction, context) : (statement instanceof SQLPlannedOperationStatement ? this.executePlannedOperationStatement(statement, transactionContext, context) : (statement instanceof BeginTransactionStatement ? (transaction != null ? FutureUtils.exception((Throwable)((Object)new StatementExecutionException("transaction already started"))) : this.beginTransactionAsync(context, true)) : (statement instanceof CommitTransactionStatement ? this.commitTransaction((CommitTransactionStatement)statement, context) : (statement instanceof RollbackTransactionStatement ? this.rollbackTransaction((RollbackTransactionStatement)statement, context) : (statement instanceof CreateTableStatement ? CompletableFuture.completedFuture(this.createTable((CreateTableStatement)statement, transaction, context)) : (statement instanceof CreateIndexStatement ? CompletableFuture.completedFuture(this.createIndex((CreateIndexStatement)statement, transaction, context)) : (statement instanceof DropTableStatement ? CompletableFuture.completedFuture(this.dropTable((DropTableStatement)statement, transaction, context)) : (statement instanceof DropIndexStatement ? CompletableFuture.completedFuture(this.dropIndex((DropIndexStatement)statement, transaction, context)) : (statement instanceof AlterTableStatement ? CompletableFuture.completedFuture(this.alterTable((AlterTableStatement)statement, transactionContext, context)) : FutureUtils.exception((Throwable)new StatementExecutionException("unsupported statement " + statement).fillInStackTrace()))))))))));
        }
        catch (StatementExecutionException error2) {
            res = FutureUtils.exception((Throwable)((Object)error2));
        }
        if (transaction != null && !isTransactionCommand) {
            res = res.whenComplete((a, b) -> transaction.decreaseRefCount());
        }
        if (rollbackOnError && (txId = transactionContext.transactionId) > 0L) {
            res = res.whenComplete((xx, error) -> {
                if (error != null) {
                    LOGGER.log(Level.FINE, this.tableSpaceName + " force rollback of implicit transaction " + txId, (Throwable)error);
                    try {
                        this.rollbackTransaction(new RollbackTransactionStatement(this.tableSpaceName, txId), context).get();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        error.addSuppressed(ex);
                    }
                    catch (ExecutionException ex) {
                        error.addSuppressed(ex.getCause());
                    }
                    throw new HerdDBInternalException(error);
                }
            });
        }
        return res;
    }

    private CompletableFuture<StatementExecutionResult> executePlannedOperationStatement(Statement statement, TransactionContext transactionContext, StatementEvaluationContext context) {
        long lockStamp = context.getTableSpaceLock();
        boolean lockAcquired = false;
        if (lockStamp == 0L) {
            lockStamp = this.acquireReadLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        SQLPlannedOperationStatement planned = (SQLPlannedOperationStatement)statement;
        CompletionStage<StatementExecutionResult> res = planned.getRootOp().executeAsync(this, transactionContext, context, false, false);
        if (lockAcquired) {
            res = this.releaseReadLock((CompletableFuture<StatementExecutionResult>)res, lockStamp, statement).thenApply(s -> {
                context.setTableSpaceLock(0L);
                return s;
            });
        }
        return res;
    }

    private CompletableFuture<StatementExecutionResult> executeTableAwareStatement(Statement statement, Transaction transaction, StatementEvaluationContext context) throws StatementExecutionException {
        TableAwareStatement st;
        String table;
        AbstractTableManager manager;
        long lockStamp = context.getTableSpaceLock();
        boolean lockAcquired = false;
        if (lockStamp == 0L) {
            lockStamp = this.acquireReadLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        CompletionStage res = (manager = this.tables.get(table = (st = (TableAwareStatement)statement).getTable())) == null ? FutureUtils.exception((Throwable)((Object)new TableDoesNotExistException("no table " + table + " in tablespace " + this.tableSpaceName))) : (manager.getCreatedInTransaction() > 0L && (transaction == null || transaction.transactionId != manager.getCreatedInTransaction()) ? FutureUtils.exception((Throwable)((Object)new TableDoesNotExistException("no table " + table + " in tablespace " + this.tableSpaceName + ". created temporary in transaction " + manager.getCreatedInTransaction()))) : manager.executeStatementAsync(statement, transaction, context));
        if (lockAcquired) {
            res = this.releaseReadLock((CompletableFuture<StatementExecutionResult>)res, lockStamp, statement).whenComplete((s, err) -> context.setTableSpaceLock(0L));
        }
        return res;
    }

    private long acquireReadLock(Object statement) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} rlock {1}", new Object[]{this.tableSpaceName, statement});
        }
        long lockStamp = this.generalLock.readLock();
        return lockStamp;
    }

    private long acquireWriteLock(Object statement) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} wlock {1}", new Object[]{this.tableSpaceName, statement});
        }
        long lockStamp = this.generalLock.writeLock();
        return lockStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementExecutionResult alterTable(AlterTableStatement statement, TransactionContext transactionContext, StatementEvaluationContext context) throws StatementExecutionException {
        boolean lockAcquired = false;
        if (context.getTableSpaceLock() == 0L) {
            long lockStamp = this.acquireWriteLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        try {
            Table newTable;
            if (transactionContext.transactionId > 0L) {
                throw new StatementExecutionException("ALTER TABLE cannot be executed inside a transaction (txid=" + transactionContext.transactionId + ")");
            }
            AbstractTableManager tableManager = this.tables.get(statement.getTable());
            if (tableManager == null) {
                throw new TableDoesNotExistException("no table " + statement.getTable() + " in tablespace " + this.tableSpaceName + ", only " + this.tables.keySet());
            }
            try {
                newTable = tableManager.getTable().applyAlterTable(statement);
            }
            catch (IllegalArgumentException error) {
                throw new StatementExecutionException(error);
            }
            this.validateAlterTable(newTable, null);
            LogEntry entry = LogEntryFactory.alterTable(newTable, null);
            try {
                CommitLogResult pos = this.log.log(entry, entry.transactionId <= 0L);
                this.apply(pos, entry, false);
            }
            catch (Exception err) {
                throw new StatementExecutionException(err);
            }
            DDLStatementExecutionResult dDLStatementExecutionResult = new DDLStatementExecutionResult(transactionContext.transactionId);
            return dDLStatementExecutionResult;
        }
        finally {
            if (lockAcquired) {
                this.releaseWriteLock(context.getTableSpaceLock(), statement);
                context.setTableSpaceLock(0L);
            }
        }
    }

    private StatementExecutionResult createTable(CreateTableStatement statement, Transaction transaction, StatementEvaluationContext context) throws StatementExecutionException {
        boolean lockAcquired = false;
        if (context.getTableSpaceLock() == 0L) {
            long lockStamp = this.acquireWriteLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        try {
            if (this.tables.containsKey(statement.getTableDefinition().name)) {
                if (statement.isIfExistsClause()) {
                    DDLStatementExecutionResult lockStamp = new DDLStatementExecutionResult(transaction != null ? transaction.transactionId : 0L);
                    return lockStamp;
                }
                throw new TableAlreadyExistsException(statement.getTableDefinition().name);
            }
            for (Index additionalIndex : statement.getAdditionalIndexes()) {
                if (!this.indexes.containsKey(additionalIndex.name)) continue;
                throw new IndexAlreadyExistsException(additionalIndex.name);
            }
            LogEntry entry = LogEntryFactory.createTable(statement.getTableDefinition(), transaction);
            CommitLogResult pos = this.log.log(entry, entry.transactionId <= 0L);
            this.apply(pos, entry, false);
            for (Index additionalIndex : statement.getAdditionalIndexes()) {
                LogEntry index_entry = LogEntryFactory.createIndex(additionalIndex, transaction);
                CommitLogResult index_pos = this.log.log(index_entry, index_entry.transactionId <= 0L);
                this.apply(index_pos, index_entry, false);
            }
            DDLStatementExecutionResult dDLStatementExecutionResult = new DDLStatementExecutionResult(entry.transactionId);
            return dDLStatementExecutionResult;
        }
        catch (LogNotAvailableException | DataStorageManagerException err) {
            throw new StatementExecutionException((Throwable)err);
        }
        finally {
            if (lockAcquired) {
                this.releaseWriteLock(context.getTableSpaceLock(), statement);
                context.setTableSpaceLock(0L);
            }
        }
    }

    private StatementExecutionResult createIndex(CreateIndexStatement statement, Transaction transaction, StatementEvaluationContext context) throws StatementExecutionException {
        boolean lockAcquired = false;
        if (context.getTableSpaceLock() == 0L) {
            long lockStamp = this.acquireWriteLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        try {
            CommitLogResult pos;
            if (this.indexes.containsKey(statement.getIndexefinition().name)) {
                throw new IndexAlreadyExistsException(statement.getIndexefinition().name);
            }
            LogEntry entry = LogEntryFactory.createIndex(statement.getIndexefinition(), transaction);
            try {
                pos = this.log.log(entry, entry.transactionId <= 0L);
            }
            catch (LogNotAvailableException ex) {
                throw new StatementExecutionException((Throwable)((Object)ex));
            }
            this.apply(pos, entry, false);
            DDLStatementExecutionResult dDLStatementExecutionResult = new DDLStatementExecutionResult(entry.transactionId);
            return dDLStatementExecutionResult;
        }
        catch (DataStorageManagerException err) {
            throw new StatementExecutionException((Throwable)((Object)err));
        }
        finally {
            if (lockAcquired) {
                this.releaseWriteLock(context.getTableSpaceLock(), statement);
                context.setTableSpaceLock(0L);
            }
        }
    }

    private StatementExecutionResult dropTable(DropTableStatement statement, Transaction transaction, StatementEvaluationContext context) throws StatementExecutionException {
        boolean lockAcquired = false;
        if (context.getTableSpaceLock() == 0L) {
            long lockStamp = this.acquireWriteLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        try {
            if (!this.tables.containsKey(statement.getTable())) {
                if (statement.isIfExists()) {
                    DDLStatementExecutionResult lockStamp = new DDLStatementExecutionResult(transaction != null ? transaction.transactionId : 0L);
                    return lockStamp;
                }
                throw new TableDoesNotExistException("table does not exist " + statement.getTable() + " on tableSpace " + statement.getTableSpace());
            }
            if (transaction != null && transaction.isTableDropped(statement.getTable())) {
                if (statement.isIfExists()) {
                    DDLStatementExecutionResult lockStamp = new DDLStatementExecutionResult(transaction.transactionId);
                    return lockStamp;
                }
                throw new TableDoesNotExistException("table does not exist " + statement.getTable() + " on tableSpace " + statement.getTableSpace());
            }
            Map<String, AbstractIndexManager> indexesOnTable = this.indexesByTable.get(statement.getTable());
            if (indexesOnTable != null) {
                for (String index : indexesOnTable.keySet()) {
                    LogEntry entry = LogEntryFactory.dropIndex(index, transaction);
                    CommitLogResult pos = this.log.log(entry, entry.transactionId <= 0L);
                    this.apply(pos, entry, false);
                }
            }
            LogEntry entry = LogEntryFactory.dropTable(statement.getTable(), transaction);
            CommitLogResult pos = this.log.log(entry, entry.transactionId <= 0L);
            this.apply(pos, entry, false);
            DDLStatementExecutionResult dDLStatementExecutionResult = new DDLStatementExecutionResult(entry.transactionId);
            return dDLStatementExecutionResult;
        }
        catch (LogNotAvailableException | DataStorageManagerException err) {
            throw new StatementExecutionException((Throwable)err);
        }
        finally {
            if (lockAcquired) {
                this.releaseWriteLock(context.getTableSpaceLock(), statement);
                context.setTableSpaceLock(0L);
            }
        }
    }

    private StatementExecutionResult dropIndex(DropIndexStatement statement, Transaction transaction, StatementEvaluationContext context) throws StatementExecutionException {
        boolean lockAcquired = false;
        if (context.getTableSpaceLock() == 0L) {
            long lockStamp = this.acquireWriteLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        try {
            CommitLogResult pos;
            if (!this.indexes.containsKey(statement.getIndexName())) {
                if (statement.isIfExists()) {
                    DDLStatementExecutionResult lockStamp = new DDLStatementExecutionResult(transaction != null ? transaction.transactionId : 0L);
                    return lockStamp;
                }
                throw new IndexDoesNotExistException("index " + statement.getIndexName() + " does not exist " + statement.getIndexName() + " on tableSpace " + statement.getTableSpace());
            }
            if (transaction != null && transaction.isIndexDropped(statement.getIndexName())) {
                if (statement.isIfExists()) {
                    DDLStatementExecutionResult lockStamp = new DDLStatementExecutionResult(transaction.transactionId);
                    return lockStamp;
                }
                throw new IndexDoesNotExistException("index does not exist " + statement.getIndexName() + " on tableSpace " + statement.getTableSpace());
            }
            LogEntry entry = LogEntryFactory.dropIndex(statement.getIndexName(), transaction);
            try {
                pos = this.log.log(entry, entry.transactionId <= 0L);
            }
            catch (LogNotAvailableException ex) {
                throw new StatementExecutionException((Throwable)((Object)ex));
            }
            this.apply(pos, entry, false);
            DDLStatementExecutionResult dDLStatementExecutionResult = new DDLStatementExecutionResult(entry.transactionId);
            return dDLStatementExecutionResult;
        }
        catch (DataStorageManagerException err) {
            throw new StatementExecutionException((Throwable)((Object)err));
        }
        finally {
            if (lockAcquired) {
                this.releaseWriteLock(context.getTableSpaceLock(), statement);
                context.setTableSpaceLock(0L);
            }
        }
    }

    TableManager bootTable(Table table, long transaction, LogSequenceNumber dumpLogSequenceNumber) throws DataStorageManagerException {
        long _start = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "bootTable {0} {1}.{2}", new Object[]{this.nodeId, this.tableSpaceName, table.name});
        AbstractTableManager prevTableManager = this.tables.remove(table.name);
        if (prevTableManager != null) {
            if (dumpLogSequenceNumber != null) {
                LOGGER.log(Level.INFO, "bootTable {0} {1}.{2} already exists on this tablespace. It will be truncated", new Object[]{this.nodeId, this.tableSpaceName, table.name});
                prevTableManager.dropTableData();
            } else {
                LOGGER.log(Level.INFO, "bootTable {0} {1}.{2} already exists on this tablespace", new Object[]{this.nodeId, this.tableSpaceName, table.name});
                throw new DataStorageManagerException("Table " + table.name + " already present in tableSpace " + this.tableSpaceName);
            }
        }
        TableManager tableManager = new TableManager(table, this.log, this.dbmanager.getMemoryManager(), this.dataStorageManager, this, this.tableSpaceUUID, transaction);
        if (this.dbmanager.getServerConfiguration().getBoolean("server.jmx.enable", true)) {
            JMXUtils.registerTableManagerStatsMXBean(this.tableSpaceName, table.name, tableManager.getStats());
        }
        if (dumpLogSequenceNumber != null) {
            tableManager.prepareForRestore(dumpLogSequenceNumber);
        }
        this.tables.put(table.name, tableManager);
        tableManager.start();
        LOGGER.log(Level.INFO, "bootTable {0} {1}.{2} time {3} ms", new Object[]{this.nodeId, this.tableSpaceName, table.name, System.currentTimeMillis() - _start + ""});
        this.dbmanager.getPlanner().clearCache();
        return tableManager;
    }

    AbstractIndexManager bootIndex(Index index, AbstractTableManager tableManager, long transaction, boolean rebuild, boolean restore) throws DataStorageManagerException {
        AbstractIndexManager indexManager;
        long _start = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "bootIndex {0} {1}.{2}.{3} uuid {4} - {5}", new Object[]{this.nodeId, this.tableSpaceName, index.table, index.name, index.uuid, index.type});
        AbstractIndexManager prevIndexManager = this.indexes.remove(index.name);
        if (prevIndexManager != null) {
            if (restore) {
                LOGGER.log(Level.INFO, "bootIndex {0} {1}.{2}.{3} uuid {4} - {5} already exists on this tablespace. It will be truncated", new Object[]{this.nodeId, this.tableSpaceName, index.table, index.name, index.uuid, index.type});
                prevIndexManager.dropIndexData();
            } else {
                LOGGER.log(Level.INFO, "bootIndex {0} {1}.{2}.{3} uuid {4} - {5}", new Object[]{this.nodeId, this.tableSpaceName, index.table, index.name, index.uuid, index.type});
                if (this.indexes.containsKey(index.name)) {
                    throw new DataStorageManagerException("Index" + index.name + " already present in tableSpace " + this.tableSpaceName);
                }
            }
        }
        switch (index.type) {
            case "hash": {
                indexManager = new MemoryHashIndexManager(index, tableManager, this.log, this.dataStorageManager, this, this.tableSpaceUUID, transaction);
                break;
            }
            case "brin": {
                indexManager = new BRINIndexManager(index, this.dbmanager.getMemoryManager(), tableManager, this.log, this.dataStorageManager, this, this.tableSpaceUUID, transaction);
                break;
            }
            default: {
                throw new DataStorageManagerException("invalid index type " + index.type);
            }
        }
        this.indexes.put(index.name, indexManager);
        HashMap<String, AbstractIndexManager> newMap = new HashMap<String, AbstractIndexManager>();
        newMap.put(index.name, indexManager);
        this.indexesByTable.merge(index.table, newMap, (a, b) -> {
            HashMap map = new HashMap(a);
            map.putAll(b);
            return map;
        });
        indexManager.start(tableManager.getBootSequenceNumber());
        long _stop = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "bootIndex {0} {1}.{2} time {3} ms", new Object[]{this.nodeId, this.tableSpaceName, index.name, _stop - _start + ""});
        if (rebuild) {
            indexManager.rebuild();
            LOGGER.log(Level.INFO, "bootIndex - rebuild {0} {1}.{2} time {3} ms", new Object[]{this.nodeId, this.tableSpaceName, index.name, System.currentTimeMillis() - _stop + ""});
        }
        this.dbmanager.getPlanner().clearCache();
        return indexManager;
    }

    private void validateAlterTable(Table table, StatementEvaluationContext context) {
        AbstractTableManager tableManager = null;
        String oldTableName = null;
        for (AbstractTableManager tm : this.tables.values()) {
            if (!tm.getTable().uuid.equals(table.uuid)) continue;
            tableManager = tm;
            oldTableName = tm.getTable().name;
        }
        if (tableManager == null || oldTableName == null) {
            throw new TableDoesNotExistException("Cannot find table " + table.name + " with uuid " + table.uuid);
        }
        tableManager.validateAlterTable(table, context);
    }

    private AbstractTableManager alterTable(Table table, Transaction transaction) throws DDLException {
        LOGGER.log(Level.INFO, "alterTable {0} {1}.{2} uuid {3}", new Object[]{this.nodeId, this.tableSpaceName, table.name, table.uuid});
        AbstractTableManager tableManager = null;
        String oldTableName = null;
        for (AbstractTableManager tm : this.tables.values()) {
            if (!tm.getTable().uuid.equals(table.uuid)) continue;
            tableManager = tm;
            oldTableName = tm.getTable().name;
        }
        if (tableManager == null || oldTableName == null) {
            throw new TableDoesNotExistException("Cannot find table " + table.name + " with uuid " + table.uuid);
        }
        tableManager.tableAltered(table, transaction);
        if (!oldTableName.equalsIgnoreCase(table.name)) {
            this.tables.remove(oldTableName);
            this.tables.put(table.name, tableManager);
        }
        return tableManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws LogNotAvailableException {
        boolean useJmx = this.dbmanager.getServerConfiguration().getBoolean("server.jmx.enable", true);
        this.closed = true;
        if (this.followerThread != null) {
            try {
                this.followerThread.waitForStop();
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                LOGGER.log(Level.SEVERE, "Cannot wait for FollowerThread to stop", err);
            }
        }
        if (!this.virtual) {
            long lockStamp = this.acquireWriteLock("closeTablespace");
            try {
                for (Map.Entry<String, AbstractTableManager> table : this.tables.entrySet()) {
                    if (useJmx) {
                        JMXUtils.unregisterTableManagerStatsMXBean(this.tableSpaceName, table.getKey());
                    }
                    table.getValue().close();
                }
                for (AbstractIndexManager index : this.indexes.values()) {
                    index.close();
                }
                this.log.close();
            }
            finally {
                this.releaseWriteLock(lockStamp, "closeTablespace");
            }
        }
        if (useJmx) {
            JMXUtils.unregisterTableSpaceManagerStatsMXBean(this.tableSpaceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TableSpaceCheckpoint checkpoint(boolean full, boolean pin, boolean alreadLocked) throws DataStorageManagerException, LogNotAvailableException {
        ArrayList<PostCheckpointAction> actions;
        HashMap<String, LogSequenceNumber> checkpointsTableNameSequenceNumber;
        LogSequenceNumber _logSequenceNumber;
        LogSequenceNumber logSequenceNumber;
        long _start;
        block21: {
            Iterator<Object> _stop2;
            long lockStamp;
            if (this.virtual) {
                return null;
            }
            if (this.recoveryInProgress) {
                LOGGER.log(Level.INFO, "Checkpoint for tablespace {0} skipped. Recovery is still in progress", this.tableSpaceName);
                return null;
            }
            _start = System.currentTimeMillis();
            logSequenceNumber = null;
            _logSequenceNumber = null;
            checkpointsTableNameSequenceNumber = new HashMap<String, LogSequenceNumber>();
            try {
                block18: {
                    TableSpaceCheckpoint tableSpaceCheckpoint2;
                    block19: {
                        actions = new ArrayList<PostCheckpointAction>();
                        lockStamp = 0L;
                        if (!alreadLocked) {
                            lockStamp = this.acquireWriteLock("checkpoint");
                        }
                        logSequenceNumber = this.log.getLastSequenceNumber();
                        if (!logSequenceNumber.isStartOfTime()) break block18;
                        LOGGER.log(Level.INFO, "{0} checkpoint {1} at {2}. skipped (no write ever issued to log)", new Object[]{this.nodeId, this.tableSpaceName, logSequenceNumber});
                        tableSpaceCheckpoint2 = new TableSpaceCheckpoint(logSequenceNumber, checkpointsTableNameSequenceNumber);
                        if (alreadLocked) break block19;
                        this.releaseWriteLock(lockStamp, "checkpoint");
                    }
                    long _stop2 = System.currentTimeMillis();
                    LOGGER.log(Level.INFO, "{0} checkpoint finish {1} started ad {2}, finished at {3}, total time {4} ms", new Object[]{this.nodeId, this.tableSpaceName, logSequenceNumber, _logSequenceNumber, Long.toString(_stop2 - _start)});
                    this.checkpointTimeStats.registerSuccessfulEvent(_stop2, TimeUnit.MILLISECONDS);
                    return tableSpaceCheckpoint2;
                }
                LOGGER.log(Level.INFO, "{0} checkpoint start {1} at {2}", new Object[]{this.nodeId, this.tableSpaceName, logSequenceNumber});
                if (this.actualLogSequenceNumber == null) {
                    throw new DataStorageManagerException("actualLogSequenceNumber cannot be null");
                }
                ArrayList<Transaction> currentTransactions = new ArrayList<Transaction>(this.transactions.values());
                for (Transaction t : currentTransactions) {
                    LogSequenceNumber txLsn = t.lastSequenceNumber;
                    if (txLsn == null || !txLsn.after(logSequenceNumber)) continue;
                    LOGGER.log(Level.SEVERE, "Found transaction {0} with LSN {1} in the future", new Object[]{t.transactionId, txLsn});
                }
                actions.addAll(this.dataStorageManager.writeTransactionsAtCheckpoint(this.tableSpaceUUID, logSequenceNumber, currentTransactions));
                actions.addAll(this.writeTablesOnDataStorageManager(new CommitLogResult(logSequenceNumber, false, true), true));
                _stop2 = this.tables.values().iterator();
            }
            catch (Throwable throwable) {
                long _stop3 = System.currentTimeMillis();
                LOGGER.log(Level.INFO, "{0} checkpoint finish {1} started ad {2}, finished at {3}, total time {4} ms", new Object[]{this.nodeId, this.tableSpaceName, logSequenceNumber, _logSequenceNumber, Long.toString(_stop3 - _start)});
                this.checkpointTimeStats.registerSuccessfulEvent(_stop3, TimeUnit.MILLISECONDS);
                throw throwable;
            }
            while (_stop2.hasNext()) {
                AbstractTableManager.TableCheckpoint checkpoint;
                AbstractTableManager tableManager = (AbstractTableManager)_stop2.next();
                if (tableManager.isSystemTable() || (checkpoint = full ? tableManager.fullCheckpoint(pin) : tableManager.checkpoint(pin)) == null) continue;
                LOGGER.log(Level.INFO, "checkpoint done for table {0}.{1} (pin: {2})", new Object[]{this.tableSpaceName, tableManager.getTable().name, pin});
                actions.addAll(checkpoint.actions);
                checkpointsTableNameSequenceNumber.put(checkpoint.tableName, checkpoint.sequenceNumber);
                if (this.afterTableCheckPointAction == null) continue;
                this.afterTableCheckPointAction.run();
            }
            actions.addAll(this.dataStorageManager.writeCheckpointSequenceNumber(this.tableSpaceUUID, logSequenceNumber));
            if (this.leader) {
                this.log.dropOldLedgers(logSequenceNumber);
            }
            break block21;
            finally {
                if (!alreadLocked) {
                    this.releaseWriteLock(lockStamp, "checkpoint");
                }
            }
        }
        _logSequenceNumber = this.log.getLastSequenceNumber();
        for (PostCheckpointAction action : actions) {
            try {
                action.run();
            }
            catch (Exception error) {
                LOGGER.log(Level.SEVERE, "postcheckpoint error:" + error, error);
            }
        }
        TableSpaceCheckpoint tableSpaceCheckpoint = new TableSpaceCheckpoint(logSequenceNumber, checkpointsTableNameSequenceNumber);
        long _stop = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "{0} checkpoint finish {1} started ad {2}, finished at {3}, total time {4} ms", new Object[]{this.nodeId, this.tableSpaceName, logSequenceNumber, _logSequenceNumber, Long.toString(_stop - _start)});
        this.checkpointTimeStats.registerSuccessfulEvent(_stop, TimeUnit.MILLISECONDS);
        return tableSpaceCheckpoint;
    }

    private CompletableFuture<StatementExecutionResult> beginTransactionAsync(StatementEvaluationContext context, boolean releaseLock) throws StatementExecutionException {
        long id = this.newTransactionId.incrementAndGet();
        LogEntry entry = LogEntryFactory.beginTransaction(id);
        boolean lockAcquired = false;
        if (context.getTableSpaceLock() == 0L) {
            long lockStamp = this.acquireReadLock("begin transaction");
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        CommitLogResult pos = this.log.log(entry, false);
        CompletionStage res = pos.logSequenceNumber.thenApplyAsync(lsn -> {
            this.apply(pos, entry, false);
            return new TransactionResult(id, TransactionResult.OutcomeType.BEGIN);
        }, (Executor)this.callbacksExecutor);
        if (lockAcquired && releaseLock) {
            this.releaseReadLock((CompletableFuture<StatementExecutionResult>)res, context.getTableSpaceLock(), "begin transaction");
        }
        return res;
    }

    private CompletableFuture<StatementExecutionResult> rollbackTransaction(RollbackTransactionStatement statement, StatementEvaluationContext context) throws StatementExecutionException {
        long txId = statement.getTransactionId();
        this.validateTransactionBeforeTxCommand(txId);
        LogEntry entry = LogEntryFactory.rollbackTransaction(txId);
        long lockStamp = context.getTableSpaceLock();
        boolean lockAcquired = false;
        if (lockStamp == 0L) {
            lockStamp = this.acquireReadLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        CommitLogResult pos = this.log.log(entry, true);
        CompletionStage res = pos.logSequenceNumber.thenApplyAsync(lsn -> {
            this.apply(pos, entry, false);
            return new TransactionResult(txId, TransactionResult.OutcomeType.ROLLBACK);
        }, (Executor)this.callbacksExecutor);
        if (lockAcquired) {
            res = this.releaseReadLock((CompletableFuture<StatementExecutionResult>)res, lockStamp, statement).thenApply(s -> {
                context.setTableSpaceLock(0L);
                return s;
            });
        }
        return res;
    }

    private CompletableFuture<StatementExecutionResult> commitTransaction(CommitTransactionStatement statement, StatementEvaluationContext context) throws StatementExecutionException {
        long txId = statement.getTransactionId();
        this.validateTransactionBeforeTxCommand(txId);
        LogEntry entry = LogEntryFactory.commitTransaction(txId);
        long lockStamp = context.getTableSpaceLock();
        boolean lockAcquired = false;
        if (lockStamp == 0L) {
            lockStamp = this.acquireReadLock(statement);
            context.setTableSpaceLock(lockStamp);
            lockAcquired = true;
        }
        CommitLogResult pos = this.log.log(entry, true);
        CompletionStage res = pos.logSequenceNumber.handleAsync((lsn, error) -> {
            if (error == null) {
                this.apply(pos, entry, false);
                return new TransactionResult(txId, TransactionResult.OutcomeType.COMMIT);
            }
            LogEntry rollback = LogEntryFactory.rollbackTransaction(txId);
            this.apply(new CommitLogResult(LogSequenceNumber.START_OF_TIME, false, false), rollback, false);
            throw new CompletionException((Throwable)error);
        }, (Executor)this.callbacksExecutor);
        if (lockAcquired) {
            res = this.releaseReadLock((CompletableFuture<StatementExecutionResult>)res, lockStamp, statement).thenApply(s -> {
                context.setTableSpaceLock(0L);
                return s;
            });
        }
        return res;
    }

    private void validateTransactionBeforeTxCommand(long txId) throws StatementExecutionException {
        this.validateTransactionBeforeTxCommand(txId, true);
    }

    private boolean validateTransactionBeforeTxCommand(long txId, boolean wait) throws StatementExecutionException {
        Transaction tc = this.transactions.get(txId);
        if (tc == null) {
            throw new StatementExecutionException("no such transaction " + txId + " in tablespace " + this.tableSpaceName);
        }
        while (tc.hasPendingActivities() && !this.closed) {
            LOGGER.log(Level.INFO, "Transaction {0} ({1}) has {2} pending activities", new Object[]{txId, this.tableSpaceName, tc.getRefCount()});
            if (!ENABLE_PENDING_TRANSACTION_CHECK) {
                return true;
            }
            if (!wait) {
                return false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new StatementExecutionException("Error while waiting for pending activities of transaction " + txId + " in " + this.tableSpaceName, ex);
            }
        }
        if (this.closed) {
            throw new StatementExecutionException("tablespace closed during commit of transaction " + txId + " in tablespace " + this.tableSpaceName);
        }
        return true;
    }

    private CompletableFuture<StatementExecutionResult> releaseReadLock(CompletableFuture<StatementExecutionResult> promise, long lockStamp, Object description) {
        return promise.whenComplete((r, error) -> this.releaseReadLock(lockStamp, description));
    }

    private void releaseReadLock(long lockStamp, Object description) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "{0} ts {2} relrlock {1}", new Object[]{this.tableSpaceName, description, lockStamp});
        }
        this.generalLock.unlockRead(lockStamp);
    }

    public boolean isLeader() {
        return this.leader;
    }

    public Transaction getTransaction(long transactionId) {
        if (transactionId <= 0L) {
            return null;
        }
        return this.transactions.get(transactionId);
    }

    public AbstractTableManager getTableManager(String tableName) {
        return this.tables.get(tableName);
    }

    public Collection<Long> getOpenTransactions() {
        return new HashSet<Long>(this.transactions.keySet());
    }

    public List<Transaction> getTransactions() {
        return new ArrayList<Transaction>(this.transactions.values());
    }

    public DBManager getDbmanager() {
        return this.dbmanager;
    }

    public TableSpaceManagerStats getStats() {
        return this.stats;
    }

    public CommitLog getLog() {
        return this.log;
    }

    public ExecutorService getCallbacksExecutor() {
        return this.callbacksExecutor;
    }

    public String toString() {
        return "TableSpaceManager [nodeId=" + this.nodeId + ", tableSpaceName=" + this.tableSpaceName + ", tableSpaceUUID=" + this.tableSpaceUUID + "]";
    }

    private static /* synthetic */ void lambda$dumpTableSpace$6(String dumpId, Throwable error) {
        if (error != null) {
            LOGGER.log(Level.SEVERE, "Cannot send last dump msg for " + dumpId, error);
        } else {
            LOGGER.log(Level.INFO, "Sent last dump msg for " + dumpId);
        }
    }

    private class ApplyEntryOnRecovery
    implements BiConsumer<LogSequenceNumber, LogEntry> {
        @Override
        public void accept(LogSequenceNumber t, LogEntry u) {
            if (TableSpaceManager.this.dbmanager.isStopped()) {
                throw new RuntimeException("System was requested to stop, aborting recovery at " + t);
            }
            try {
                TableSpaceManager.this.apply(new CommitLogResult(t, false, true), u, true);
            }
            catch (DDLException | DataStorageManagerException err) {
                throw new RuntimeException((Throwable)err);
            }
        }
    }

    private static class TableSpaceCheckpoint {
        private final LogSequenceNumber sequenceNumber;
        private final Map<String, LogSequenceNumber> tablesCheckpoints;

        public TableSpaceCheckpoint(LogSequenceNumber sequenceNumber, Map<String, LogSequenceNumber> tablesCheckpoints) {
            this.sequenceNumber = sequenceNumber;
            this.tablesCheckpoints = tablesCheckpoints;
        }

        static /* synthetic */ LogSequenceNumber access$000(TableSpaceCheckpoint x0) {
            return x0.sequenceNumber;
        }

        static /* synthetic */ Map access$100(TableSpaceCheckpoint x0) {
            return x0.tablesCheckpoints;
        }
    }

    private class FollowerThread
    implements Runnable {
        private volatile CountDownLatch running = new CountDownLatch(1);

        private FollowerThread() {
        }

        public String toString() {
            return "FollowerThread{" + TableSpaceManager.this.tableSpaceName + '}';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (Object context = TableSpaceManager.this.log.startFollowing(TableSpaceManager.this.actualLogSequenceNumber);){
                while (!TableSpaceManager.this.isLeader() && !TableSpaceManager.this.closed) {
                    long readLock = TableSpaceManager.this.acquireReadLock("follow");
                    try {
                        TableSpaceManager.this.log.followTheLeader(TableSpaceManager.this.actualLogSequenceNumber, (num, u) -> {
                            try {
                                TableSpaceManager.this.apply(new CommitLogResult(num, false, true), u, false);
                            }
                            catch (Throwable t) {
                                throw new RuntimeException(t);
                            }
                            return !TableSpaceManager.this.isLeader() && !TableSpaceManager.this.closed;
                        }, (CommitLog.FollowerContext)context);
                    }
                    finally {
                        TableSpaceManager.this.releaseReadLock(readLock, "follow");
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "follower error " + TableSpaceManager.this.tableSpaceName, t);
                TableSpaceManager.this.setFailed();
            }
            finally {
                this.running.countDown();
            }
        }

        void waitForStop() throws InterruptedException {
            LOGGER.log(Level.INFO, "Waiting for FollowerThread of {0} to stop", TableSpaceManager.this.tableSpaceName);
            this.running.await();
            LOGGER.log(Level.INFO, "FollowerThread of {0} stopped", TableSpaceManager.this.tableSpaceName);
        }
    }

    private static class CheckpointFuture
    extends CompletableFuture {
        private final String tableName;

        public CheckpointFuture(String tableName) {
            this.tableName = tableName;
        }

        public int hashCode() {
            int hash = 5;
            hash = 31 * hash + Objects.hashCode(this.tableName);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CheckpointFuture other = (CheckpointFuture)obj;
            return Objects.equals(this.tableName, other.tableName);
        }
    }
}

