/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.AbstractTableManager;
import herddb.core.HerdDBInternalException;
import herddb.core.stats.TableManagerStats;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Table;
import herddb.network.Channel;
import herddb.proto.Pdu;
import herddb.proto.PduCodec;
import herddb.storage.FullTableScanConsumer;
import herddb.storage.TableStatus;
import herddb.utils.KeyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

class SingleTableDumper
implements FullTableScanConsumer {
    private final AbstractTableManager tableManager;
    private final Channel channel;
    private final String dumpId;
    private final String tableSpaceName;
    private final int timeout;
    private final int fetchSize;
    private final List<KeyValue> batch = new ArrayList<KeyValue>();

    public SingleTableDumper(String tableSpaceName, AbstractTableManager tableManager, Channel channel, String dumpId, int timeout, int fetchSize) {
        this.tableSpaceName = tableSpaceName;
        this.tableManager = tableManager;
        this.channel = channel;
        this.dumpId = dumpId;
        this.timeout = timeout;
        this.fetchSize = fetchSize;
    }

    @Override
    public void acceptTableStatus(TableStatus tableStatus) {
        try {
            Table table = this.tableManager.getTable();
            byte[] tableDefinition = table.serialize();
            TableManagerStats stats = this.tableManager.getStats();
            List indexes = this.tableManager.getAvailableIndexes().stream().map(Index::serialize).collect(Collectors.toList());
            long id = this.channel.generateRequestId();
            Pdu pdu = this.channel.sendMessageWithPduReply(id, PduCodec.TablespaceDumpData.write((long)id, (String)this.tableSpaceName, (String)this.dumpId, (String)"beginTable", (byte[])tableDefinition, (long)stats.getTablesize(), (long)tableStatus.sequenceNumber.ledgerId, (long)tableStatus.sequenceNumber.offset, indexes, null), (long)this.timeout);
            if (pdu != null) {
                pdu.close();
            }
        }
        catch (InterruptedException | TimeoutException err) {
            throw new HerdDBInternalException((Throwable)err);
        }
    }

    @Override
    public void acceptPage(long pageId, List<Record> records) {
        try {
            for (Record record : records) {
                this.batch.add(new KeyValue(record.key, record.value));
                if (this.batch.size() != this.fetchSize) continue;
                this.sendBatch();
            }
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    @Override
    public void endTable() {
        try {
            long id;
            Pdu pdu;
            if (!this.batch.isEmpty()) {
                this.sendBatch();
            }
            if ((pdu = this.channel.sendMessageWithPduReply(id = this.channel.generateRequestId(), PduCodec.TablespaceDumpData.write((long)id, (String)this.tableSpaceName, (String)this.dumpId, (String)"endTable", null, (long)0L, (long)0L, (long)0L, null, null), (long)this.timeout)) != null) {
                pdu.close();
            }
        }
        catch (Exception error) {
            throw new RuntimeException(error);
        }
    }

    private void sendBatch() throws TimeoutException, InterruptedException {
        long id = this.channel.generateRequestId();
        Pdu pdu = this.channel.sendMessageWithPduReply(id, PduCodec.TablespaceDumpData.write((long)id, (String)this.tableSpaceName, (String)this.dumpId, (String)"data", null, (long)0L, (long)0L, (long)0L, null, this.batch), (long)this.timeout);
        if (pdu != null) {
            pdu.close();
        }
        this.batch.clear();
    }
}

