/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.RunningStatementInfo;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.StatsLogger;

public class RunningStatementsStats {
    private final ConcurrentHashMap<Long, RunningStatementInfo> runningStatements = new ConcurrentHashMap();
    private final StatsLogger mainStatsLogger;

    RunningStatementsStats(StatsLogger mainStatsLogger) {
        this.mainStatsLogger = mainStatsLogger;
        this.mainStatsLogger.registerGauge("runningstatements", (Gauge)new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return RunningStatementsStats.this.runningStatements.size();
            }
        });
    }

    public void registerRunningStatement(RunningStatementInfo info) {
        this.runningStatements.put(info.getId(), info);
    }

    public void unregisterRunningStatement(RunningStatementInfo info) {
        this.runningStatements.remove(info.getId());
    }

    public ConcurrentHashMap<Long, RunningStatementInfo> getRunningStatements() {
        return this.runningStatements;
    }
}

