/*
 * Decompiled with CFR 0.152.
 */
package herddb.codec;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.codec.RecordSerializer;
import herddb.model.Column;
import herddb.model.Record;
import herddb.model.Table;
import herddb.utils.AbstractDataAccessor;
import herddb.utils.ByteArrayCursor;
import herddb.utils.Bytes;
import herddb.utils.RawString;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class DataAccessorForFullRecord
extends AbstractDataAccessor {
    private final Table table;
    private final Record record;

    public DataAccessorForFullRecord(Table table, Record record) {
        this.table = table;
        this.record = record;
    }

    public Object get(String property) {
        try {
            if (this.table.isPrimaryKeyColumn(property)) {
                return RecordSerializer.accessRawDataFromPrimaryKey(property, this.record.key, this.table);
            }
            return RecordSerializer.accessRawDataFromValue(property, this.record.value, this.table);
        }
        catch (IOException err) {
            throw new IllegalStateException("bad data:" + err, err);
        }
    }

    public Object get(int index) {
        try {
            if (this.table.isPrimaryKeyColumn(index)) {
                return RecordSerializer.accessRawDataFromPrimaryKey(index, this.record.key, this.table);
            }
            return RecordSerializer.accessRawDataFromValue(index, this.record.value, this.table);
        }
        catch (IOException err) {
            throw new IllegalStateException("bad data:" + err, err);
        }
    }

    public boolean fieldEqualsTo(int index, Object value) {
        try {
            if (this.table.isPrimaryKeyColumn(index)) {
                return RecordSerializer.compareRawDataFromPrimaryKey(index, this.record.key, this.table, value) == 0;
            }
            return RecordSerializer.compareRawDataFromValue(index, this.record.value, this.table, value) == 0;
        }
        catch (IOException err) {
            throw new IllegalStateException("bad data:" + err, err);
        }
    }

    public int fieldCompareTo(int index, Object value) {
        try {
            if (this.table.isPrimaryKeyColumn(index)) {
                return RecordSerializer.compareRawDataFromPrimaryKey(index, this.record.key, this.table, value);
            }
            return RecordSerializer.compareRawDataFromValue(index, this.record.value, this.table, value);
        }
        catch (IOException err) {
            throw new IllegalStateException("bad data:" + err, err);
        }
    }

    public int getNumFields() {
        return this.table.columns.length;
    }

    public String[] getFieldNames() {
        return this.table.columnNames;
    }

    public Map<String, Object> toMap() {
        return this.record.toBean(this.table);
    }

    public void forEach(BiConsumer<String, Object> consumer) {
        if (this.table.physicalLayoutLikeLogicalLayout) {
            ByteArrayCursor din;
            if (this.table.primaryKey.length == 1) {
                String pkField = this.table.primaryKey[0];
                Object object = RecordSerializer.deserialize(this.record.key, this.table.getColumn((String)pkField).type);
                consumer.accept(pkField, object);
                if (object instanceof RawString) {
                    ((RawString)object).recycle();
                }
            } else {
                try {
                    din = this.record.key.newCursor();
                    try {
                        for (String primaryKeyColumn : this.table.primaryKey) {
                            Bytes value = din.readBytesNoCopy();
                            Object theValue = RecordSerializer.deserialize(value, this.table.getColumn((String)primaryKeyColumn).type);
                            consumer.accept(primaryKeyColumn, theValue);
                            if (!(theValue instanceof RawString)) continue;
                            ((RawString)theValue).recycle();
                        }
                    }
                    finally {
                        if (din != null) {
                            din.close();
                        }
                    }
                }
                catch (IOException err) {
                    throw new IllegalStateException("bad data:" + err, err);
                }
            }
            try {
                din = this.record.value.newCursor();
                try {
                    while (!din.isEof()) {
                        int n = din.readVIntNoEOFException();
                        if (din.isEof()) {
                        }
                        Column col = this.table.getColumnBySerialPosition(n);
                        if (col != null) {
                            Object value = RecordSerializer.deserializeTypeAndValue(din);
                            consumer.accept(col.name, value);
                            continue;
                        }
                        RecordSerializer.skipTypeAndValue(din);
                    }
                }
                finally {
                    if (din != null) {
                        din.close();
                    }
                }
            }
            catch (IOException err) {
                throw new IllegalStateException("bad data:" + err, err);
            }
        } else {
            for (int i = 0; i < this.table.columnNames.length; ++i) {
                String string = this.table.columnNames[i];
                Object value = this.get(i);
                consumer.accept(string, value);
                if (!(value instanceof RawString)) continue;
                ((RawString)value).recycle();
            }
        }
    }

    public Object[] getValues() {
        return super.getValues();
    }

    public String toString() {
        return "DataAccessorForFullRecord{record=" + this.record + '}';
    }

    public Record getRecord() {
        return this.record;
    }
}

