/*
 * Decompiled with CFR 0.152.
 */
package herddb.backup;

import herddb.backup.DumpedLogEntry;
import herddb.backup.DumpedTableMetadata;
import herddb.backup.ProgressListener;
import herddb.client.TableSpaceDumpReceiver;
import herddb.log.LogSequenceNumber;
import herddb.model.Index;
import herddb.model.Record;
import herddb.model.Table;
import herddb.model.Transaction;
import herddb.storage.DataStorageManagerException;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.Holder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

class TableSpaceDumpFileWriter
extends TableSpaceDumpReceiver {
    private final ProgressListener listener;
    private final Holder<Throwable> errorHolder;
    private final CountDownLatch waiter;
    private final String schema;
    private final ExtendedDataOutputStream out;
    long tableRecordsCount;
    String currentTable;

    public TableSpaceDumpFileWriter(ProgressListener listener, Holder<Throwable> errorHolder, CountDownLatch waiter, String schema, ExtendedDataOutputStream out) {
        this.listener = listener;
        this.errorHolder = errorHolder;
        this.waiter = waiter;
        this.schema = schema;
        this.out = out;
    }

    @Override
    public void onError(Throwable error) throws DataStorageManagerException {
        this.listener.log("error", "Fatal error: " + error, Collections.singletonMap("error", error));
        this.errorHolder.value = error;
        this.waiter.countDown();
    }

    @Override
    public void finish(LogSequenceNumber logSequenceNumber) throws DataStorageManagerException {
        this.listener.log("finish", "Dump finished for tablespace " + this.schema + " at " + logSequenceNumber, Collections.singletonMap("tablespace", this.schema));
        try {
            this.out.writeUTF("end");
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
        this.waiter.countDown();
    }

    @Override
    public void endTable() throws DataStorageManagerException {
        this.listener.log("endTable", "endTable " + this.currentTable + ", records " + this.tableRecordsCount, Collections.singletonMap("table", this.currentTable));
        this.currentTable = null;
        try {
            this.out.writeVInt(Integer.MIN_VALUE);
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public void receiveTableDataChunk(List<Record> record) throws DataStorageManagerException {
        try {
            this.out.writeVInt(record.size());
            for (Record r : record) {
                this.out.writeArray(r.key);
                this.out.writeArray(r.value);
            }
            this.tableRecordsCount += (long)record.size();
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
        this.listener.log("receivedata", "table " + this.currentTable + ", dumped " + this.tableRecordsCount + " records", Collections.singletonMap("count", this.tableRecordsCount));
    }

    @Override
    public void beginTable(DumpedTableMetadata tableMetadata, Map<String, Object> stats) throws DataStorageManagerException {
        Table table = tableMetadata.table;
        this.currentTable = table.name;
        this.listener.log("beginTable", "beginTable " + this.currentTable + ", stats " + stats, Collections.singletonMap("table", table.name));
        try {
            this.out.writeUTF("table");
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
        this.tableRecordsCount = 0L;
        try {
            this.out.writeLong(tableMetadata.logSequenceNumber.ledgerId);
            this.out.writeLong(tableMetadata.logSequenceNumber.offset);
            this.out.writeArray(table.serialize());
            this.out.writeInt(tableMetadata.indexes.size());
            for (Index index : tableMetadata.indexes) {
                this.out.writeArray(index.serialize());
            }
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public void start(LogSequenceNumber logSequenceNumber) throws DataStorageManagerException {
        this.listener.log("start_tablespace", "dumping tablespace " + this.schema + ", log position " + logSequenceNumber, Collections.singletonMap("tablespace", this.schema));
        try {
            this.out.writeUTF("start");
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
    }

    @Override
    public void receiveTransactionLogChunk(List<DumpedLogEntry> entries) throws DataStorageManagerException {
        try {
            this.out.writeUTF("txlogchunk");
            this.out.writeVInt(entries.size());
            for (DumpedLogEntry entry : entries) {
                this.out.writeVLong(entry.logSequenceNumber.ledgerId);
                this.out.writeVLong(entry.logSequenceNumber.offset);
                this.out.writeArray(entry.entryData);
            }
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
        this.listener.log("receivetxlog", "dumped " + entries.size() + " txlogentries", Collections.singletonMap("count", entries.size()));
    }

    @Override
    public void receiveTransactionsAtDump(List<Transaction> entries) throws DataStorageManagerException {
        try {
            this.out.writeUTF("transactions");
            this.out.writeVInt(entries.size());
            for (Transaction entry : entries) {
                this.out.writeArray(entry.serialize());
            }
        }
        catch (IOException err) {
            throw new DataStorageManagerException(err);
        }
        this.listener.log("receivetransactions", "dumped " + entries.size() + " txentries", Collections.singletonMap("count", entries.size()));
    }
}

