/*
 * Decompiled with CFR 0.152.
 */
package herddb.backup;

import herddb.backup.ProgressListener;
import herddb.backup.TableSpaceDumpFileWriter;
import herddb.backup.TableSpaceRestoreSourceFromFile;
import herddb.client.HDBConnection;
import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.Holder;
import herddb.utils.NonClosingInputStream;
import herddb.utils.NonClosingOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;

public class BackupUtils {
    public static void dumpTableSpace(String schema, int fetchSize, HDBConnection connection, OutputStream fout, ProgressListener listener) throws Exception {
        try (NonClosingOutputStream nos = new NonClosingOutputStream(fout);
             ExtendedDataOutputStream eos = new ExtendedDataOutputStream((OutputStream)nos);){
            BackupUtils.dumpTablespace(schema, fetchSize, connection, eos, listener);
        }
    }

    private static void dumpTablespace(String schema, int fetchSize, HDBConnection hdbconnection, ExtendedDataOutputStream out, ProgressListener listener) throws Exception {
        Holder errorHolder = new Holder();
        CountDownLatch waiter = new CountDownLatch(1);
        hdbconnection.dumpTableSpace(schema, new TableSpaceDumpFileWriter(listener, (Holder<Throwable>)errorHolder, waiter, schema, out), fetchSize, true);
        if (errorHolder.value != null) {
            throw new Exception((Throwable)errorHolder.value);
        }
        waiter.await();
    }

    public static void restoreTableSpace(String schema, String node, HDBConnection hdbconnection, InputStream fin, ProgressListener listener) throws Exception {
        try (NonClosingInputStream nis = new NonClosingInputStream(fin);
             ExtendedDataInputStream eis = new ExtendedDataInputStream((InputStream)nis);){
            BackupUtils.restoreTableSpace(schema, node, hdbconnection, eis, listener);
        }
    }

    public static void restoreTableSpace(String schema, String node, HDBConnection hdbconnection, ExtendedDataInputStream in, ProgressListener listener) throws Exception {
        listener.log("startRestore", "creating tablespace " + schema + " with leader " + node, Collections.singletonMap("tablespace", schema));
        hdbconnection.executeUpdate("herd", "CREATE TABLESPACE '" + schema + "','leader:" + node + "','wait:60000'", 0L, false, false, Collections.emptyList());
        TableSpaceRestoreSourceFromFile source = new TableSpaceRestoreSourceFromFile(in, listener);
        hdbconnection.restoreTableSpace(schema, source);
        listener.log("restoreFinished", "restore finished for tablespace " + schema, Collections.singletonMap("tablespace", schema));
    }
}

