/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import io.netty.channel.epoll.Epoll;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class NetworkUtils {
    private static final boolean ENABLE_EPOOL_NATIVE = System.getProperty("os.name").equalsIgnoreCase("linux") && !Boolean.getBoolean("herddb.network.disablenativeepoll") && Epoll.isAvailable();

    public static boolean isEnableEpoolNative() {
        return ENABLE_EPOOL_NATIVE;
    }

    public static String getAddress(InetSocketAddress address) {
        if (address.getAddress() != null) {
            return address.getAddress().getHostAddress();
        }
        return address.getHostName();
    }

    public static int assignFirstFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static String getLocalNetworkAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }
}

