/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import herddb.network.ChannelEventListener;
import herddb.network.netty.ClientInboundMessageHandler;
import herddb.network.netty.LocalServerRegistry;
import herddb.network.netty.NettyChannel;
import herddb.network.netty.NetworkUtils;
import herddb.network.netty.ProtocolMessageDecoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NettyConnector {
    private static final Logger LOGGER = Logger.getLogger(NettyConnector.class.getName());

    public static NettyChannel connect(final String host, final int port, final boolean ssl, int connectTimeout, final int socketTimeout, final ChannelEventListener receiver, final ExecutorService callbackExecutor, MultithreadEventLoopGroup networkGroup, DefaultEventLoopGroup localEventsGroup) throws IOException {
        try {
            MultithreadEventLoopGroup group;
            InetSocketAddress address;
            Class<LocalChannel> channelType;
            final SslContext sslCtx = !ssl ? null : SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            InetSocketAddress inet = new InetSocketAddress(host, port);
            String hostAddress = NetworkUtils.getAddress(inet);
            if (LocalServerRegistry.isLocalServer(hostAddress, port, ssl)) {
                channelType = LocalChannel.class;
                address = new LocalAddress(hostAddress + ":" + port + ":" + ssl);
                group = localEventsGroup;
            } else {
                channelType = networkGroup instanceof EpollEventLoopGroup ? EpollSocketChannel.class : NioSocketChannel.class;
                address = inet;
                group = networkGroup;
            }
            Bootstrap b = new Bootstrap();
            final AtomicReference result = new AtomicReference();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(channelType)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).option(ChannelOption.SO_TIMEOUT, (Object)socketTimeout)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel ch) throws Exception {
                    try {
                        NettyChannel channel = new NettyChannel(host + ":" + port, ch, callbackExecutor);
                        result.set(channel);
                        channel.setMessagesReceiver(receiver);
                        if (ssl) {
                            ch.pipeline().addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                        }
                        if (socketTimeout > 0) {
                            ch.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(socketTimeout));
                        }
                        ch.pipeline().addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
                        ch.pipeline().addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
                        ch.pipeline().addLast("messagedecoder", (ChannelHandler)new ProtocolMessageDecoder());
                        ch.pipeline().addLast(new ChannelHandler[]{new ClientInboundMessageHandler(channel)});
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.SEVERE, "error connecting", t);
                        ch.close();
                    }
                }
            });
            LOGGER.log(Level.FINE, "connecting to {0}:{1} ssl={2} address={3}", new Object[]{host, port, ssl, address});
            b.connect((SocketAddress)address).sync();
            NettyChannel nettyChannel = (NettyChannel)result.get();
            if (!nettyChannel.isValid()) {
                throw new IOException("returned channel is not valid");
            }
            return nettyChannel;
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }
}

