/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import herddb.network.Channel;
import herddb.network.SendResultCallback;
import herddb.proto.Pdu;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongHashMap;

public class NettyChannel
extends Channel {
    volatile io.netty.channel.Channel socket;
    private static final Logger LOGGER = Logger.getLogger(NettyChannel.class.getName());
    public static final String ADDRESS_JVM_LOCAL = "jvm-local";
    private static final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentLongHashMap<Channel.PduCallback> callbacks = new ConcurrentLongHashMap();
    private final ConcurrentLongLongHashMap pendingReplyMessagesDeadline = new ConcurrentLongLongHashMap();
    private final ExecutorService callbackexecutor;
    private boolean ioErrors = false;
    private final long id = idGenerator.incrementAndGet();
    private final String remoteAddress;
    private final AtomicInteger unflushedWrites = new AtomicInteger();
    private volatile boolean closed = false;

    public String toString() {
        return "NettyChannel{name=" + this.name + ", id=" + this.id + ", socket=" + this.socket + " pending " + this.callbacks.size() + " msgs}";
    }

    public NettyChannel(String name, io.netty.channel.Channel socket, ExecutorService callbackexecutor) {
        this.name = name;
        this.socket = socket;
        this.callbackexecutor = callbackexecutor;
        this.remoteAddress = socket instanceof SocketChannel ? ((SocketChannel)socket).remoteAddress() + "" : ADDRESS_JVM_LOCAL;
    }

    public long getId() {
        return this.id;
    }

    public void pduReceived(Pdu message) {
        if (message.isRequest()) {
            this.handlePduRequest(message);
        } else {
            this.handlePduResponse(message);
        }
    }

    private void handlePduRequest(Pdu request) {
        this.submitCallback(() -> {
            try {
                this.messagesReceiver.requestReceived(request, this);
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, this + ": error " + t, t);
                this.close();
            }
        });
    }

    private void handlePduResponse(Pdu pdu) {
        long replyMessageId = pdu.messageId;
        if (replyMessageId < 0L) {
            LOGGER.log(Level.SEVERE, "{0}: received response without replyId: type {1}", new Object[]{this, pdu.messageId});
            pdu.close();
            return;
        }
        Channel.PduCallback callback = (Channel.PduCallback)this.callbacks.remove(replyMessageId);
        this.pendingReplyMessagesDeadline.remove(replyMessageId);
        if (callback != null) {
            this.submitCallback(() -> callback.responseReceived(pdu, null));
        }
    }

    @Override
    public void sendOneWayMessage(ByteBuf message, final SendResultCallback callback) {
        io.netty.channel.Channel _socket = this.socket;
        if (_socket == null || !_socket.isOpen()) {
            callback.messageSent(new Exception(this + " connection is closed"));
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder dumper = new StringBuilder();
            ByteBufUtil.appendPrettyHexDump((StringBuilder)dumper, (ByteBuf)message);
            LOGGER.log(Level.FINEST, "Sending to {}: {}", new Object[]{_socket, dumper});
        }
        _socket.writeAndFlush((Object)message).addListener(new GenericFutureListener(){

            public void operationComplete(Future future) throws Exception {
                if (future.isSuccess()) {
                    callback.messageSent(null);
                } else {
                    LOGGER.log(Level.SEVERE, this + ": error " + future.cause(), future.cause());
                    callback.messageSent(future.cause());
                    NettyChannel.this.close();
                }
            }
        });
        this.unflushedWrites.incrementAndGet();
    }

    @Override
    public void sendReplyMessage(long inAnswerTo, ByteBuf message) {
        if (this.socket == null) {
            LOGGER.log(Level.SEVERE, this + " channel not active, discarding reply message " + message);
            return;
        }
        this.sendOneWayMessage(message, new SendResultCallback(){

            @Override
            public void messageSent(Throwable error) {
                if (error != null) {
                    LOGGER.log(Level.SEVERE, this + " error:" + error, error);
                }
            }
        });
    }

    private void processPendingReplyMessagesDeadline() {
        ArrayList messagesWithNoReply = new ArrayList();
        long now = System.currentTimeMillis();
        this.pendingReplyMessagesDeadline.forEach((messageId, deadline) -> {
            if (deadline < now) {
                messagesWithNoReply.add(messageId);
            }
        });
        if (messagesWithNoReply.isEmpty()) {
            return;
        }
        LOGGER.log(Level.SEVERE, "{0} found {1} without reply, channel will be closed", new Object[]{this, messagesWithNoReply});
        this.ioErrors = true;
        Iterator iterator = messagesWithNoReply.iterator();
        while (iterator.hasNext()) {
            long messageId2 = (Long)iterator.next();
            Channel.PduCallback callback = (Channel.PduCallback)this.callbacks.remove(messageId2);
            if (callback == null) continue;
            this.submitCallback(() -> callback.responseReceived(null, new IOException(this + " reply timeout expired, channel will be closed")));
        }
        this.close();
    }

    @Override
    public void sendRequestWithAsyncReply(long id, final ByteBuf message, long timeout, final Channel.PduCallback callback) {
        if (!this.isValid()) {
            callback.responseReceived(null, new Exception(this + " connection is not active"));
            return;
        }
        this.pendingReplyMessagesDeadline.put(id, System.currentTimeMillis() + timeout);
        this.callbacks.put(id, (Object)callback);
        this.sendOneWayMessage(message, new SendResultCallback(){

            @Override
            public void messageSent(Throwable error) {
                if (error != null) {
                    LOGGER.log(Level.SEVERE, this + ": error while sending reply message to " + message, error);
                    callback.responseReceived(null, new Exception(this + ": error while sending reply message to " + message, error));
                }
            }
        });
    }

    @Override
    public boolean isValid() {
        io.netty.channel.Channel _socket = this.socket;
        return _socket != null && _socket.isOpen() && !this.ioErrors;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        LOGGER.log(Level.FINE, "{0}: closing", this);
        String socketDescription = this.socket + "";
        if (this.socket != null) {
            try {
                this.socket.close().await();
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.socket = null;
            }
        }
        this.failPendingMessages(socketDescription);
    }

    private void failPendingMessages(String socketDescription) {
        this.callbacks.forEach((key, callback) -> {
            this.pendingReplyMessagesDeadline.remove(key);
            LOGGER.log(Level.SEVERE, "{0} message {1} was not replied callback:{2}", new Object[]{this, key, callback});
            this.submitCallback(() -> callback.responseReceived(null, new IOException("comunication channel is closed. Cannot wait for pending messages, socket=" + socketDescription)));
        });
        this.pendingReplyMessagesDeadline.clear();
        this.callbacks.clear();
    }

    void exceptionCaught(Throwable cause) {
        LOGGER.log(Level.SEVERE, this + " io-error " + cause, cause);
        this.ioErrors = true;
    }

    void channelClosed() {
        this.failPendingMessages(this.socket + "");
        this.submitCallback(() -> {
            if (this.messagesReceiver != null) {
                this.messagesReceiver.channelClosed(this);
            }
        });
    }

    private void submitCallback(Runnable runnable) {
        try {
            this.callbackexecutor.submit(runnable);
        }
        catch (RejectedExecutionException stopped) {
            LOGGER.log(Level.SEVERE, this + " rejected runnable " + runnable + ":" + stopped);
            try {
                runnable.run();
            }
            catch (Throwable error) {
                LOGGER.log(Level.SEVERE, this + " error on rejected runnable " + runnable + ":" + error);
            }
        }
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void channelIdle() {
        LOGGER.log(Level.FINEST, "{0} channelIdle", this);
        this.processPendingReplyMessagesDeadline();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public io.netty.channel.Channel getSocket() {
        return this.socket;
    }
}

