/*
 * Decompiled with CFR 0.152.
 */
package herddb.network;

import herddb.network.ChannelEventListener;
import herddb.network.SendResultCallback;
import herddb.proto.Pdu;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Channel
implements AutoCloseable {
    protected ChannelEventListener messagesReceiver;
    protected String name = "unnamed";
    private static final AtomicLong requestIdGeneator = new AtomicLong();

    public ChannelEventListener getMessagesReceiver() {
        return this.messagesReceiver;
    }

    public void setMessagesReceiver(ChannelEventListener messagesReceiver) {
        this.messagesReceiver = messagesReceiver;
    }

    public abstract void sendOneWayMessage(ByteBuf var1, SendResultCallback var2);

    public abstract void sendReplyMessage(long var1, ByteBuf var3);

    public abstract void sendRequestWithAsyncReply(long var1, ByteBuf var3, long var4, PduCallback var6);

    public abstract void channelIdle();

    public abstract String getRemoteAddress();

    @Override
    public abstract void close();

    public final long generateRequestId() {
        return requestIdGeneator.incrementAndGet();
    }

    public Pdu sendMessageWithPduReply(long id, ByteBuf request, long timeout) throws InterruptedException, TimeoutException {
        CompletableFuture resp = new CompletableFuture();
        long _start = System.currentTimeMillis();
        this.sendRequestWithAsyncReply(id, request, timeout, (message1, error) -> {
            if (error != null) {
                resp.completeExceptionally(error);
            } else {
                resp.complete(message1);
            }
        });
        try {
            return (Pdu)resp.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException err) {
            if (err.getCause() instanceof IOException) {
                TimeoutException te = new TimeoutException("io-error while waiting for reply from " + this.getRemoteAddress() + ": " + err.getCause());
                te.initCause(err.getCause());
                throw te;
            }
            throw new RuntimeException("Error " + err + " while talking to " + this.getRemoteAddress(), err.getCause());
        }
        catch (TimeoutException timeoutException) {
            long _stop = System.currentTimeMillis();
            TimeoutException err = new TimeoutException("Request timedout (" + (_stop - _start) / 1000L + "s). Slow server " + this.getRemoteAddress() + " or internal error");
            err.initCause(timeoutException);
            throw err;
        }
    }

    public abstract boolean isValid();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static interface PduCallback {
        public void responseReceived(Pdu var1, Throwable var2);
    }
}

