/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.core.HerdDBInternalException;
import herddb.utils.RawString;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface SQLRecordPredicateFunctions {
    public static boolean toBoolean(Object result) {
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return "true".equalsIgnoreCase(result.toString());
    }

    public static int compareNullTo(Object b) {
        if (b == null) {
            return 0;
        }
        return 1;
    }

    public static int compare(Object a, Object b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return 1;
        }
        if (b == null) {
            return -1;
        }
        if (a instanceof RawString && b instanceof RawString) {
            return ((RawString)a).compareTo((RawString)b);
        }
        if (a instanceof RawString && b instanceof String) {
            return ((RawString)a).compareToString((String)b);
        }
        if (a instanceof String && b instanceof RawString) {
            return -((RawString)b).compareToString((String)a);
        }
        if (a instanceof Integer && b instanceof Integer) {
            return (Integer)a - (Integer)b;
        }
        if (a instanceof Long && b instanceof Long) {
            double delta = (Long)a - (Long)b;
            return delta == 0.0 ? 0 : (delta > 0.0 ? 1 : -1);
        }
        if (a instanceof Number && b instanceof Number) {
            return Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue());
        }
        if (a instanceof Date && b instanceof Date) {
            long delta = ((Date)a).getTime() - ((Date)b).getTime();
            return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
        }
        if (a instanceof Date && b instanceof Long) {
            long delta = ((Date)a).getTime() - (Long)b;
            return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
        }
        if (a instanceof Long && b instanceof Date) {
            long delta = (Long)a - ((Date)b).getTime();
            return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
        }
        if (a instanceof Comparable && b instanceof Comparable && a.getClass() == b.getClass()) {
            return ((Comparable)a).compareTo(b);
        }
        throw new IllegalArgumentException("uncomparable objects " + a.getClass() + " ('" + a + "') vs " + b.getClass() + " ('" + b + ")");
    }

    public static Object add(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Long && b instanceof Long) {
            return (Long)a + (Long)b;
        }
        if (a instanceof Integer && b instanceof Integer) {
            return (long)((Integer)a + (Integer)b);
        }
        if (a instanceof Integer && b instanceof Long) {
            return (long)((Integer)a).intValue() + (Long)b;
        }
        if (a instanceof Long && b instanceof Integer) {
            return (Long)a + (long)((Integer)b).intValue();
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() + ((Number)b).doubleValue();
        }
        throw new IllegalArgumentException("cannot add " + a + " and " + b);
    }

    public static Object subtract(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Long && b instanceof Long) {
            return (Long)a - (Long)b;
        }
        if (a instanceof Integer && b instanceof Integer) {
            return (long)((Integer)a - (Integer)b);
        }
        if (a instanceof Integer && b instanceof Long) {
            return (long)((Integer)a).intValue() - (Long)b;
        }
        if (a instanceof Long && b instanceof Integer) {
            return (Long)a - (long)((Integer)b).intValue();
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() - ((Number)b).doubleValue();
        }
        throw new IllegalArgumentException("cannot subtract " + a + " and " + b);
    }

    public static Object multiply(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Long && b instanceof Long) {
            return (Long)a * (Long)b;
        }
        if (a instanceof Integer && b instanceof Integer) {
            return (long)((Integer)a * (Integer)b);
        }
        if (a instanceof Integer && b instanceof Long) {
            return (long)((Integer)a).intValue() * (Long)b;
        }
        if (a instanceof Long && b instanceof Integer) {
            return (Long)a * (long)((Integer)b).intValue();
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() * ((Number)b).doubleValue();
        }
        throw new IllegalArgumentException("cannot multiply " + a + " and " + b);
    }

    public static Object divide(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() / ((Number)b).doubleValue();
        }
        throw new IllegalArgumentException("cannot divide " + a + " and " + b);
    }

    public static boolean objectEquals(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof RawString) {
            return a.equals(b);
        }
        if (b instanceof RawString) {
            return b.equals(a);
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        if (a instanceof Date && b instanceof Date) {
            return ((Date)a).getTime() == ((Date)b).getTime();
        }
        if (a instanceof Boolean && Boolean.parseBoolean(b.toString()) == (Boolean)a) {
            return true;
        }
        if (b instanceof Boolean && Boolean.parseBoolean(a.toString()) == (Boolean)b) {
            return true;
        }
        return Objects.equals(a, b);
    }

    public static boolean objectNotEquals(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        return !SQLRecordPredicateFunctions.objectEquals(a, b);
    }

    public static Pattern compileLikePattern(String b) throws HerdDBInternalException {
        StringBuilder builder = new StringBuilder(b.length() + 18);
        builder.append("\\Q");
        int limit = b.length();
        block6: for (int idx = 0; idx < limit; ++idx) {
            char ch = b.charAt(idx);
            switch (ch) {
                case '%': {
                    builder.append("\\E.*\\Q");
                    continue block6;
                }
                case '_': {
                    builder.append("\\E.{1}\\Q");
                    continue block6;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        builder.append("\\E");
        String like = builder.toString();
        try {
            return Pattern.compile(like, 32);
        }
        catch (IllegalArgumentException err) {
            throw new HerdDBInternalException("Cannot compile LIKE expression '" + b + "': " + err);
        }
    }

    public static boolean like(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        Pattern pattern = SQLRecordPredicateFunctions.compileLikePattern(b.toString());
        return SQLRecordPredicateFunctions.matches(a, pattern);
    }

    public static boolean matches(Object a, Pattern pattern) {
        if (a == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(a.toString());
        return matcher.matches();
    }
}

