/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Random;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class RandomString {
    private static final char[] ALPHABET = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final RandomString INSTANCE = new RandomString(new Random(), ALPHABET);
    private char[] alphabet;
    private final Random random;

    public static RandomString getInstance() {
        return INSTANCE;
    }

    public RandomString(char[] alphabet) {
        this(RandomString.INSTANCE.random, alphabet);
    }

    public RandomString(Random random) {
        this(random, ALPHABET);
    }

    public RandomString(Random random, char[] alphabet) {
        this.random = random;
        this.alphabet = alphabet;
    }

    public String nextString(int len) {
        return this.nextString(len, new StringBuilder(len)).toString();
    }

    public String nextString(int min, int max) {
        int len = min == max ? min : this.random.nextInt(max - min) + min;
        return this.nextString(len);
    }

    public StringBuilder nextString(int len, StringBuilder builder) {
        for (int i = 0; i < len; ++i) {
            builder.append(this.alphabet[this.random.nextInt(this.alphabet.length)]);
        }
        return builder;
    }

    public StringBuilder nextString(int min, int max, StringBuilder builder) {
        int len = min == max ? min : this.random.nextInt(max - min) + min;
        return this.nextString(len, builder);
    }
}

