/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.Bytes;
import herddb.utils.ILocalLockManager;
import herddb.utils.LockHandle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;

public class LocalLockManager
implements ILocalLockManager {
    private int writeLockTimeout = 1800;
    private int readLockTimeout = 1800;
    private final ConcurrentMap<Bytes, LockInstance> locks = new ConcurrentHashMap<Bytes, LockInstance>();

    private StampedLock makeLock() {
        return new StampedLock();
    }

    private LockInstance makeLockForKey(Bytes key) {
        LockInstance instance = this.locks.compute(key, (k, existing) -> {
            if (existing != null) {
                ((LockInstance)existing).count++;
                return existing;
            }
            LockInstance lock = new LockInstance(this.makeLock(), 1);
            return lock;
        });
        return instance;
    }

    private void returnLockForKey(LockInstance instance, Bytes key) throws IllegalStateException {
        this.locks.compute(key, (t, u) -> {
            if (instance != u) {
                throw new IllegalStateException("trying to release un-owned lock");
            }
            if (--((LockInstance)u).count == 0) {
                return null;
            }
            return u;
        });
    }

    public int getWriteLockTimeout() {
        return this.writeLockTimeout;
    }

    public void setWriteLockTimeout(int writeLockTimeout) {
        this.writeLockTimeout = writeLockTimeout;
    }

    public int getReadLockTimeout() {
        return this.readLockTimeout;
    }

    public void setReadLockTimeout(int readLockTimeout) {
        this.readLockTimeout = readLockTimeout;
    }

    @Override
    public LockHandle acquireWriteLockForKey(Bytes key) {
        LockInstance lock = this.makeLockForKey(key);
        try {
            long tryWriteLock = lock.lock.tryWriteLock(this.writeLockTimeout, TimeUnit.SECONDS);
            if (tryWriteLock == 0L) {
                throw new RuntimeException("timed out acquiring lock for write");
            }
            return new LockHandle(tryWriteLock, key, true, lock);
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(err);
        }
    }

    @Override
    public void releaseWriteLock(LockHandle handle) {
        LockInstance instance = (LockInstance)handle.handle;
        instance.lock.unlockWrite(handle.stamp);
        this.returnLockForKey(instance, handle.key);
    }

    @Override
    public LockHandle acquireReadLockForKey(Bytes key) {
        LockInstance lock = this.makeLockForKey(key);
        try {
            long tryReadLock = lock.lock.tryReadLock(this.readLockTimeout, TimeUnit.SECONDS);
            if (tryReadLock == 0L) {
                throw new RuntimeException("timedout trying to read lock");
            }
            return new LockHandle(tryReadLock, key, false, lock);
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(err);
        }
    }

    @Override
    public void releaseReadLock(LockHandle handle) {
        LockInstance instance = (LockInstance)handle.handle;
        instance.lock.unlockRead(handle.stamp);
        this.returnLockForKey(instance, handle.key);
    }

    @Override
    public void releaseLock(LockHandle handle) {
        if (handle == null) {
            return;
        }
        if (handle.write) {
            this.releaseWriteLock(handle);
        } else {
            this.releaseReadLock(handle);
        }
    }

    @Override
    public void clear() {
        this.locks.clear();
    }

    @Override
    public int getNumKeys() {
        return this.locks.size();
    }

    private static class LockInstance {
        private final StampedLock lock;
        private int count;

        public LockInstance(StampedLock lock, int count) {
            this.lock = lock;
            this.count = count;
        }

        public String toString() {
            return "LockInstance{lock=" + this.lock + ", count=" + this.count + '}';
        }
    }
}

