/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CompareBytesUtils {
    private static final Logger LOG = Logger.getLogger(CompareBytesUtils.class.getName());

    private CompareBytesUtils() {
    }

    public static int compare(byte[] left, byte[] right) {
        int i = 0;
        for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
            int a = left[i] & 0xFF;
            int b = right[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return left.length - right.length;
    }

    public static boolean arraysEquals(byte[] left, byte[] right) {
        return Arrays.equals(left, right);
    }

    public static int compare(byte[] left, int fromIndex, int toIndex, byte[] right, int fromIndex2, int toIndex2) {
        int i = fromIndex;
        for (int j = fromIndex2; i < toIndex && j < toIndex2; ++i, ++j) {
            int a = left[i] & 0xFF;
            int b = right[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        int len1 = toIndex - fromIndex;
        int len2 = toIndex2 - fromIndex2;
        return len1 - len2;
    }

    public static boolean arraysEquals(byte[] left, int fromIndex, int toIndex, byte[] right, int fromIndex2, int toIndex2) {
        int aLength = toIndex - fromIndex;
        int bLength = toIndex2 - fromIndex2;
        if (aLength != bLength) {
            return false;
        }
        return PlatformDependent.equals((byte[])left, (int)fromIndex, (byte[])right, (int)fromIndex2, (int)aLength);
    }

    public static int hashCode(byte[] a, int offset, int length) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        int toIndex = length + offset;
        for (int i = offset; i < toIndex; ++i) {
            result = 31 * result + a[i];
        }
        return result;
    }

    static {
        LOG.info("Not Using Arrays#compare(byte[], byte[]). Using legacy pure-Java implementation, use JDK10 in order to get best performances");
    }
}

