/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.client.ScanResultSet;
import herddb.client.ScanResultSetMetadata;
import herddb.client.impl.EmptyScanResultSet;
import herddb.client.impl.MapListScanResultSet;
import herddb.jdbc.HerdDBConnection;
import herddb.jdbc.HerdDBResultSet;
import herddb.model.ColumnTypes;
import herddb.utils.SQLUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class HerdDBDatabaseMetadata
implements DatabaseMetaData {
    private final HerdDBConnection con;
    private final String tableSpace;
    private static final String[] GET_TABLES_SCHEMA = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"};
    private static final String[] GET_INDEXES_SCHEMA = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "FILTER_CONDITION"};
    private static final String[] GET_PRIMARYKEYS_SCHEMA = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ"};
    private static final String[] GET_SCHEMAS_SCHEMA = new String[]{"TABLE_SCHEM", "TABLE_CATALOG"};
    private static final String[] GET_COLUMNS_SCHEMA = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"};

    HerdDBDatabaseMetadata(HerdDBConnection con, String tableSpace) {
        this.con = con;
        this.tableSpace = tableSpace;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return "";
    }

    @Override
    public String getUserName() throws SQLException {
        return "";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "HerdDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "";
    }

    @Override
    public String getDriverName() throws SQLException {
        return "HerdDB";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "0.0";
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "'";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "tablespace";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "catalog";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String query = "SELECT table_name FROM SYSTABLES";
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            query = query + " WHERE table_name LIKE '" + SQLUtils.escape((String)tableNamePattern) + "'";
        }
        try (Statement statement = this.con.createStatement();){
            HerdDBResultSet herdDBResultSet;
            block14: {
                ResultSet rs = statement.executeQuery(query);
                try {
                    ArrayList results = new ArrayList();
                    while (rs.next()) {
                        String table_name = rs.getString("table_name");
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("TABLE_CAT", null);
                        data.put("TABLE_SCHEM", this.tableSpace);
                        data.put("TABLE_NAME", table_name);
                        data.put("TABLE_TYPE", "TABLE");
                        data.put("REMARKS", "");
                        data.put("TYPE_CAT", null);
                        data.put("TYPE_SCHEM", null);
                        data.put("TYPE_NAME", null);
                        data.put("SELF_REFERENCING_COL_NAME", null);
                        data.put("REF_GENERATION", null);
                        results.add(data);
                    }
                    ScanResultSetMetadata metadata = new ScanResultSetMetadata(GET_TABLES_SCHEMA);
                    herdDBResultSet = new HerdDBResultSet((ScanResultSet)new MapListScanResultSet(0L, metadata, GET_TABLES_SCHEMA, results));
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return herdDBResultSet;
        }
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String query = "SELECT tablespace_name FROM SYSTABLESPACES";
        if (schemaPattern != null && !schemaPattern.isEmpty()) {
            query = query + " WHERE tablespace_name LIKE '" + SQLUtils.escape((String)schemaPattern) + "'";
        }
        try (Statement statement = this.con.createStatement();){
            HerdDBResultSet herdDBResultSet;
            block14: {
                ResultSet rs = statement.executeQuery(query);
                try {
                    ArrayList results = new ArrayList();
                    while (rs.next()) {
                        String tablespace_name = rs.getString("tablespace_name");
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("TABLE_SCHEM", tablespace_name);
                        data.put("TABLE_CATALOG", null);
                        results.add(data);
                    }
                    ScanResultSetMetadata metadata = new ScanResultSetMetadata(GET_SCHEMAS_SCHEMA);
                    herdDBResultSet = new HerdDBResultSet((ScanResultSet)new MapListScanResultSet(0L, metadata, GET_SCHEMAS_SCHEMA, results));
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return herdDBResultSet;
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query = "SELECT table_name,column_name,data_type,type_name,auto_increment,is_nullable,ordinal_position FROM SYSCOLUMNS WHERE 1=1 ";
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            query = query + " AND table_name LIKE '" + SQLUtils.escape((String)tableNamePattern) + "'";
        }
        if (columnNamePattern != null && !columnNamePattern.isEmpty()) {
            query = query + " AND column_name LIKE '" + SQLUtils.escape((String)columnNamePattern) + "'";
        }
        try (Statement statement = this.con.createStatement();){
            HerdDBResultSet herdDBResultSet;
            block15: {
                ResultSet rs = statement.executeQuery(query);
                try {
                    ArrayList results = new ArrayList();
                    while (rs.next()) {
                        String table_name = rs.getString("table_name");
                        String column_name = rs.getString("column_name");
                        String data_type = rs.getString("data_type");
                        String type_name = rs.getString("type_name");
                        int auto_increment = rs.getInt("auto_increment");
                        int is_nullable = rs.getInt("is_nullable");
                        int ordinal_position = rs.getInt("ordinal_position");
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("TABLE_CAT", null);
                        data.put("TABLE_SCHEM", this.tableSpace);
                        data.put("TABLE_NAME", table_name);
                        data.put("COLUMN_NAME", column_name);
                        data.put("TYPE_NAME", type_name);
                        data.put("DATA_TYPE", ColumnTypes.sqlDataTypeToJdbcType((String)data_type));
                        data.put("COLUMN_SIZE", 0);
                        data.put("BUFFER_LENGTH", 0);
                        data.put("DECIMAL_DIGITS", null);
                        data.put("NUM_PREC_RADIX", null);
                        data.put("NULLABLE", is_nullable > 0 ? 1 : 0);
                        data.put("REMARKS", "");
                        data.put("COLUMN_DEF", "");
                        data.put("SQL_DATA_TYPE", "");
                        data.put("SQL_DATETIME_SUB", "");
                        data.put("CHAR_OCTET_LENGTH", Integer.MAX_VALUE);
                        data.put("ORDINAL_POSITION", ordinal_position);
                        data.put("IS_NULLABLE", is_nullable > 0 ? "YES" : "NO");
                        data.put("SCOPE_CATALOG", null);
                        data.put("SCOPE_SCHEMA", null);
                        data.put("SCOPE_TABLE", null);
                        data.put("SOURCE_DATA_TYPE", null);
                        data.put("IS_AUTOINCREMENT", auto_increment > 0 ? "YES" : "NO");
                        data.put("IS_GENERATEDCOLUMN", auto_increment > 0 ? "YES" : "NO");
                        results.add(data);
                    }
                    ScanResultSetMetadata metadata = new ScanResultSetMetadata(GET_COLUMNS_SCHEMA);
                    herdDBResultSet = new HerdDBResultSet((ScanResultSet)new MapListScanResultSet(0L, metadata, GET_COLUMNS_SCHEMA, results));
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return herdDBResultSet;
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT * FROM SYSINDEXCOLUMNS WHERE index_type='pk' ";
        if (table != null && !table.isEmpty()) {
            query = query + " AND table_name = '" + SQLUtils.escape((String)table) + "'";
        }
        try (Statement statement = this.con.createStatement();){
            HerdDBResultSet herdDBResultSet;
            block14: {
                ResultSet rs = statement.executeQuery(query);
                try {
                    ArrayList results = new ArrayList();
                    while (rs.next()) {
                        String table_name = rs.getString("table_name");
                        String column_name = rs.getString("column_name");
                        int ordinal_position = rs.getInt("ordinal_position");
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("TABLE_CAT", null);
                        data.put("TABLE_SCHEM", this.tableSpace);
                        data.put("TABLE_NAME", table_name);
                        data.put("COLUMN_NAME", column_name);
                        data.put("KEY_SEQ", ordinal_position);
                        results.add(data);
                    }
                    ScanResultSetMetadata metadata = new ScanResultSetMetadata(GET_PRIMARYKEYS_SCHEMA);
                    herdDBResultSet = new HerdDBResultSet((ScanResultSet)new MapListScanResultSet(0L, metadata, GET_PRIMARYKEYS_SCHEMA, results));
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return herdDBResultSet;
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    public ResultSet getIndexInfo(String catalog, String schema, String tableNamePattern, boolean onlyUnique, boolean approximate) throws SQLException {
        String query = "SELECT * FROM SYSINDEXCOLUMNS";
        if (tableNamePattern != null && !tableNamePattern.isEmpty()) {
            query = query + " WHERE table_name LIKE '" + SQLUtils.escape((String)tableNamePattern) + "'";
        }
        try (Statement statement = this.con.createStatement();){
            HerdDBResultSet herdDBResultSet;
            block14: {
                ResultSet rs = statement.executeQuery(query);
                try {
                    ArrayList results = new ArrayList();
                    while (rs.next()) {
                        boolean uniqueValues;
                        String table_name = rs.getString("table_name");
                        String index_name = rs.getString("index_name");
                        String column_name = rs.getString("column_name");
                        int ordinal_position = rs.getInt("ordinal_position");
                        boolean clustered = rs.getInt("clustered") == 1;
                        boolean bl = uniqueValues = rs.getInt("unique") == 1;
                        if (onlyUnique && !uniqueValues) continue;
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("TABLE_CAT", null);
                        data.put("TABLE_SCHEM", this.tableSpace);
                        data.put("TABLE_NAME", table_name);
                        data.put("NON_UNIQUE", !uniqueValues);
                        data.put("INDEX_QUALIFIER", null);
                        data.put("INDEX_NAME", index_name);
                        data.put("TYPE", clustered ? (short)1 : 3);
                        data.put("ORDINAL_POSITION", ordinal_position);
                        data.put("COLUMN_NAME", column_name);
                        data.put("ASC_OR_DESC", null);
                        data.put("CARDINALITY", null);
                        data.put("FILTER_CONDITION", null);
                        results.add(data);
                    }
                    ScanResultSetMetadata metadata = new ScanResultSetMetadata(GET_INDEXES_SCHEMA);
                    herdDBResultSet = new HerdDBResultSet((ScanResultSet)new MapListScanResultSet(0L, metadata, GET_INDEXES_SCHEMA, results));
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return herdDBResultSet;
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.con;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 1;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return new HerdDBResultSet((ScanResultSet)new EmptyScanResultSet(0L));
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

