/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.jdbc.BasicHerdDBDataSource;
import herddb.jdbc.HerdDBEmbeddedDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_INTERFACE"})
public class Driver
implements java.sql.Driver,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(Driver.class.getName());
    private static final Driver INSTANCE = new Driver();
    private final HashMap<String, HerdDBEmbeddedDataSource> datasources = new HashMap();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        HerdDBEmbeddedDataSource datasource = this.ensureDatasource(url, info);
        return datasource.getConnection();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith("jdbc:herddb:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return LOG;
    }

    private synchronized HerdDBEmbeddedDataSource ensureDatasource(String url, Properties info) {
        String key = url + "_" + info;
        HerdDBEmbeddedDataSource ds = this.datasources.get(key);
        if (ds != null) {
            return ds;
        }
        ds = new HerdDBEmbeddedDataSource(info);
        ds.setUrl(url);
        this.datasources.put(key, ds);
        return ds;
    }

    @Override
    public synchronized void close() {
        LOG.log(Level.SEVERE, "Unregistering HerdDB JDBC Driver");
        this.datasources.values().forEach(BasicHerdDBDataSource::close);
        this.datasources.clear();
    }

    public synchronized void closeDatasources(String url) {
        List entries = this.datasources.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(url + "_")).collect(Collectors.toList());
        for (Map.Entry entry : entries) {
            this.datasources.remove(entry.getKey());
            ((HerdDBEmbeddedDataSource)entry.getValue()).close();
        }
    }

    static {
        try {
            DriverManager.registerDriver(INSTANCE, () -> INSTANCE.close());
        }
        catch (SQLException error) {
            LOG.log(Level.SEVERE, "error while registring JDBC driver:" + error, error);
        }
    }
}

