/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import herddb.client.ClientConfiguration;
import herddb.client.ClientSideMetadataProviderException;
import herddb.client.HDBClient;
import herddb.client.HDBConnection;
import herddb.client.HDBException;
import herddb.jdbc.HerdDBConnection;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class BasicHerdDBDataSource
implements DataSource,
AutoCloseable {
    protected HDBClient client;
    protected final Properties properties = new Properties();
    protected int loginTimeout;
    protected int maxActive = 200;
    private static final Logger LOGGER = Logger.getLogger(BasicHerdDBDataSource.class.getName());
    protected String url;
    protected String defaultSchema = "herd";
    private String waitForTableSpace = "";
    private int waitForTableSpaceTimeout = 60000;
    private boolean discoverTableSpaceFromQuery = true;
    private HDBConnection connection;
    private GenericObjectPool<HerdDBConnection> pool;
    private PrintWriter logWriter;

    private synchronized HDBConnection getHDBConnection() {
        if (this.connection == null) {
            HDBClient _client = this.getClient();
            HDBConnection _connection = _client.openConnection();
            _connection.setDiscoverTablespaceFromSql(false);
            this.connection = _connection;
        }
        return this.connection;
    }

    public synchronized int getWaitForTableSpaceTimeout() {
        return this.waitForTableSpaceTimeout;
    }

    public synchronized void setWaitForTableSpaceTimeout(int waitForTableSpaceTimeout) {
        this.waitForTableSpaceTimeout = waitForTableSpaceTimeout;
    }

    public synchronized String getWaitForTableSpace() {
        return this.waitForTableSpace;
    }

    public synchronized void setWaitForTableSpace(String waitForTableSpace) {
        this.waitForTableSpace = waitForTableSpace;
    }

    public synchronized boolean isDiscoverTableSpaceFromQuery() {
        return this.discoverTableSpaceFromQuery;
    }

    public synchronized void setDiscoverTableSpaceFromQuery(boolean discoverTableSpaceFromQuery) {
        this.discoverTableSpaceFromQuery = discoverTableSpaceFromQuery;
    }

    protected BasicHerdDBDataSource() {
    }

    public BasicHerdDBDataSource(HDBClient client) {
        if (client == null) {
            throw new NullPointerException();
        }
        this.client = client;
    }

    public synchronized int getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public synchronized String getUsername() {
        if (this.client != null) {
            return this.client.getConfiguration().getString("user", "sa");
        }
        return this.properties.getProperty("user", "sa");
    }

    public synchronized void setUsername(String username) {
        this.properties.put("user", username);
        if (this.client != null) {
            this.client.getConfiguration().set("user", (Object)username);
        }
    }

    public synchronized String getPassword() {
        if (this.client != null) {
            return this.client.getConfiguration().getString("password", "hdb");
        }
        return this.properties.getProperty("password", "hdb");
    }

    public synchronized void setPassword(String password) {
        this.properties.put("password", password);
        if (this.client != null) {
            this.client.getConfiguration().set("password", (Object)password);
        }
    }

    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String url) {
        this.url = url;
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected synchronized void doWaitForTableSpace() throws SQLException {
        if (this.waitForTableSpaceTimeout > 0 && !this.waitForTableSpace.isEmpty()) {
            try (HDBConnection con = this.client.openConnection();){
                con.waitForTableSpace(this.waitForTableSpace, this.waitForTableSpaceTimeout);
            }
            catch (ClientSideMetadataProviderException | HDBException err) {
                throw new SQLException(err);
            }
        }
    }

    protected synchronized void ensureClient() throws SQLException {
        if (this.client == null) {
            ClientConfiguration clientConfiguration = new ClientConfiguration(this.properties);
            Properties propsNoPassword = new Properties();
            propsNoPassword.putAll((Map<?, ?>)this.properties);
            propsNoPassword.setProperty("password", "---");
            LOGGER.log(Level.INFO, "Booting HerdDB Client, url:" + this.url + ", properties:" + propsNoPassword + " clientConfig " + clientConfiguration);
            try {
                clientConfiguration.readJdbcUrl(this.url);
            }
            catch (RuntimeException err) {
                throw new SQLException(err);
            }
            if (this.properties.containsKey("discoverTableSpaceFromQuery")) {
                this.discoverTableSpaceFromQuery = clientConfiguration.getBoolean("discoverTableSpaceFromQuery", true);
            }
            this.client = new HDBClient(clientConfiguration);
        }
        if (this.pool == null) {
            if (this.properties.containsKey("maxActive")) {
                this.maxActive = Integer.parseInt(this.properties.get("maxActive").toString());
            }
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setBlockWhenExhausted(true);
            config.setMaxTotal(this.maxActive);
            config.setMaxIdle(this.maxActive);
            config.setMinIdle(this.maxActive / 2);
            config.setJmxNamePrefix("HerdDBClient");
            this.pool = new GenericObjectPool((PooledObjectFactory)new ConnectionsFactory(), config);
        }
    }

    protected synchronized void ensureConnection() throws SQLException {
        this.ensureClient();
    }

    public synchronized HDBClient getClient() {
        return this.client;
    }

    public synchronized void setClient(HDBClient client) {
        this.client = client;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.ensureConnection();
        try {
            return (Connection)this.pool.borrowObject();
        }
        catch (Exception err) {
            throw new SQLException(err);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return LOGGER;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    void releaseConnection(HerdDBConnection connection) {
        this.pool.returnObject((Object)connection);
    }

    private class ConnectionsFactory
    implements PooledObjectFactory<HerdDBConnection> {
        private ConnectionsFactory() {
        }

        public PooledObject<HerdDBConnection> makeObject() throws Exception {
            HerdDBConnection res = new HerdDBConnection(BasicHerdDBDataSource.this, BasicHerdDBDataSource.this.getHDBConnection(), BasicHerdDBDataSource.this.defaultSchema);
            return new DefaultPooledObject((Object)res);
        }

        public void destroyObject(PooledObject<HerdDBConnection> po) throws Exception {
            ((HerdDBConnection)po.getObject()).close();
        }

        public boolean validateObject(PooledObject<HerdDBConnection> po) {
            return true;
        }

        public void activateObject(PooledObject<HerdDBConnection> po) throws Exception {
            ((HerdDBConnection)po.getObject()).reset(BasicHerdDBDataSource.this.defaultSchema);
        }

        public void passivateObject(PooledObject<HerdDBConnection> po) throws Exception {
        }
    }
}

