/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Permutation;

public class ProjectMergeRule
extends RelOptRule {
    public static final int DEFAULT_BLOAT = 100;
    public static final ProjectMergeRule INSTANCE = new ProjectMergeRule(true, 100, RelFactories.LOGICAL_BUILDER);
    private final boolean force;
    private final int bloat;

    public ProjectMergeRule(boolean force, int bloat, RelBuilderFactory relBuilderFactory) {
        super(ProjectMergeRule.operand(Project.class, ProjectMergeRule.operand(Project.class, ProjectMergeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, "ProjectMergeRule" + (force ? ":force_mode" : ""));
        this.force = force;
        this.bloat = bloat;
    }

    @Deprecated
    public ProjectMergeRule(boolean force, RelBuilderFactory relBuilderFactory) {
        this(force, 100, relBuilderFactory);
    }

    @Deprecated
    public ProjectMergeRule(boolean force, RelFactories.ProjectFactory projectFactory) {
        this(force, RelBuilder.proto(projectFactory));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        RelBuilder relBuilder = call.builder();
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation != null) {
            if (topPermutation.isIdentity()) {
                return;
            }
            Permutation bottomPermutation = bottomProject.getPermutation();
            if (bottomPermutation != null) {
                if (bottomPermutation.isIdentity()) {
                    return;
                }
                Permutation product = topPermutation.product(bottomPermutation);
                relBuilder.push(bottomProject.getInput());
                relBuilder.project((Iterable<? extends RexNode>)relBuilder.fields(product), (Iterable<String>)topProject.getRowType().getFieldNames());
                call.transformTo(relBuilder.build());
                return;
            }
        }
        if (!this.force && RexUtil.isIdentity(topProject.getProjects(), topProject.getInput().getRowType())) {
            return;
        }
        List<RexNode> newProjects = RelOptUtil.pushPastProjectUnlessBloat(topProject.getProjects(), bottomProject, this.bloat);
        if (newProjects == null) {
            return;
        }
        RelNode input = bottomProject.getInput();
        if (RexUtil.isIdentity(newProjects, input.getRowType()) && (this.force || input.getRowType().getFieldNames().equals(topProject.getRowType().getFieldNames()))) {
            call.transformTo(input);
            return;
        }
        relBuilder.push(bottomProject.getInput());
        relBuilder.project(newProjects, topProject.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }
}

