/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;

public class RelMdMaxRowCount
implements MetadataHandler<BuiltInMetadata.MaxRowCount> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.MAX_ROW_COUNT.method, new RelMdMaxRowCount());

    @Override
    public MetadataDef<BuiltInMetadata.MaxRowCount> getDef() {
        return BuiltInMetadata.MaxRowCount.DEF;
    }

    public Double getMaxRowCount(Union rel, RelMetadataQuery mq) {
        double rowCount = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getMaxRowCount(input);
            if (partialRowCount == null) {
                return null;
            }
            rowCount += partialRowCount.doubleValue();
        }
        return rowCount;
    }

    public Double getMaxRowCount(Intersect rel, RelMetadataQuery mq) {
        Double rowCount = null;
        for (RelNode input : rel.getInputs()) {
            Double partialRowCount = mq.getMaxRowCount(input);
            if (rowCount != null && (partialRowCount == null || !(partialRowCount < rowCount))) continue;
            rowCount = partialRowCount;
        }
        return rowCount;
    }

    public Double getMaxRowCount(Minus rel, RelMetadataQuery mq) {
        return mq.getMaxRowCount(rel.getInput(0));
    }

    public Double getMaxRowCount(Filter rel, RelMetadataQuery mq) {
        if (rel.getCondition().isAlwaysFalse()) {
            return 0.0;
        }
        return mq.getMaxRowCount(rel.getInput());
    }

    public Double getMaxRowCount(Project rel, RelMetadataQuery mq) {
        return mq.getMaxRowCount(rel.getInput());
    }

    public Double getMaxRowCount(Exchange rel, RelMetadataQuery mq) {
        return mq.getMaxRowCount(rel.getInput());
    }

    public Double getMaxRowCount(Sort rel, RelMetadataQuery mq) {
        int limit;
        Double rowCount = mq.getMaxRowCount(rel.getInput());
        if (rowCount == null) {
            rowCount = Double.POSITIVE_INFINITY;
        }
        int offset = rel.offset == null ? 0 : RexLiteral.intValue(rel.offset);
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        if (rel.fetch != null && (double)(limit = RexLiteral.intValue(rel.fetch)) < rowCount) {
            return limit;
        }
        return rowCount;
    }

    public Double getMaxRowCount(EnumerableLimit rel, RelMetadataQuery mq) {
        int limit;
        Double rowCount = mq.getMaxRowCount(rel.getInput());
        if (rowCount == null) {
            rowCount = Double.POSITIVE_INFINITY;
        }
        int offset = rel.offset == null ? 0 : RexLiteral.intValue(rel.offset);
        rowCount = Math.max(rowCount - (double)offset, 0.0);
        if (rel.fetch != null && (double)(limit = RexLiteral.intValue(rel.fetch)) < rowCount) {
            return limit;
        }
        return rowCount;
    }

    public Double getMaxRowCount(Aggregate rel, RelMetadataQuery mq) {
        RelOptPredicateList predicateList;
        if (rel.getGroupSet().isEmpty()) {
            return 1.0;
        }
        if (rel.getGroupType() == Aggregate.Group.SIMPLE && (predicateList = mq.getPulledUpPredicates(rel.getInput())) != null && RelMdMaxRowCount.allGroupKeysAreConstant(rel, predicateList)) {
            return 1.0;
        }
        Double rowCount = mq.getMaxRowCount(rel.getInput());
        if (rowCount == null) {
            return null;
        }
        return rowCount * (double)rel.getGroupSets().size();
    }

    private static boolean allGroupKeysAreConstant(Aggregate aggregate, RelOptPredicateList predicateList) {
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        for (int key : aggregate.getGroupSet()) {
            if (predicateList.constantMap.containsKey((Object)rexBuilder.makeInputRef(aggregate.getInput(), key))) continue;
            return false;
        }
        return true;
    }

    public Double getMaxRowCount(Join rel, RelMetadataQuery mq) {
        Double left = mq.getMaxRowCount(rel.getLeft());
        Double right = mq.getMaxRowCount(rel.getRight());
        if (left == null || right == null) {
            return null;
        }
        if (left < 1.0 && rel.getJoinType().generatesNullsOnLeft()) {
            left = 1.0;
        }
        if (right < 1.0 && rel.getJoinType().generatesNullsOnRight()) {
            right = 1.0;
        }
        return left * right;
    }

    public Double getMaxRowCount(TableScan rel, RelMetadataQuery mq) {
        return Double.POSITIVE_INFINITY;
    }

    public Double getMaxRowCount(Values values, RelMetadataQuery mq) {
        return values.getTuples().size();
    }

    public Double getMaxRowCount(TableModify rel, RelMetadataQuery mq) {
        return mq.getMaxRowCount(rel.getInput());
    }

    public Double getMaxRowCount(RelSubset rel, RelMetadataQuery mq) {
        Util.discard(false);
        for (RelNode node : rel.getRels()) {
            if (!(node instanceof Sort)) continue;
            Sort sort = (Sort)node;
            if (sort.fetch == null) continue;
            return RexLiteral.intValue(sort.fetch);
        }
        return Double.POSITIVE_INFINITY;
    }

    public Double getMaxRowCount(RelNode rel, RelMetadataQuery mq) {
        return null;
    }
}

