/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.JoinType;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Predicate2;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class EnumUtils {
    static final boolean BRIDGE_METHODS = true;
    static final List<ParameterExpression> NO_PARAMS = ImmutableList.of();
    static final List<Expression> NO_EXPRS = ImmutableList.of();
    public static final List<String> LEFT_RIGHT = ImmutableList.of((Object)"left", (Object)"right");

    private EnumUtils() {
    }

    public static MethodDeclaration overridingMethodDecl(Method method, Iterable<ParameterExpression> parameters, BlockStatement body) {
        return Expressions.methodDecl((int)(method.getModifiers() & 0xFFFFFBFF), method.getReturnType(), (String)method.getName(), parameters, (BlockStatement)body);
    }

    static Type javaClass(JavaTypeFactory typeFactory, RelDataType type) {
        Type clazz = typeFactory.getJavaClass(type);
        return clazz instanceof Class ? clazz : Object[].class;
    }

    static List<Type> fieldTypes(final JavaTypeFactory typeFactory, final List<? extends RelDataType> inputTypes) {
        return new AbstractList<Type>(){

            @Override
            public Type get(int index) {
                return EnumUtils.javaClass(typeFactory, (RelDataType)inputTypes.get(index));
            }

            @Override
            public int size() {
                return inputTypes.size();
            }
        };
    }

    static List<RelDataType> fieldRowTypes(RelDataType inputRowType, final List<? extends RexNode> extraInputs, final List<Integer> argList) {
        final List<RelDataTypeField> inputFields = inputRowType.getFieldList();
        return new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                int arg = (Integer)argList.get(index);
                return arg < inputFields.size() ? ((RelDataTypeField)inputFields.get(arg)).getType() : ((RexNode)extraInputs.get(arg - inputFields.size())).getType();
            }

            @Override
            public int size() {
                return argList.size();
            }
        };
    }

    static Expression joinSelector(JoinRelType joinType, PhysType physType, List<PhysType> inputPhysTypes) {
        ArrayList<ParameterExpression> parameters = new ArrayList<ParameterExpression>();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int outputFieldCount = physType.getRowType().getFieldCount();
        for (Ord ord : Ord.zip(inputPhysTypes)) {
            PhysType inputPhysType = ((PhysType)ord.e).makeNullable(joinType.generatesNullsOn(ord.i));
            ParameterExpression parameter = Expressions.parameter((Type)Primitive.box((Type)inputPhysType.getJavaRowType()), (String)LEFT_RIGHT.get(ord.i));
            parameters.add(parameter);
            if (expressions.size() == outputFieldCount) break;
            int fieldCount = inputPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                Expression expression = inputPhysType.fieldReference((Expression)parameter, i, physType.getJavaFieldType(expressions.size()));
                if (joinType.generatesNullsOn(ord.i)) {
                    expression = Expressions.condition((Expression)Expressions.equal((Expression)parameter, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)expression);
                }
                expressions.add(expression);
            }
        }
        return Expressions.lambda(Function2.class, (Expression)physType.record(expressions), parameters);
    }

    static Expression toInternal(Expression operand, Type targetType) {
        return EnumUtils.toInternal(operand, operand.getType(), targetType);
    }

    private static Expression toInternal(Expression operand, Type fromType, Type targetType) {
        if (fromType == Date.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call((Method)BuiltInMethod.DATE_TO_INT.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Integer.class) {
                return Expressions.call((Method)BuiltInMethod.DATE_TO_INT_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        } else if (fromType == Time.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call((Method)BuiltInMethod.TIME_TO_INT.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Integer.class) {
                return Expressions.call((Method)BuiltInMethod.TIME_TO_INT_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        } else if (fromType == Timestamp.class) {
            if (targetType == Long.TYPE) {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Long.class) {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        }
        return operand;
    }

    private static Expression fromInternal(Expression operand, Type targetType) {
        return EnumUtils.fromInternal(operand, operand.getType(), targetType);
    }

    private static Expression fromInternal(Expression operand, Type fromType, Type targetType) {
        if (operand == ConstantUntypedNull.INSTANCE) {
            return operand;
        }
        if (!(operand.getType() instanceof Class)) {
            return operand;
        }
        if (Types.isAssignableFrom((Type)targetType, (Type)fromType)) {
            return operand;
        }
        if (targetType == Date.class) {
            if (EnumUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_DATE.method, (Expression[])new Expression[]{operand});
            }
        } else if (targetType == Time.class) {
            if (EnumUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIME.method, (Expression[])new Expression[]{operand});
            }
        } else if (targetType == Timestamp.class && EnumUtils.isA(fromType, Primitive.LONG)) {
            return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand});
        }
        if (Primitive.is((Type)operand.type) && Primitive.isBox((Type)targetType)) {
            return Expressions.convert_((Expression)operand, (Type)Primitive.ofBox((Type)targetType).primitiveClass);
        }
        return operand;
    }

    static List<Expression> fromInternal(Class<?>[] targetTypes, List<Expression> expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == expressions.size()) {
            for (int i = 0; i < expressions.size(); ++i) {
                list.add(EnumUtils.fromInternal(expressions.get(i), targetTypes[i]));
            }
        } else {
            int j = 0;
            for (int i = 0; i < expressions.size(); ++i) {
                Class<?> type;
                if (!targetTypes[j].isArray()) {
                    type = targetTypes[j];
                    ++j;
                } else {
                    type = targetTypes[j].getComponentType();
                }
                list.add(EnumUtils.fromInternal(expressions.get(i), type));
            }
        }
        return list;
    }

    static Type fromInternal(Type type) {
        if (type == Date.class || type == Time.class) {
            return Integer.TYPE;
        }
        if (type == Timestamp.class) {
            return Long.TYPE;
        }
        return type;
    }

    private static Type toInternal(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case DATE: 
            case TIME: {
                return type.isNullable() ? Integer.class : Integer.TYPE;
            }
            case TIMESTAMP: {
                return type.isNullable() ? Long.class : Long.TYPE;
            }
        }
        return null;
    }

    static List<Type> internalTypes(List<? extends RexNode> operandList) {
        return Util.transform(operandList, node -> EnumUtils.toInternal(node.getType()));
    }

    public static Expression convert(Expression operand, Type toType) {
        Type fromType = operand.getType();
        return EnumUtils.convert(operand, fromType, toType);
    }

    public static Expression convert(Expression operand, Type fromType, Type toType) {
        Expression originTypedOperand;
        Expression internalTypedOperand;
        boolean fromNumber;
        if (!Types.needTypeCast((Type)fromType, (Type)toType)) {
            return operand;
        }
        Primitive toPrimitive = Primitive.of((Type)toType);
        Primitive toBox = Primitive.ofBox((Type)toType);
        Primitive fromBox = Primitive.ofBox((Type)fromType);
        Primitive fromPrimitive = Primitive.of((Type)fromType);
        boolean bl = fromNumber = fromType instanceof Class && Number.class.isAssignableFrom((Class)fromType);
        if (fromType == String.class) {
            if (toPrimitive != null) {
                switch (toPrimitive) {
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toPrimitive.boxClass, (String)("parse" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
            }
            if (toBox != null) {
                switch (toBox) {
                    case CHAR: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toBox.primitiveName) + "Boxed"), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toBox.boxClass, (String)"valueOf", (Expression[])new Expression[]{operand});
            }
        }
        if (toPrimitive != null) {
            if (fromPrimitive != null) {
                return Expressions.convert_((Expression)operand, (Type)toPrimitive.primitiveClass);
            }
            if (fromNumber || fromBox == Primitive.CHAR) {
                return Expressions.unbox((Expression)operand, (Primitive)toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap(toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
        }
        if (fromNumber && toBox != null) {
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.box((Expression)Expressions.unbox((Expression)operand, (Primitive)toBox), (Primitive)toBox));
        }
        if (fromPrimitive != null && toBox != null) {
            if (operand instanceof UnaryExpression) {
                Primitive origin;
                UnaryExpression una = (UnaryExpression)operand;
                if (una.nodeType == ExpressionType.Convert && Primitive.of((Type)una.getType()) == toBox && (origin = Primitive.of((Type)una.expression.type)) != null && toBox.assignableFrom(origin)) {
                    return Expressions.box((Expression)una.expression, (Primitive)toBox);
                }
            }
            if (fromType == toBox.primitiveClass) {
                return Expressions.box((Expression)operand, (Primitive)toBox);
            }
            return Expressions.box((Expression)Expressions.convert_((Expression)operand, (Type)toBox.primitiveClass), (Primitive)toBox);
        }
        if (EnumUtils.representAsInternalType(fromType) && operand != (internalTypedOperand = EnumUtils.toInternal(operand, fromType, toType))) {
            return internalTypedOperand;
        }
        if (EnumUtils.representAsInternalType(toType) && operand != (originTypedOperand = EnumUtils.fromInternal(operand, fromType, toType))) {
            return originTypedOperand;
        }
        if (toType == BigDecimal.class) {
            if (fromBox != null) {
                return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{Expressions.unbox((Expression)operand, (Primitive)fromBox)}));
            }
            if (fromPrimitive != null) {
                return Expressions.new_(BigDecimal.class, (Expression[])new Expression[]{operand});
            }
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(SqlFunctions.class, (String)"toBigDecimal", (Expression[])new Expression[]{operand}));
        }
        if (toType == String.class) {
            Expression result;
            if (fromPrimitive != null) {
                switch (fromPrimitive) {
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)fromPrimitive.boxClass, (String)"toString", (Expression[])new Expression[]{operand});
            }
            if (fromType == BigDecimal.class) {
                return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand}));
            }
            try {
                if (operand instanceof ConstantExpression) {
                    ConstantExpression ce = (ConstantExpression)operand;
                    if (ce.value == null) {
                        return Expressions.convert_((Expression)operand, (Type)toType);
                    }
                }
                result = Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call((Expression)operand, (String)"toString", (Expression[])new Expression[0]));
            }
            catch (RuntimeException e) {
                return Expressions.convert_((Expression)operand, (Type)toType);
            }
            return result;
        }
        return Expressions.convert_((Expression)operand, (Type)toType);
    }

    private static boolean isA(Type fromType, Primitive primitive) {
        return Primitive.of((Type)fromType) == primitive || Primitive.ofBox((Type)fromType) == primitive;
    }

    private static boolean representAsInternalType(Type type) {
        return type == Date.class || type == Time.class || type == Timestamp.class;
    }

    static List<Expression> convertAssignableTypes(Class<?>[] targetTypes, List<Expression> arguments) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == arguments.size()) {
            for (int i = 0; i < arguments.size(); ++i) {
                list.add(EnumUtils.convertAssignableType(arguments.get(i), targetTypes[i]));
            }
        } else {
            int j = 0;
            for (Expression argument : arguments) {
                Class<?> type;
                if (!targetTypes[j].isArray()) {
                    type = targetTypes[j];
                    ++j;
                } else {
                    type = targetTypes[j].getComponentType();
                }
                list.add(EnumUtils.convertAssignableType(argument, type));
            }
        }
        return list;
    }

    private static Expression convertAssignableType(Expression argument, Type targetType) {
        if (targetType != BigDecimal.class) {
            return argument;
        }
        return EnumUtils.convert(argument, targetType);
    }

    public static MethodCallExpression call(Class clazz, String methodName, List<? extends Expression> arguments) {
        return EnumUtils.call(clazz, methodName, arguments, null);
    }

    public static MethodCallExpression call(Class clazz, String methodName, List<? extends Expression> arguments, Expression targetExpression) {
        Object[] argumentTypes = Types.toClassArray(arguments);
        try {
            Method candidate = clazz.getMethod(methodName, (Class<?>[])argumentTypes);
            return Expressions.call((Expression)targetExpression, (Method)candidate, arguments);
        }
        catch (NoSuchMethodException e) {
            for (Method method : clazz.getMethods()) {
                Class[] parameterTypes;
                if (!method.getName().equals(methodName)) continue;
                boolean varArgs = method.isVarArgs();
                if (Types.allAssignable((boolean)varArgs, (Class[])(parameterTypes = method.getParameterTypes()), (Class[])argumentTypes)) {
                    return Expressions.call((Expression)targetExpression, (Method)method, arguments);
                }
                List<? extends Expression> typeMatchedArguments = EnumUtils.matchMethodParameterTypes(varArgs, parameterTypes, arguments);
                if (typeMatchedArguments == null) continue;
                return Expressions.call((Expression)targetExpression, (Method)method, typeMatchedArguments);
            }
            throw new RuntimeException("while resolving method '" + methodName + Arrays.toString(argumentTypes) + "' in class " + clazz, e);
        }
    }

    private static List<? extends Expression> matchMethodParameterTypes(boolean varArgs, Class[] parameterTypes, List<? extends Expression> arguments) {
        if (varArgs && arguments.size() < parameterTypes.length - 1 || !varArgs && arguments.size() != parameterTypes.length) {
            return null;
        }
        ArrayList<Expression> typeMatchedArguments = new ArrayList<Expression>();
        for (int i = 0; i < arguments.size(); ++i) {
            Class<Object> parameterType = !varArgs || i < parameterTypes.length - 1 ? parameterTypes[i] : Object.class;
            Expression typeMatchedArgument = EnumUtils.matchMethodParameterType(arguments.get(i), parameterType);
            if (typeMatchedArgument == null) {
                return null;
            }
            typeMatchedArguments.add(typeMatchedArgument);
        }
        return typeMatchedArguments;
    }

    private static Expression matchMethodParameterType(Expression argument, Class parameter) {
        Type argumentType = argument.getType();
        if (Types.isAssignableFrom((Type)parameter, (Type)argumentType)) {
            return argument;
        }
        if (parameter == Object.class && Primitive.of((Type)argumentType) != null) {
            return argument;
        }
        if (argumentType == Object.class && Primitive.of((Type)argumentType) == null) {
            return EnumUtils.convert(argument, parameter);
        }
        if (parameter == BigDecimal.class && Primitive.ofBoxOr((Type)argumentType) != null) {
            return EnumUtils.convert(argument, parameter);
        }
        return null;
    }

    static JoinType toLinq4jJoinType(JoinRelType joinRelType) {
        switch (joinRelType) {
            case INNER: {
                return JoinType.INNER;
            }
            case LEFT: {
                return JoinType.LEFT;
            }
            case RIGHT: {
                return JoinType.RIGHT;
            }
            case FULL: {
                return JoinType.FULL;
            }
            case SEMI: {
                return JoinType.SEMI;
            }
            case ANTI: {
                return JoinType.ANTI;
            }
        }
        throw new IllegalStateException("Unable to convert " + (Object)((Object)joinRelType) + " to Linq4j JoinType");
    }

    static Expression generatePredicate(EnumerableRelImplementor implementor, RexBuilder rexBuilder, RelNode left, RelNode right, PhysType leftPhysType, PhysType rightPhysType, RexNode condition) {
        BlockBuilder builder = new BlockBuilder();
        ParameterExpression left_ = Expressions.parameter((Type)leftPhysType.getJavaRowType(), (String)"left");
        ParameterExpression right_ = Expressions.parameter((Type)rightPhysType.getJavaRowType(), (String)"right");
        RexProgramBuilder program = new RexProgramBuilder(((RelDataTypeFactory.FieldInfoBuilder)implementor.getTypeFactory().builder().addAll(left.getRowType().getFieldList())).addAll(right.getRowType().getFieldList()).build(), rexBuilder);
        program.addCondition(condition);
        builder.add((Statement)Expressions.return_(null, (Expression)RexToLixTranslator.translateCondition(program.getProgram(), implementor.getTypeFactory(), builder, new RexToLixTranslator.InputGetterImpl((List<Pair<Expression, PhysType>>)ImmutableList.of(Pair.of(left_, leftPhysType), Pair.of(right_, rightPhysType))), implementor.allCorrelateVariables, implementor.getConformance())));
        return Expressions.lambda(Predicate2.class, (BlockStatement)builder.toBlock(), (ParameterExpression[])new ParameterExpression[]{left_, right_});
    }

    static Expression windowSelector(PhysType inputPhysType, PhysType outputPhysType, Expression wmColExpr, Expression intervalExpr) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        ParameterExpression parameter = Expressions.parameter((Type)Primitive.box((Type)inputPhysType.getJavaRowType()), (String)"_input");
        int fieldCount = inputPhysType.getRowType().getFieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            Expression expression = inputPhysType.fieldReference((Expression)parameter, i, outputPhysType.getJavaFieldType(expressions.size()));
            expressions.add(expression);
        }
        Expression wmColExprToLong = EnumUtils.convert(wmColExpr, Long.TYPE);
        ConstantExpression shiftExpr = Expressions.constant((Object)1, Long.TYPE);
        expressions.add((Expression)Expressions.multiply((Expression)Expressions.divide((Expression)wmColExprToLong, (Expression)intervalExpr), (Expression)intervalExpr));
        expressions.add((Expression)Expressions.multiply((Expression)Expressions.add((Expression)Expressions.divide((Expression)wmColExprToLong, (Expression)intervalExpr), (Expression)shiftExpr), (Expression)intervalExpr));
        return Expressions.lambda(Function1.class, (Expression)outputPhysType.record(expressions), (ParameterExpression[])new ParameterExpression[]{parameter});
    }
}

